/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls.nlg.en;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.ls.nlg.en.LsPreProcessorEN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.XMLLexicon;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.PPPhraseSpec;
import simplenlg.phrasespec.SPhraseSpec;
import simplenlg.realiser.english.Realiser;

public class LinkSpecSummeryEN {
    private static Logger logger = LoggerFactory.getLogger(LinkSpecSummeryEN.class);
    private List<NLGElement> allOperator = new ArrayList<NLGElement>();
    private String AggregationResult = "";
    private Lexicon lexicon = new XMLLexicon();
    protected NLGFactory nlgFactory = new NLGFactory(this.lexicon);
    private NPPhraseSpec name;
    private NPPhraseSpec measureName;
    private NPPhraseSpec theta;
    protected String previousSubject = "";
    private String previousStringTheta = "";
    private List<NLGElement> result = new ArrayList<NLGElement>();
    protected CoordinatedPhraseElement objCollection = this.nlgFactory.createCoordinatedPhrase();

    protected List<NLGElement> fullMeasureNLG(LinkSpecification linkspec) {
        SPhraseSpec clause = this.nlgFactory.createClause();
        LsPreProcessorEN lsPreProcessor = new LsPreProcessorEN();
        if (linkspec.isAtomic()) {
            NPPhraseSpec name = lsPreProcessor.atomicSimilarity(linkspec);
            NPPhraseSpec resourceValue = lsPreProcessor.resourceValue(linkspec);
            NPPhraseSpec theta = lsPreProcessor.theta(linkspec);
            CoordinatedPhraseElement coordinate = lsPreProcessor.coordinate(linkspec);
            double d = linkspec.getLowThreshold();
        } else {
            for (int i = 0; i < linkspec.getChildren().size(); ++i) {
                String operatorAsString = linkspec.getOperator().toString().toLowerCase();
                NPPhraseSpec operator = new NPPhraseSpec(this.nlgFactory);
                operator.addComplement(operatorAsString);
                Realiser realiser2 = new Realiser(this.lexicon);
                NLGElement realised2 = realiser2.realise((NLGElement)operator);
                if (!this.allOperator.isEmpty()) {
                    this.AggregationResult = this.AggregationResult + "," + realised2.toString();
                }
                this.allOperator.add(realised2);
                LinkSpecification linkSpecification = linkspec.getChildren().get(i);
                if (linkSpecification.isAtomic()) {
                    this.name = lsPreProcessor.atomicSimilarity(linkSpecification);
                    this.theta = lsPreProcessor.theta(linkSpecification);
                    CoordinatedPhraseElement coordinate = lsPreProcessor.coordinate(linkSpecification);
                    String rightProp2 = lsPreProcessor.leftProperty(linkSpecification);
                    String leftProp2 = lsPreProcessor.rightProperty(linkSpecification);
                    NPPhraseSpec firstSubject = this.subject(coordinate, rightProp2, leftProp2);
                    double d = linkSpecification.getThreshold();
                    Object stringTheta = "";
                    if (d == 1.0) {
                        stringTheta = " exact match of";
                        this.name.addPreModifier((String)stringTheta);
                    }
                    if (d == 0.0) {
                        stringTheta = "complete mismatch of";
                        this.name.addPreModifier((String)stringTheta);
                    }
                    if (d > 0.0 && d < 1.0) {
                        Realiser clause2Realiser = new Realiser(this.lexicon);
                        NLGElement thetaRealised = clause2Realiser.realise((NLGElement)this.theta);
                        String thetaAString = thetaRealised.toString();
                        stringTheta = thetaAString + " of ";
                        this.name.addPreModifier((String)stringTheta);
                    }
                    this.measureName = lsPreProcessor.atomicSimilarity(linkSpecification);
                    Realiser firstSubjectRealiser = new Realiser(this.lexicon);
                    NLGElement firstSubjectRealised = firstSubjectRealiser.realise((NLGElement)firstSubject);
                    if (this.previousSubject.equals(firstSubjectRealised.toString())) {
                        this.objCollection.addCoordinate((Object)operator);
                        this.objCollection.setFeature("conjunction", (Object)"");
                        if (this.previousStringTheta.equals(stringTheta)) {
                            this.objCollection.setFeature("conjunction", (Object)"");
                            this.objCollection.addCoordinate((Object)this.measureName);
                            continue;
                        }
                        this.objCollection.setFeature("conjunction", (Object)"");
                        this.objCollection.addCoordinate((Object)this.name);
                        this.previousStringTheta = stringTheta;
                        continue;
                    }
                    if (!this.objCollection.getChildren().isEmpty()) {
                        clause.setSubject((Object)this.previousSubject);
                        clause.setVerb((Object)"have");
                        clause.setObject((Object)this.objCollection);
                        Realiser clauseRealiser = new Realiser(this.lexicon);
                        NLGElement clauseRealised = clauseRealiser.realise((NLGElement)clause);
                        this.result.add(clauseRealised);
                        this.result.add(realised2);
                        this.objCollection.clearCoordinates();
                        this.previousSubject = firstSubjectRealised.toString();
                        this.objCollection.setFeature("conjunction", (Object)"");
                        this.objCollection.addCoordinate((Object)this.name);
                        continue;
                    }
                    this.previousSubject = firstSubjectRealised.toString();
                    this.objCollection.addCoordinate((Object)this.name);
                    this.objCollection.setFeature("conjunction", (Object)"");
                    continue;
                }
                this.fullMeasureNLG(linkSpecification);
            }
        }
        return this.result;
    }

    public NPPhraseSpec subject(CoordinatedPhraseElement coordinate, String leftProp, String rightProp) {
        NPPhraseSpec subject = this.nlgFactory.createNounPhrase();
        String p = "the " + leftProp + " of the source and the target resources";
        PPPhraseSpec pp = this.nlgFactory.createPrepositionPhrase((Object)p);
        if (rightProp.equals(leftProp)) {
            subject.addComplement((NLGElement)pp);
            return subject;
        }
        subject.addComplement((NLGElement)coordinate);
        return subject;
    }
}

