/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.KBInfo;

public abstract class AConfigurationReader {
    protected String fileNameOrUri = new String();
    protected Configuration configuration = new Configuration();

    public AConfigurationReader(String fileNameOrUri) {
        this.fileNameOrUri = fileNameOrUri;
    }

    public abstract Configuration read();

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public static void replaceURIsWithPrefixes(KBInfo info) {
        Map<String, String> prefixes = info.getPrefixes();
        HashMap<String, String> rev = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : prefixes.entrySet()) {
            rev.put(entry.getValue(), entry.getKey());
        }
        info.setProperties(AConfigurationReader.replaceURIsWithPrefixes(info.getProperties(), rev));
        info.setOptionalProperties(AConfigurationReader.replaceURIsWithPrefixes(info.getOptionalProperties(), rev));
        info.setRestrictions(AConfigurationReader.replaceURIsWithPrefixes(info.getRestrictions(), rev));
        info.setFunctions(AConfigurationReader.replaceURIsWithPrefixes(info.getFunctions(), rev));
    }

    private static ArrayList<String> replaceURIsWithPrefixes(Collection<String> props, HashMap<String, String> rev) {
        ArrayList<String> replacements = new ArrayList<String>();
        Iterator<String> iterator = props.iterator();
        while (iterator.hasNext()) {
            String property;
            String originalProp = property = iterator.next();
            for (Map.Entry<String, String> prefixEntry : rev.entrySet()) {
                if (!property.contains(prefixEntry.getKey())) continue;
                property = property.replace(prefixEntry.getKey(), prefixEntry.getValue() + ":");
            }
            replacements.add(property);
            if (!property.contains("://")) continue;
            throw new IllegalArgumentException("LIMES does not support using URIs in the properties, optionalProperties, restrictions, or functions in the configuration file. Please define a prefix and use the prefix for the following URI: " + originalProp);
        }
        return replacements;
    }

    private static LinkedHashMap<String, Map<String, String>> replaceURIsWithPrefixes(Map<String, Map<String, String>> funcs, HashMap<String, String> rev) {
        LinkedHashMap<String, Map<String, String>> replacements = new LinkedHashMap<String, Map<String, String>>();
        for (Map.Entry<String, Map<String, String>> entry : funcs.entrySet()) {
            String property;
            String originalProp = property = entry.getKey();
            for (Map.Entry<String, String> prefixEntry : rev.entrySet()) {
                if (!property.contains(prefixEntry.getKey())) continue;
                property = property.replace(prefixEntry.getKey(), prefixEntry.getValue() + ":");
            }
            if (property.contains("://")) {
                throw new IllegalArgumentException("LIMES does not support using namespace IRIs in the properties, optionalProperties, restrictions, or functions in the configuration file. Please define a prefix and use the prefix for the namespace of the following IRI: " + originalProp);
            }
            HashMap<String, String> intermediateReplacement = new HashMap<String, String>();
            for (Map.Entry<String, String> stringEntry : entry.getValue().entrySet()) {
                String subKey;
                String origSubKey = subKey = stringEntry.getKey();
                for (Map.Entry<String, String> prefixEntry : rev.entrySet()) {
                    subKey = subKey.replace(prefixEntry.getKey(), prefixEntry.getValue() + ":");
                }
                intermediateReplacement.put(subKey, stringEntry.getValue());
                if (!subKey.contains("://")) continue;
                throw new IllegalArgumentException("LIMES does not support using namespace IRIs in the properties, optionalProperties, restrictions, or functions in the configuration file. Please define a prefix and use the prefix for the namespace of the following IRI: " + origSubKey);
            }
            replacements.put(property, intermediateReplacement);
        }
        return replacements;
    }
}

