/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.planner;

import java.util.ArrayList;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.ls.LinkSpecification;

public class CanonicalPlanner
extends Planner {
    @Override
    public NestedPlan plan(LinkSpecification spec) {
        NestedPlan plan = new NestedPlan();
        if (spec == null) {
            return plan;
        }
        if (spec.isEmpty()) {
            return plan;
        }
        if (spec.isAtomic()) {
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.getFilterExpression(), "" + spec.getThreshold(), -1, -1, 0));
        } else {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child);
                children.add(childPlan);
            }
            plan.setSubPlans(children);
            if (spec.getOperator().equals((Object)LogicOperator.AND)) {
                plan.setOperator(Instruction.Command.INTERSECTION);
            } else if (spec.getOperator().equals((Object)LogicOperator.OR)) {
                plan.setOperator(Instruction.Command.UNION);
            } else if (spec.getOperator().equals((Object)LogicOperator.XOR)) {
                plan.setOperator(Instruction.Command.XOR);
            } else if (spec.getOperator().equals((Object)LogicOperator.MINUS)) {
                plan.setOperator(Instruction.Command.DIFF);
            } else {
                System.out.println("Wrong operator: " + spec.getOperator() + ". at LS: " + spec);
                return null;
            }
            plan.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), "" + spec.getThreshold(), -1, -1, 0));
        }
        return plan;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public LinkSpecification normalize(LinkSpecification spec) {
        return spec;
    }
}

