/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluationDataLoader;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Experiment {
    static Logger logger = LoggerFactory.getLogger(Experiment.class);
    static String SEPARATOR = "\t";
    static String CSVSEPARATOR = ",";

    public static AMapping readOAEIMapping(String file) {
        AMapping m = MappingFactory.createDefaultMapping();
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String s = reader.readLine();
            String e1 = "";
            while (s != null) {
                if (s.contains("entity1")) {
                    e1 = s.substring(s.indexOf("=") + 2, s.lastIndexOf(">") - 2);
                } else if (s.contains("entity2")) {
                    String e2 = s.substring(s.indexOf("=") + 2, s.lastIndexOf(">") - 2);
                    m.add(e1, e2, 1.0);
                }
                s = reader.readLine();
            }
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ACache readOAEIFile(String file, String token) {
        MemoryCache c = new MemoryCache();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF8"));
            String s = reader.readLine();
            while (s != null) {
                String[] split = s.split(" ");
                Object value = split[2];
                if (split.length > 3) {
                    for (int i = 3; i < split.length; ++i) {
                        value = (String)value + " " + split[i];
                    }
                }
                if (split[0].contains(token) && !split[1].contains("#type")) {
                    ((ACache)c).addTriple(split[0].substring(1, split[0].length() - 1), split[1].substring(1, split[1].length() - 1), ((String)value).substring(1, ((String)value).length() - 3).toLowerCase());
                }
                s = reader.readLine();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        ((ACache)c).resetIterator();
        return c;
    }
}

