/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.util;

import java.util.ArrayList;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.util.DataGenerator;
import org.aksw.limes.core.util.Utils;

public class RandomStringGenerator
implements DataGenerator {
    int minLength;
    int maxLength;
    double mean = 0.0;
    double stdDev = 0.0;

    public RandomStringGenerator(int minLength, int maxLength) {
        this.minLength = minLength;
        this.maxLength = maxLength;
    }

    @Override
    public ACache generateData(int size) {
        MemoryCache c = new MemoryCache();
        ArrayList<Double> lengths = new ArrayList<Double>();
        while (((ACache)c).size() < size) {
            String s = this.generateString();
            lengths.add(Double.valueOf(s.length()));
            ((ACache)c).addTriple(s, "label", s);
        }
        this.stdDev = Utils.getStandardDeviation(lengths);
        this.mean = Utils.getMean(lengths);
        return c;
    }

    public String generateString() {
        Object s = "";
        int length = this.minLength + (int)(Math.random() * (double)(this.maxLength - this.minLength));
        for (int j = 0; j < length; ++j) {
            s = (String)s + (char)(97.0 + 26.0 * Math.random());
        }
        return s;
    }

    @Override
    public String getName() {
        return "randomString";
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public double getStandardDeviation() {
        return this.stdDev;
    }
}

