/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.euclid;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.classifier.ComplexClassifier;
import org.aksw.limes.core.ml.algorithm.classifier.SimpleClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.LinearSelfConfigurator;

public class BooleanSelfConfigurator
extends LinearSelfConfigurator {
    public BooleanSelfConfigurator(ACache source, ACache target) {
        super(source, target);
    }

    public BooleanSelfConfigurator(ACache source, ACache target, double minCoverage, double beta) {
        super(source, target, minCoverage, beta);
    }

    public BooleanSelfConfigurator(ACache source, ACache target, double minCoverage, double beta, Map<String, String> measures) {
        super(source, target, minCoverage, beta, measures);
    }

    public ComplexClassifier computeNext(ComplexClassifier classifier, int index) {
        ComplexClassifier cc = classifier.clone();
        ComplexClassifier result = new ComplexClassifier(null, 0.0);
        if (cc.getClassifiers().get(index).getThreshold() > this.learningRate) {
            cc.getClassifiers().get(index).setThreshold(cc.getClassifiers().get(index).getThreshold() - this.learningRate);
            AMapping m = this.getMapping(cc.getClassifiers());
            result.setClassifiers(cc.getClassifiers());
            result.setfMeasure(this.computeQuality(m));
            return result;
        }
        if (cc.getClassifiers().size() > index + 1) {
            ArrayList<SimpleClassifier> cp = new ArrayList<SimpleClassifier>();
            for (int i = 0; i < cc.getClassifiers().size(); ++i) {
                if (i == index) continue;
                cp.add(cc.getClassifiers().get(i));
            }
            AMapping m = this.getMapping(cp);
            result.setClassifiers(cp);
            result.setfMeasure(this.computeQuality(m));
            return result;
        }
        return result;
    }

    @Override
    public AMapping getMapping(List<SimpleClassifier> classifiers) {
        ArrayList<AMapping> mappings = new ArrayList<AMapping>();
        for (int i = 0; i < classifiers.size(); ++i) {
            AMapping m = this.executeClassifier(classifiers.get(i), classifiers.get(i).getThreshold());
            mappings.add(m);
        }
        AMapping result = BooleanSelfConfigurator.getIntersection(mappings);
        return result;
    }

    public static AMapping getIntersection(List<AMapping> mappings) {
        if (mappings.isEmpty()) {
            return MappingFactory.createDefaultMapping();
        }
        AMapping reference = mappings.get(0);
        AMapping result = MappingFactory.createDefaultMapping();
        for (String s : reference.getMap().keySet()) {
            for (String t : reference.getMap().get(s).keySet()) {
                boolean maps = true;
                for (int i = 1; i < mappings.size(); ++i) {
                    AMapping m = mappings.get(i);
                    if (m.contains(s, t)) continue;
                    maps = false;
                }
                if (!maps) continue;
                result.add(s, t, 1.0);
            }
        }
        return result;
    }

    @Override
    public List<SimpleClassifier> learnClassifer(List<SimpleClassifier> classifiers) {
        AMapping m = this.getMapping(classifiers = this.normalizeClassifiers(classifiers));
        double f = this.computeQuality(m);
        if (f == 1.0) {
            return classifiers;
        }
        ComplexClassifier classifier = new ComplexClassifier(classifiers, f);
        ComplexClassifier bestClassifier = null;
        ComplexClassifier bestGlobalClassifier = classifier.clone();
        double bestF = 0.0;
        double globalBestF = f;
        int direction = 0;
        int iterations = 0;
        while (iterations <= this.ITERATIONS_MAX) {
            ++iterations;
            bestF = 0.0;
            for (int i = 0; i < classifier.getClassifiers().size(); ++i) {
                ComplexClassifier cc = this.computeNext(classifier, i);
                if (!(cc.getfMeasure() > bestF)) continue;
                bestF = cc.getfMeasure();
                bestClassifier = cc;
            }
            if (bestF < globalBestF) {
                return bestGlobalClassifier.getClassifiers();
            }
            if (bestF == globalBestF) {
                if (direction >= classifier.getClassifiers().size()) {
                    direction = 0;
                }
                bestClassifier = this.computeNext(classifier, direction);
                ++direction;
                direction %= classifier.getClassifiers().size();
            }
            bestGlobalClassifier = bestClassifier.clone();
            globalBestF = bestF;
            classifier = bestClassifier;
        }
        return bestGlobalClassifier.getClassifiers();
    }
}

