/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.frechet;

import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineSegment;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.util.GeometricShapeFactory;

public class PolygonFrechetDistance {
    static GeometricShapeFactory gsf = new GeometricShapeFactory();
    static GeometryFactory gf = new GeometryFactory();
    static double delta = 0.01;
    public double[][] a;
    public double[][] b;
    public double[][] c;
    public double[][] d;
    Polygon poly1;
    Polygon poly2;

    public PolygonFrechetDistance(Polygon p1, Polygon p2) {
        this.poly1 = p1;
        this.poly2 = p2;
        this.a = new double[this.poly1.points.size()][this.poly2.points.size()];
        this.b = new double[this.poly1.points.size()][this.poly2.points.size()];
        this.c = new double[this.poly1.points.size()][this.poly2.points.size()];
        this.d = new double[this.poly1.points.size()][this.poly2.points.size()];
    }

    public double computeFrechetDistance() {
        if (this.poly1.points.size() == 1) {
            return this.getFrechetPointToPolygonDistance(this.poly1.points.get(0), this.poly2);
        }
        if (this.poly2.points.size() == 1) {
            return this.getFrechetPointToPolygonDistance(this.poly2.points.get(0), this.poly1);
        }
        Object[] cv = this.computeCriticalValues();
        Arrays.sort(cv);
        int index = this.binarySearch((Double[])cv);
        return (Double)cv[index];
    }

    public double getFrechetPointToPolygonDistance(Point p, Polygon poly) {
        ArrayList<Double> list = new ArrayList<Double>();
        for (Point q : poly.points) {
            list.add(OrthodromicDistance.getDistanceInDegrees(p, q));
        }
        for (int i = 0; i < poly.points.size() - 1; ++i) {
            double d = Line2D.ptSegDist(poly.points.get((int)i).coordinates.get(0), poly.points.get((int)i).coordinates.get(1), poly.points.get((int)(i + 1)).coordinates.get(0), poly.points.get((int)(i + 1)).coordinates.get(1), p.coordinates.get(0), p.coordinates.get(1));
            list.add(d);
        }
        double min = Double.MAX_VALUE;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            double d = (Double)iterator.next();
            if (!(d < min)) continue;
            min = d;
        }
        return min;
    }

    public Double[] computeCriticalValues() {
        LineString temp;
        Coordinate c2;
        double step;
        Coordinate c1;
        double bisectSlope;
        double origSlope;
        Coordinate midPoint;
        LineSegment lseg;
        int j;
        int i;
        int i2;
        double d;
        ArrayList<Double> list = new ArrayList<Double>();
        list.add(OrthodromicDistance.getDistanceInDegrees(this.poly1.points.get(0), this.poly2.points.get(0)));
        list.add(OrthodromicDistance.getDistanceInDegrees(this.poly1.points.get(this.poly1.points.size() - 1), this.poly2.points.get(this.poly2.points.size() - 1)));
        for (int i3 = 0; i3 < this.poly1.points.size(); ++i3) {
            for (int j2 = 0; j2 < this.poly2.points.size() - 1; ++j2) {
                d = Line2D.ptSegDist(this.poly2.points.get((int)j2).coordinates.get(0), this.poly2.points.get((int)j2).coordinates.get(1), this.poly2.points.get((int)(j2 + 1)).coordinates.get(0), this.poly2.points.get((int)(j2 + 1)).coordinates.get(1), this.poly1.points.get((int)i3).coordinates.get(0), this.poly1.points.get((int)i3).coordinates.get(1));
                list.add(d);
            }
        }
        for (int j3 = 0; j3 < this.poly2.points.size(); ++j3) {
            for (int i4 = 0; i4 < this.poly1.points.size() - 1; ++i4) {
                d = Line2D.ptSegDist(this.poly1.points.get((int)i4).coordinates.get(0), this.poly1.points.get((int)i4).coordinates.get(1), this.poly1.points.get((int)(i4 + 1)).coordinates.get(0), this.poly1.points.get((int)(i4 + 1)).coordinates.get(1), this.poly2.points.get((int)j3).coordinates.get(0), this.poly2.points.get((int)j3).coordinates.get(1));
                list.add(d);
            }
        }
        Coordinate[] poly1Curve = new Coordinate[this.poly1.points.size()];
        Coordinate[] poly2Curve = new Coordinate[this.poly2.points.size()];
        for (i2 = 0; i2 < this.poly1.points.size(); ++i2) {
            poly1Curve[i2] = new Coordinate(this.poly1.points.get((int)i2).coordinates.get(0).doubleValue(), this.poly1.points.get((int)i2).coordinates.get(1).doubleValue());
        }
        for (i2 = 0; i2 < this.poly2.points.size(); ++i2) {
            poly2Curve[i2] = new Coordinate(this.poly2.points.get((int)i2).coordinates.get(0).doubleValue(), this.poly2.points.get((int)i2).coordinates.get(1).doubleValue());
        }
        Coordinate intersect = null;
        for (i = 0; i < this.poly1.points.size() - 2; ++i) {
            for (j = i + 2; j < this.poly1.points.size(); ++j) {
                LineString ls;
                lseg = new LineSegment(poly1Curve[i], poly1Curve[j]);
                midPoint = lseg.midPoint();
                origSlope = this.getSlope(poly1Curve[i].x, poly1Curve[i].y, poly1Curve[j].x, poly1Curve[j].y);
                bisectSlope = 0.0;
                if (origSlope != Double.MAX_VALUE) {
                    bisectSlope = origSlope == 0.0 ? Double.MAX_VALUE : -1.0 / origSlope;
                }
                if ((ls = gf.createLineString(new Coordinate[]{c1 = new Coordinate(midPoint.x - (step = poly2Curve[0].distance(midPoint)), bisectSlope * -step + midPoint.y), midPoint, c2 = new Coordinate(midPoint.x + step, bisectSlope * step + midPoint.y)})).intersects((Geometry)(temp = gf.createLineString(poly2Curve)))) {
                    try {
                        intersect = ls.intersection((Geometry)temp).getCoordinate();
                    }
                    catch (Exception e) {
                        intersect = null;
                    }
                }
                if (intersect == null) continue;
                list.add(intersect.distance(poly1Curve[i]));
            }
        }
        for (i = 0; i < this.poly2.points.size() - 2; ++i) {
            for (j = i + 2; j < this.poly2.points.size(); ++j) {
                lseg = new LineSegment(poly2Curve[i], poly2Curve[j]);
                midPoint = lseg.midPoint();
                origSlope = this.getSlope(poly2Curve[i].x, poly2Curve[i].y, poly2Curve[j].x, poly2Curve[j].y);
                bisectSlope = 0.0;
                if (origSlope != Double.MAX_VALUE) {
                    bisectSlope = origSlope == 0.0 ? Double.MAX_VALUE : -1.0 / origSlope;
                }
                step = poly1Curve[0].distance(midPoint);
                if (bisectSlope == Double.MAX_VALUE) {
                    c1 = new Coordinate(midPoint.x, midPoint.y - step);
                    c2 = new Coordinate(midPoint.x, midPoint.y + step);
                } else {
                    c1 = new Coordinate(midPoint.x - step, bisectSlope * -step + midPoint.y);
                    c2 = new Coordinate(midPoint.x + step, bisectSlope * step + midPoint.y);
                }
                LineString ls = gf.createLineString(new Coordinate[]{c1, midPoint, c2});
                temp = gf.createLineString(poly1Curve);
                if (ls.intersects((Geometry)temp)) {
                    intersect = ls.intersection((Geometry)temp).getCoordinate();
                }
                if (intersect == null) continue;
                list.add(intersect.distance(poly2Curve[i]));
            }
        }
        return list.toArray(new Double[list.size()]);
    }

    private double getSlope(double x1, double y1, double x2, double y2) {
        if (x2 - x1 == 0.0) {
            return Double.MAX_VALUE;
        }
        return (y2 - y1) / (x2 - x1);
    }

    public int binarySearch(Double[] a) {
        int low = 0;
        int high = a.length - 1;
        int mid = 0;
        while (low <= high) {
            mid = (low + high) / 2;
            if (!this.isFrechet(a[mid])) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        return mid;
    }

    public boolean isFrechet(double epsilon) {
        int j;
        if (epsilon == Double.POSITIVE_INFINITY || epsilon == Double.NEGATIVE_INFINITY) {
            return false;
        }
        if (Line2D.ptSegDist(this.poly1.points.get((int)0).coordinates.get(0), this.poly1.points.get((int)0).coordinates.get(1), this.poly1.points.get((int)1).coordinates.get(0), this.poly1.points.get((int)1).coordinates.get(1), this.poly2.points.get((int)0).coordinates.get(0), this.poly2.points.get((int)0).coordinates.get(1)) > epsilon && Line2D.ptSegDist(this.poly1.points.get((int)0).coordinates.get(0), this.poly1.points.get((int)0).coordinates.get(1), this.poly1.points.get((int)1).coordinates.get(0), this.poly1.points.get((int)1).coordinates.get(1), this.poly2.points.get((int)1).coordinates.get(0), this.poly2.points.get((int)1).coordinates.get(1)) > epsilon) {
            return false;
        }
        if (Line2D.ptSegDist(this.poly2.points.get((int)0).coordinates.get(0), this.poly2.points.get((int)0).coordinates.get(1), this.poly2.points.get((int)1).coordinates.get(0), this.poly2.points.get((int)1).coordinates.get(1), this.poly1.points.get((int)0).coordinates.get(0), this.poly1.points.get((int)0).coordinates.get(1)) > epsilon && Line2D.ptSegDist(this.poly2.points.get((int)0).coordinates.get(0), this.poly2.points.get((int)0).coordinates.get(1), this.poly2.points.get((int)1).coordinates.get(0), this.poly2.points.get((int)1).coordinates.get(1), this.poly1.points.get((int)1).coordinates.get(0), this.poly1.points.get((int)1).coordinates.get(1)) > epsilon) {
            return false;
        }
        if (Line2D.ptSegDist(this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(1), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(1), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(1)) > epsilon && Line2D.ptSegDist(this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(1), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(1), this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(1)) > epsilon) {
            return false;
        }
        if (Line2D.ptSegDist(this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(1), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(1), this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 2)).coordinates.get(1)) > epsilon && Line2D.ptSegDist(this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 2)).coordinates.get(1), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(0), this.poly2.points.get((int)(this.poly2.points.size() - 1)).coordinates.get(1), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(0), this.poly1.points.get((int)(this.poly1.points.size() - 1)).coordinates.get(1)) > epsilon) {
            return false;
        }
        for (int i = 0; i < this.poly1.points.size() - 1; ++i) {
            for (j = 0; j < this.poly2.points.size() - 1; ++j) {
                Geometry tempGeom;
                org.locationtech.jts.geom.Polygon tempCircle;
                Coordinate p1 = new Coordinate(this.poly1.points.get((int)i).coordinates.get(0).doubleValue(), this.poly1.points.get((int)i).coordinates.get(1).doubleValue());
                Coordinate p2 = new Coordinate(this.poly1.points.get((int)(i + 1)).coordinates.get(0).doubleValue(), this.poly1.points.get((int)(i + 1)).coordinates.get(1).doubleValue());
                Coordinate q1 = new Coordinate(this.poly2.points.get((int)j).coordinates.get(0).doubleValue(), this.poly2.points.get((int)j).coordinates.get(1).doubleValue());
                Coordinate q2 = new Coordinate(this.poly2.points.get((int)(j + 1)).coordinates.get(0).doubleValue(), this.poly2.points.get((int)(j + 1)).coordinates.get(1).doubleValue());
                if (Line2D.ptSegDist(this.poly2.points.get((int)j).coordinates.get(0), this.poly2.points.get((int)j).coordinates.get(1), this.poly2.points.get((int)(j + 1)).coordinates.get(0), this.poly2.points.get((int)(j + 1)).coordinates.get(1), this.poly1.points.get((int)i).coordinates.get(0), this.poly1.points.get((int)i).coordinates.get(1)) > epsilon) {
                    this.b[i][j] = -1.0;
                    this.a[i][j] = -1.0;
                } else {
                    LineString tempLsQ = gf.createLineString(new Coordinate[]{q1, q2});
                    gsf.setCentre(p1);
                    gsf.setSize(2.0 * epsilon);
                    tempCircle = gsf.createCircle();
                    if (tempCircle.contains((Geometry)tempLsQ)) {
                        this.a[i][j] = 0.0;
                        this.b[i][j] = 1.0;
                    } else {
                        tempGeom = tempCircle.intersection((Geometry)tempLsQ);
                        int numCoords = tempGeom.getCoordinates().length;
                        if (numCoords == 2) {
                            Coordinate[] intersections = tempGeom.getCoordinates();
                            this.a[i][j] = this.getProportion(intersections[0], tempLsQ);
                            this.b[i][j] = this.getProportion(intersections[1], tempLsQ);
                        } else if (numCoords == 1) {
                            Coordinate intersection = tempGeom.getCoordinate();
                            if (p1.distance(q1) < p1.distance(q2)) {
                                this.a[i][j] = 0.0;
                                this.b[i][j] = this.getProportion(intersection, tempLsQ);
                            } else {
                                this.a[i][j] = this.getProportion(intersection, tempLsQ);
                                this.b[i][j] = 1.0;
                            }
                        }
                    }
                }
                double val1 = Line2D.ptSegDist(this.poly1.points.get((int)i).coordinates.get(0), this.poly1.points.get((int)i).coordinates.get(1), this.poly1.points.get((int)(i + 1)).coordinates.get(0), this.poly1.points.get((int)(i + 1)).coordinates.get(1), this.poly2.points.get((int)j).coordinates.get(0), this.poly2.points.get((int)j).coordinates.get(1));
                if (val1 > epsilon) {
                    this.d[i][j] = -1.0;
                    this.c[i][j] = -1.0;
                    continue;
                }
                LineString tempLsP = gf.createLineString(new Coordinate[]{p1, p2});
                gsf.setCentre(q1);
                gsf.setSize(2.0 * epsilon + delta);
                tempCircle = gsf.createCircle();
                if (tempCircle.contains((Geometry)tempLsP)) {
                    this.c[i][j] = 0.0;
                    this.d[i][j] = 1.0;
                    continue;
                }
                tempGeom = tempCircle.intersection((Geometry)tempLsP);
                int numCoords = tempGeom.getCoordinates().length;
                if (numCoords == 0) {
                    this.c[i][j] = 0.0;
                    this.d[i][j] = 0.0;
                    continue;
                }
                if (numCoords == 1) {
                    Coordinate intersect = tempGeom.getCoordinate();
                    if (q1.distance(p1) < q1.distance(p2)) {
                        this.c[i][j] = 0.0;
                        this.d[i][j] = this.getProportion(intersect, tempLsP);
                        continue;
                    }
                    this.c[i][j] = this.getProportion(intersect, tempLsP);
                    this.d[i][j] = 1.0;
                    continue;
                }
                Coordinate[] intersections = ((LineString)tempGeom).getCoordinates();
                this.c[i][j] = this.getProportion(intersections[0], tempLsP);
                this.d[i][j] = this.getProportion(intersections[1], tempLsP);
            }
        }
        boolean flag = true;
        for (int i = 0; i < this.poly1.points.size(); ++i) {
            if (flag && this.c[i][0] == -1.0 && this.d[i][0] == -1.0) {
                flag = false;
                continue;
            }
            if (flag) continue;
            this.d[i][0] = -1.0;
            this.c[i][0] = -1.0;
        }
        flag = true;
        for (j = 1; j < this.poly2.points.size(); ++j) {
            if (flag && this.a[0][j] == -1.0 && this.b[0][j] == -1.0) {
                flag = false;
                continue;
            }
            if (flag) continue;
            this.b[0][j] = -1.0;
            this.a[0][j] = -1.0;
        }
        boolean retVal = true;
        if (this.a[this.poly1.points.size() - 1][this.poly2.points.size() - 1] == -1.0 && this.b[this.poly1.points.size() - 1][this.poly2.points.size() - 1] == -1.0 && this.c[this.poly1.points.size() - 1][this.poly2.points.size() - 1] == -1.0 && this.d[this.poly1.points.size() - 1][this.poly2.points.size() - 1] == -1.0) {
            retVal = false;
        }
        return retVal;
    }

    private double getProportion(Coordinate coord, LineString ls) {
        Coordinate[] ends = ls.getCoordinates();
        return coord.distance(ends[0]) / ls.getLength();
    }
}

