/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.im;

import com.vividsolutions.jts.geom.Dimension;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.operation.relate.RelateOp;

public class RelateDE9IM {
    private static int[][] im;
    private static int dimg1;
    private static int dimg2;

    public RelateDE9IM(String elements) {
        this();
        im = new int[3][3];
        this.set(elements);
    }

    public RelateDE9IM(Geometry g1, Geometry g2) {
        this();
        this.computeIM(g1, g2);
    }

    public RelateDE9IM() {
    }

    public void computeIM(Geometry g1, Geometry g2) {
        dimg1 = g1.getDimension();
        dimg2 = g2.getDimension();
        int row = 0;
        int col = 0;
        RelateOp relateOp = new RelateOp(g1, g2);
        IntersectionMatrix deIM = relateOp.getIntersectionMatrix();
        im = new int[3][3];
        for (int i = 0; i < 9; ++i) {
            row = i / 3;
            col = i % 3;
            RelateDE9IM.im[row][col] = deIM.get(row, col);
        }
    }

    public void set(String dimensionSymbols) {
        for (int i = 0; i < dimensionSymbols.length(); ++i) {
            int row = i / 3;
            int col = i % 3;
            RelateDE9IM.im[row][col] = Dimension.toDimensionValue((char)dimensionSymbols.charAt(i));
        }
    }

    public boolean isDisjoint() {
        boolean b = im[0][0] == -1 && im[0][1] == -1 && im[1][0] == -1 && im[1][1] == -1;
        return b;
    }

    public boolean isIntersects() {
        return !this.isDisjoint();
    }

    public boolean isTouches() {
        boolean b = im[0][0] == -1 && (im[0][1] >= 0 || im[0][1] == -2);
        boolean b2 = im[0][0] == -1 && (im[1][0] >= 0 || im[1][0] == -2);
        boolean b3 = im[0][0] == -1 && (im[1][1] >= 0 || im[1][1] == -2);
        return b || b2 || b3;
    }

    public boolean isContains() {
        boolean b = (im[0][0] >= 0 || im[0][0] == -2) && im[2][0] == -1 && im[2][1] == -1;
        return b;
    }

    public boolean isEquals() {
        boolean b = (im[0][0] >= 0 || im[0][0] == -2) && im[0][2] == -1 && im[1][2] == -1 && im[2][0] == -1 && im[2][1] == -1;
        return b;
    }

    public boolean isOverlaps() {
        boolean b1 = dimg1 == 0 && dimg2 == 0 || dimg1 == 2 && dimg2 == 2;
        boolean b2 = !(im[0][0] < 0 && im[0][0] != -2 || im[0][2] < 0 && im[0][2] != -2 || im[2][0] < 0 && im[2][0] != -2);
        boolean b3 = dimg1 == 1 && dimg2 == 1;
        boolean b4 = !(im[0][0] != 1 || im[0][2] < 0 && im[0][2] != -2 || im[2][0] < 0 && im[2][0] != -2);
        return b1 && b2 || b3 && b4;
    }

    public boolean isCoveredBy() {
        boolean b = (im[0][0] >= 0 || im[0][0] == -2) && im[0][2] == -1 && im[1][2] == -1;
        boolean b1 = (im[0][1] >= 0 || im[0][1] == -2) && im[0][2] == -1 && im[1][2] == -1;
        boolean b2 = (im[1][0] >= 0 || im[1][0] == -2) && im[0][2] == -1 && im[1][2] == -1;
        boolean b3 = (im[1][1] >= 0 || im[1][1] == -2) && im[0][2] == -1 && im[1][2] == -1;
        return b || b1 || b2 || b3;
    }

    public boolean isCovers() {
        boolean b = (im[0][0] >= 0 || im[0][0] == -2) && im[2][0] == -1 && im[2][1] == -1;
        boolean b1 = (im[0][1] >= 0 || im[0][1] == -2) && im[2][0] == -1 && im[2][1] == -1;
        boolean b2 = (im[1][0] >= 0 || im[1][0] == -2) && im[2][0] == -1 && im[2][1] == -1;
        boolean b3 = (im[1][1] >= 0 || im[1][1] == -2) && im[2][0] == -1 && im[2][1] == -1;
        return b || b1 || b2 || b3;
    }

    public boolean isWithin() {
        boolean b = (im[0][0] >= 0 || im[0][0] == -2) && im[0][2] == -1 && im[1][2] == -1;
        return b;
    }

    public boolean isCrosses() {
        boolean b = !(im[0][0] < 0 && im[0][0] != -2 || im[0][2] < 0 && im[0][2] != -2);
        boolean b1 = !(im[0][0] < 0 && im[0][0] != -2 || im[2][0] < 0 && im[2][0] != -2);
        boolean b2 = im[0][0] == 0;
        return dimg1 < dimg2 && b || dimg2 > dimg1 && b1 || dimg1 == 1 && dimg2 == 1 && b2;
    }
}

