/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt.splitting;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.aksw.limes.core.measures.mapper.topology.cobalt.splitting.ICobaltSplitter;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.TopologyException;

public abstract class CobaltSplitter
implements ICobaltSplitter {
    public GeometryFactory factory = new GeometryFactory();
    public Geometry emptyGeo = this.factory.createPolygon();
    public Geometry[][] empty2x2Geo = new Geometry[][]{{this.emptyGeo, this.emptyGeo}, {this.emptyGeo, this.emptyGeo}};

    public Geometry[][] getSplitGeo(Geometry geo, double splitX, double splitY) {
        if (geo.isEmpty()) {
            return this.empty2x2Geo;
        }
        try {
            Geometry[] geometries = this.splitLeftRight(geo, splitX);
            Geometry geoLeft = geometries[0];
            Geometry geoRight = geometries[1];
            Geometry[] leftGeos = this.splitDownUp(geoLeft, splitY);
            Geometry geoBottomLeft = leftGeos[0];
            Geometry geoTopLeft = leftGeos[1];
            Geometry[] rightGeos = this.splitDownUp(geoRight, splitY);
            Geometry geoBottomRight = rightGeos[0];
            Geometry geoTopRight = rightGeos[1];
            Geometry[][] split = new Geometry[][]{{geoBottomLeft, geoTopLeft}, {geoBottomRight, geoTopRight}};
            return split;
        }
        catch (TopologyException e) {
            e.printStackTrace();
            return this.empty2x2Geo;
        }
    }

    public Geometry[] splitLeftRight(Geometry geo, double splitX) {
        if (geo instanceof Polygon) {
            List<Polygon>[] lists = this.splitPolygonLeftRight((Polygon)geo, splitX);
            Object g1 = lists[0].size() == 0 ? this.emptyGeo : (lists[0].size() == 1 ? (Geometry)lists[0].get(0) : this.factory.createMultiPolygon((Polygon[])lists[0].toArray(Polygon[]::new)));
            Object g2 = lists[1].size() == 0 ? this.emptyGeo : (lists[1].size() == 1 ? (Geometry)lists[1].get(0) : this.factory.createMultiPolygon((Polygon[])lists[1].toArray(Polygon[]::new)));
            return new Geometry[]{g1, g2};
        }
        if (geo instanceof MultiPolygon) {
            return this.splitMultiPolygonLeftRight((MultiPolygon)geo, splitX);
        }
        throw new RuntimeException();
    }

    public Geometry[] splitDownUp(Geometry geo, double splitY) {
        if (geo instanceof Polygon) {
            List<Polygon>[] lists = this.splitPolygonDownUp((Polygon)geo, splitY);
            Object g1 = lists[0].size() == 0 ? this.emptyGeo : (lists[0].size() == 1 ? (Geometry)lists[0].get(0) : this.factory.createMultiPolygon((Polygon[])lists[0].toArray(Polygon[]::new)));
            Object g2 = lists[1].size() == 0 ? this.emptyGeo : (lists[1].size() == 1 ? (Geometry)lists[1].get(0) : this.factory.createMultiPolygon((Polygon[])lists[1].toArray(Polygon[]::new)));
            return new Geometry[]{g1, g2};
        }
        if (geo instanceof MultiPolygon) {
            return this.splitMultiPolygonDownUp((MultiPolygon)geo, splitY);
        }
        throw new RuntimeException();
    }

    public Geometry[] splitMultiPolygonLeftRight(MultiPolygon geo, double splitX) {
        ArrayList<Polygon> polygonsLeft = new ArrayList<Polygon>();
        ArrayList<Polygon> polygonsRight = new ArrayList<Polygon>();
        for (int i = 0; i < geo.getNumGeometries(); ++i) {
            List<Polygon>[] leftRight = this.splitPolygonLeftRight((Polygon)geo.getGeometryN(i), splitX);
            if (leftRight[0] != null) {
                polygonsLeft.addAll(leftRight[0]);
            }
            if (leftRight[1] == null) continue;
            polygonsRight.addAll(leftRight[1]);
        }
        MultiPolygon poly1 = null;
        MultiPolygon poly2 = null;
        poly1 = polygonsLeft.size() > 0 ? this.factory.createMultiPolygon((Polygon[])polygonsLeft.toArray(Polygon[]::new)) : this.factory.createMultiPolygon();
        poly2 = polygonsRight.size() > 0 ? this.factory.createMultiPolygon((Polygon[])polygonsRight.toArray(Polygon[]::new)) : this.factory.createMultiPolygon();
        return new MultiPolygon[]{poly1, poly2};
    }

    public Geometry[] splitMultiPolygonDownUp(MultiPolygon geo, double splitY) {
        ArrayList<Polygon> polygonsDown = new ArrayList<Polygon>();
        ArrayList<Polygon> polygonsUp = new ArrayList<Polygon>();
        for (int i = 0; i < geo.getNumGeometries(); ++i) {
            List<Polygon>[] leftRight = this.splitPolygonDownUp((Polygon)geo.getGeometryN(i), splitY);
            if (leftRight[0] != null) {
                polygonsDown.addAll(leftRight[0]);
            }
            if (leftRight[1] == null) continue;
            polygonsUp.addAll(leftRight[1]);
        }
        MultiPolygon poly1 = null;
        MultiPolygon poly2 = null;
        poly1 = polygonsDown.size() > 0 ? this.factory.createMultiPolygon((Polygon[])polygonsDown.toArray(Polygon[]::new)) : this.factory.createMultiPolygon();
        poly2 = polygonsUp.size() > 0 ? this.factory.createMultiPolygon((Polygon[])polygonsUp.toArray(Polygon[]::new)) : this.factory.createMultiPolygon();
        return new MultiPolygon[]{poly1, poly2};
    }

    public List<Polygon>[] splitPolygonLeftRight(Polygon geo, double splitX) {
        Polygon x;
        Polygon polygon = geo;
        Coordinate[] exteriorRingCoordinates = polygon.getExteriorRing().getCoordinates();
        List<LinearRing>[] exteriorRings = this.splitRingLeftRight(splitX, exteriorRingCoordinates);
        ArrayList<LinearRing> leftHoleList = new ArrayList<LinearRing>();
        ArrayList<LinearRing> rightHoleList = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LineString interiorRingN = polygon.getInteriorRingN(i);
            List<LinearRing>[] splitRingLeftRight = this.splitRingLeftRight(splitX, interiorRingN.getCoordinates());
            this.fixHolesLeftRight(splitX, exteriorRings[0], leftHoleList, splitRingLeftRight[0]);
            this.fixHolesLeftRight(splitX, exteriorRings[1], rightHoleList, splitRingLeftRight[1]);
        }
        LinearRing[] holesLeft = (LinearRing[])leftHoleList.toArray(LinearRing[]::new);
        LinearRing[] holesRight = (LinearRing[])rightHoleList.toArray(LinearRing[]::new);
        ArrayList<Polygon> poly1 = new ArrayList<Polygon>();
        ArrayList<Polygon> poly2 = new ArrayList<Polygon>();
        if (exteriorRings[0] != null) {
            for (LinearRing linearRing : exteriorRings[0]) {
                x = this.factory.createPolygon(linearRing, holesLeft);
                if (!x.isValid()) {
                    x = this.factory.createPolygon(linearRing);
                }
                poly1.add(x);
            }
        }
        if (exteriorRings[1] != null) {
            for (LinearRing linearRing : exteriorRings[1]) {
                x = this.factory.createPolygon(linearRing, holesRight);
                if (!x.isValid()) {
                    x = this.factory.createPolygon(linearRing);
                }
                poly2.add(x);
            }
        }
        return new List[]{poly1, poly2};
    }

    public List<Polygon>[] splitPolygonDownUp(Polygon geo, double splitY) {
        Polygon x;
        Polygon polygon = geo;
        Coordinate[] exteriorRingCoordinates = polygon.getExteriorRing().getCoordinates();
        List<LinearRing>[] exteriorRings = this.splitRingDownUp(splitY, exteriorRingCoordinates);
        ArrayList<LinearRing> downHoleList = new ArrayList<LinearRing>();
        ArrayList<LinearRing> upHoleList = new ArrayList<LinearRing>();
        for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
            LineString interiorRingN = polygon.getInteriorRingN(i);
            List<LinearRing>[] splitRingLeftRight = this.splitRingDownUp(splitY, interiorRingN.getCoordinates());
            this.fixHolesDownUp(splitY, exteriorRings[0], downHoleList, splitRingLeftRight[0]);
            this.fixHolesDownUp(splitY, exteriorRings[1], upHoleList, splitRingLeftRight[1]);
        }
        LinearRing[] holesDown = (LinearRing[])downHoleList.toArray(LinearRing[]::new);
        LinearRing[] holesUp = (LinearRing[])upHoleList.toArray(LinearRing[]::new);
        ArrayList<Polygon> poly1 = new ArrayList<Polygon>();
        ArrayList<Polygon> poly2 = new ArrayList<Polygon>();
        if (exteriorRings[0] != null) {
            for (LinearRing linearRing : exteriorRings[0]) {
                x = this.factory.createPolygon(linearRing, holesDown);
                if (!x.isValid()) {
                    x = this.factory.createPolygon(linearRing);
                }
                poly1.add(x);
            }
        }
        if (exteriorRings[1] != null) {
            for (LinearRing linearRing : exteriorRings[1]) {
                x = this.factory.createPolygon(linearRing, holesUp);
                if (!x.isValid()) {
                    x = this.factory.createPolygon(linearRing);
                }
                poly2.add(x);
            }
        }
        return new List[]{poly1, poly2};
    }

    private void fixHolesLeftRight(double splitX, List<LinearRing> exteriorRings, List<LinearRing> holeList, List<LinearRing> splitRingLeftRight) {
        if (splitRingLeftRight != null) {
            for (LinearRing holeRing : splitRingLeftRight) {
                if (holeRing.getCoordinates()[0].x == splitX) {
                    Coordinate a = holeRing.getCoordinates()[0];
                    Coordinate b = holeRing.getCoordinates()[holeRing.getCoordinates().length - 2];
                    Coordinate holeTopCoord = a.getY() > b.getY() ? a : b;
                    Coordinate holeBottomCoord = a.getY() > b.getY() ? b : a;
                    for (int j = 0; j < exteriorRings.size(); ++j) {
                        int k;
                        LinearRing exteriorRing = exteriorRings.get(j);
                        List exteriorCoordinatesAtSplittingLineSorted = Arrays.stream(exteriorRing.getCoordinates()).filter(coordinate -> coordinate.getX() == splitX).sorted(Comparator.comparingDouble(Coordinate::getY)).collect(Collectors.toList());
                        Coordinate exteriorBot = (Coordinate)exteriorCoordinatesAtSplittingLineSorted.get(0);
                        Coordinate exteriorTop = (Coordinate)exteriorCoordinatesAtSplittingLineSorted.get(exteriorCoordinatesAtSplittingLineSorted.size() - 1);
                        if (!(holeTopCoord.getY() >= exteriorBot.getY()) || !(holeTopCoord.getY() <= exteriorTop.getY())) continue;
                        Coordinate[] combinedResultRingCoordinates = new Coordinate[exteriorRing.getCoordinates().length + holeRing.getCoordinates().length - 1];
                        int index = 0;
                        Coordinate[] coordinateArray = exteriorRing.getCoordinates();
                        int n = coordinateArray.length;
                        for (int i = 0; i < n; ++i) {
                            Coordinate currentCoordinate;
                            combinedResultRingCoordinates[index] = currentCoordinate = coordinateArray[i];
                            ++index;
                        }
                        --index;
                        Coordinate coordinate2 = exteriorRing.getCoordinates()[exteriorRing.getCoordinates().length - 2];
                        if (coordinate2.getY() == exteriorTop.getY()) {
                            combinedResultRingCoordinates[index] = holeTopCoord;
                            ++index;
                            if (holeRing.getCoordinates()[0] == holeTopCoord) {
                                for (k = 1; k < holeRing.getCoordinates().length - 2; ++k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            } else {
                                for (k = holeRing.getCoordinates().length - 3; k >= 1; --k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            }
                            combinedResultRingCoordinates[index] = holeBottomCoord;
                            ++index;
                        } else {
                            combinedResultRingCoordinates[index] = holeBottomCoord;
                            ++index;
                            if (holeRing.getCoordinates()[0] == holeBottomCoord) {
                                for (k = 1; k < holeRing.getCoordinates().length - 2; ++k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            } else {
                                for (k = holeRing.getCoordinates().length - 3; k >= 1; --k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            }
                            combinedResultRingCoordinates[index] = holeTopCoord;
                            ++index;
                        }
                        combinedResultRingCoordinates[combinedResultRingCoordinates.length - 1] = combinedResultRingCoordinates[0];
                        exteriorRings.set(j, this.factory.createLinearRing(combinedResultRingCoordinates));
                    }
                    continue;
                }
                holeList.add(holeRing);
            }
        }
    }

    private void fixHolesDownUp(double splitY, List<LinearRing> exteriorRings, List<LinearRing> holeList, List<LinearRing> splitRingLeftRight) {
        if (splitRingLeftRight != null) {
            for (LinearRing holeRing : splitRingLeftRight) {
                if (holeRing.getCoordinates()[0].y == splitY) {
                    Coordinate a = holeRing.getCoordinates()[0];
                    Coordinate b = holeRing.getCoordinates()[holeRing.getCoordinates().length - 2];
                    Coordinate holeRightCoord = a.getX() > b.getX() ? a : b;
                    Coordinate holeLeftCoord = a.getX() > b.getX() ? b : a;
                    for (int j = 0; j < exteriorRings.size(); ++j) {
                        int k;
                        LinearRing exteriorRing = exteriorRings.get(j);
                        List exteriorCoordinatesAtSplittingLineSorted = Arrays.stream(exteriorRing.getCoordinates()).filter(coordinate -> coordinate.getY() == splitY).sorted(Comparator.comparingDouble(Coordinate::getX)).collect(Collectors.toList());
                        Coordinate exteriorLeft = (Coordinate)exteriorCoordinatesAtSplittingLineSorted.get(0);
                        Coordinate exteriorRight = (Coordinate)exteriorCoordinatesAtSplittingLineSorted.get(exteriorCoordinatesAtSplittingLineSorted.size() - 1);
                        if (!(holeRightCoord.getX() >= exteriorLeft.getX()) || !(holeRightCoord.getX() <= exteriorRight.getX())) continue;
                        Coordinate[] combinedResultRingCoordinates = new Coordinate[exteriorRing.getCoordinates().length + holeRing.getCoordinates().length - 1];
                        int index = 0;
                        Coordinate[] coordinateArray = exteriorRing.getCoordinates();
                        int n = coordinateArray.length;
                        for (int i = 0; i < n; ++i) {
                            Coordinate currentCoordinate;
                            combinedResultRingCoordinates[index] = currentCoordinate = coordinateArray[i];
                            ++index;
                        }
                        --index;
                        Coordinate coordinate2 = exteriorRing.getCoordinates()[exteriorRing.getCoordinates().length - 2];
                        if (coordinate2.getX() == exteriorRight.getX()) {
                            combinedResultRingCoordinates[index] = holeRightCoord;
                            ++index;
                            if (holeRing.getCoordinates()[0] == holeRightCoord) {
                                for (k = 1; k < holeRing.getCoordinates().length - 2; ++k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            } else {
                                for (k = holeRing.getCoordinates().length - 3; k >= 1; --k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            }
                            combinedResultRingCoordinates[index] = holeLeftCoord;
                            ++index;
                        } else {
                            combinedResultRingCoordinates[index] = holeLeftCoord;
                            ++index;
                            if (holeRing.getCoordinates()[0] == holeLeftCoord) {
                                for (k = 1; k < holeRing.getCoordinates().length - 2; ++k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            } else {
                                for (k = holeRing.getCoordinates().length - 3; k >= 1; --k) {
                                    combinedResultRingCoordinates[index] = holeRing.getCoordinates()[k];
                                    ++index;
                                }
                            }
                            combinedResultRingCoordinates[index] = holeRightCoord;
                            ++index;
                        }
                        combinedResultRingCoordinates[combinedResultRingCoordinates.length - 1] = combinedResultRingCoordinates[0];
                        exteriorRings.set(j, this.factory.createLinearRing(combinedResultRingCoordinates));
                    }
                    continue;
                }
                holeList.add(holeRing);
            }
        }
    }

    public List<LinearRing>[] splitRingLeftRight(double splitX, Coordinate[] exteriorRingCoordinates) {
        ArrayList<Object> leftRing = new ArrayList<Coordinate>();
        ArrayList<Object> rightRing = new ArrayList<Coordinate>();
        ArrayList<List<Coordinate>> leftRings = new ArrayList<List<Coordinate>>();
        ArrayList<List<Coordinate>> rightRings = new ArrayList<List<Coordinate>>();
        boolean lastLeft = false;
        boolean lastRight = false;
        Coordinate lastCoordinate = null;
        for (Coordinate exteriorRingCoordinate : exteriorRingCoordinates) {
            Coordinate pointOnSplitLine;
            double yDiffToSplitLine;
            double xDiffToSplitLine;
            double currentSlope;
            double xdiff;
            double ydiff;
            if (!lastLeft && !lastRight) {
                if (exteriorRingCoordinate.x < splitX) {
                    leftRing.add(exteriorRingCoordinate);
                    lastLeft = true;
                } else {
                    rightRing.add(exteriorRingCoordinate);
                    lastRight = true;
                }
            } else if (lastLeft) {
                if (exteriorRingCoordinate.x > splitX) {
                    ydiff = exteriorRingCoordinate.y - lastCoordinate.y;
                    xdiff = exteriorRingCoordinate.x - lastCoordinate.x;
                    currentSlope = ydiff / xdiff;
                    xDiffToSplitLine = splitX - lastCoordinate.x;
                    yDiffToSplitLine = currentSlope * xDiffToSplitLine;
                    pointOnSplitLine = new Coordinate(lastCoordinate.x + xDiffToSplitLine, lastCoordinate.y + yDiffToSplitLine);
                    leftRing.add(pointOnSplitLine);
                    leftRings.add(leftRing);
                    leftRing = new ArrayList();
                    rightRing.add(pointOnSplitLine);
                    rightRing.add(exteriorRingCoordinate);
                    lastRight = true;
                    lastLeft = false;
                } else {
                    leftRing.add(exteriorRingCoordinate);
                }
            } else if (lastRight) {
                if (exteriorRingCoordinate.x > splitX) {
                    rightRing.add(exteriorRingCoordinate);
                } else {
                    ydiff = lastCoordinate.y - exteriorRingCoordinate.y;
                    xdiff = lastCoordinate.x - exteriorRingCoordinate.x;
                    currentSlope = ydiff / xdiff;
                    xDiffToSplitLine = splitX - exteriorRingCoordinate.x;
                    yDiffToSplitLine = currentSlope * xDiffToSplitLine;
                    pointOnSplitLine = new Coordinate(exteriorRingCoordinate.x + xDiffToSplitLine, exteriorRingCoordinate.y + yDiffToSplitLine);
                    rightRing.add(pointOnSplitLine);
                    rightRings.add(rightRing);
                    rightRing = new ArrayList();
                    leftRing.add(pointOnSplitLine);
                    leftRing.add(exteriorRingCoordinate);
                    lastLeft = true;
                    lastRight = false;
                }
            }
            lastCoordinate = exteriorRingCoordinate;
        }
        if (leftRings.size() > 0 && rightRings.size() > 0) {
            if (leftRing.size() > 0) {
                CobaltSplitter.putTogetherStartringX(splitX, leftRing, leftRings);
            }
            if (rightRing.size() > 0) {
                CobaltSplitter.putTogetherStartringX(splitX, rightRing, rightRings);
            }
        } else {
            if (leftRing.size() > 0) {
                leftRings.add(leftRing);
            }
            if (rightRing.size() > 0) {
                rightRings.add(rightRing);
            }
        }
        CobaltSplitter.fixDoubledCoordinates(leftRings);
        CobaltSplitter.fixDoubledCoordinates(rightRings);
        return new List[]{this.fixLineStringsLeftRight(splitX, leftRings), this.fixLineStringsLeftRight(splitX, rightRings)};
    }

    private static void putTogetherStartringX(double splitX, ArrayList<Coordinate> lastRing, List<List<Coordinate>> correctSideRings) {
        List<Coordinate> startRing = correctSideRings.get(0);
        lastRing.remove(lastRing.get(lastRing.size() - 1));
        startRing.addAll(lastRing);
        int max = startRing.size();
        while (startRing.get((int)0).x != splitX || startRing.get((int)(startRing.size() - 1)).x != splitX) {
            if (max-- == 0) {
                TreeMap closestIndex = new TreeMap(Double::compareTo);
                for (int i = 0; i < startRing.size(); ++i) {
                    double diff = Math.abs(startRing.get((int)i).x - splitX);
                    if (!closestIndex.containsKey(diff)) {
                        closestIndex.put(diff, new ArrayList());
                    }
                    ((List)closestIndex.get(diff)).add(i);
                }
                int count = 0;
                block2: for (Double aDouble : closestIndex.keySet()) {
                    for (Integer index : (List)closestIndex.get(aDouble)) {
                        if (count++ == 2) break block2;
                        startRing.set(index, new Coordinate(splitX, startRing.get(index).getY()));
                    }
                }
            }
            Coordinate coordinate = startRing.remove(0);
            startRing.add(coordinate);
        }
    }

    private static void putTogetherStartringY(double splitY, ArrayList<Coordinate> lastRing, List<List<Coordinate>> correctSideRings) {
        List<Coordinate> startRing = correctSideRings.get(0);
        lastRing.remove(lastRing.get(lastRing.size() - 1));
        startRing.addAll(lastRing);
        int max = startRing.size();
        while (startRing.get((int)0).y != splitY || startRing.get((int)(startRing.size() - 1)).y != splitY) {
            if (max-- == 0) {
                TreeMap closestIndex = new TreeMap(Double::compareTo);
                for (int i = 0; i < startRing.size(); ++i) {
                    double diff = Math.abs(startRing.get((int)i).y - splitY);
                    if (!closestIndex.containsKey(diff)) {
                        closestIndex.put(diff, new ArrayList());
                    }
                    ((List)closestIndex.get(diff)).add(i);
                }
                int count = 0;
                block2: for (Double aDouble : closestIndex.keySet()) {
                    for (Integer index : (List)closestIndex.get(aDouble)) {
                        if (count++ == 2) break block2;
                        startRing.set(index, new Coordinate(startRing.get(index).getX(), splitY));
                    }
                }
            }
            Coordinate coordinate = startRing.remove(0);
            startRing.add(coordinate);
        }
    }

    public List<LinearRing>[] splitRingDownUp(double splitY, Coordinate[] exteriorRingCoordinates) {
        ArrayList<Object> downRing = new ArrayList<Coordinate>();
        ArrayList<Object> upRing = new ArrayList<Coordinate>();
        ArrayList<List<Coordinate>> downRings = new ArrayList<List<Coordinate>>();
        ArrayList<List<Coordinate>> upRings = new ArrayList<List<Coordinate>>();
        boolean lastDown = false;
        boolean lastUp = false;
        Coordinate lastCoordinate = null;
        for (Coordinate exteriorRingCoordinate : exteriorRingCoordinates) {
            Coordinate pointOnSplitLine;
            double xDiffToSplitLine;
            double yDiffToSplitLine;
            double currentSlope;
            double xdiff;
            double ydiff;
            if (!lastDown && !lastUp) {
                if (exteriorRingCoordinate.y < splitY) {
                    downRing.add(exteriorRingCoordinate);
                    lastDown = true;
                } else {
                    upRing.add(exteriorRingCoordinate);
                    lastUp = true;
                }
            } else if (lastDown) {
                if (exteriorRingCoordinate.y > splitY) {
                    ydiff = exteriorRingCoordinate.y - lastCoordinate.y;
                    xdiff = exteriorRingCoordinate.x - lastCoordinate.x;
                    currentSlope = ydiff / xdiff;
                    yDiffToSplitLine = splitY - lastCoordinate.y;
                    xDiffToSplitLine = xdiff / ydiff * yDiffToSplitLine;
                    pointOnSplitLine = new Coordinate(lastCoordinate.x + xDiffToSplitLine, lastCoordinate.y + yDiffToSplitLine);
                    downRing.add(pointOnSplitLine);
                    downRings.add(downRing);
                    downRing = new ArrayList();
                    upRing.add(pointOnSplitLine);
                    upRing.add(exteriorRingCoordinate);
                    lastUp = true;
                    lastDown = false;
                } else {
                    downRing.add(exteriorRingCoordinate);
                }
            } else if (lastUp) {
                if (exteriorRingCoordinate.y > splitY) {
                    upRing.add(exteriorRingCoordinate);
                } else {
                    ydiff = lastCoordinate.y - exteriorRingCoordinate.y;
                    xdiff = lastCoordinate.x - exteriorRingCoordinate.x;
                    currentSlope = ydiff / xdiff;
                    yDiffToSplitLine = splitY - exteriorRingCoordinate.y;
                    xDiffToSplitLine = xdiff / ydiff * yDiffToSplitLine;
                    pointOnSplitLine = new Coordinate(exteriorRingCoordinate.x + xDiffToSplitLine, exteriorRingCoordinate.y + yDiffToSplitLine);
                    upRing.add(pointOnSplitLine);
                    upRings.add(upRing);
                    upRing = new ArrayList();
                    downRing.add(pointOnSplitLine);
                    downRing.add(exteriorRingCoordinate);
                    lastDown = true;
                    lastUp = false;
                }
            }
            lastCoordinate = exteriorRingCoordinate;
        }
        if (downRings.size() > 0 && upRings.size() > 0) {
            if (downRing.size() > 0) {
                CobaltSplitter.putTogetherStartringY(splitY, downRing, downRings);
            }
            if (upRing.size() > 0) {
                CobaltSplitter.putTogetherStartringY(splitY, upRing, upRings);
            }
        } else {
            if (downRing.size() > 0) {
                downRings.add(downRing);
            }
            if (upRing.size() > 0) {
                upRings.add(upRing);
            }
        }
        CobaltSplitter.fixDoubledCoordinates(downRings);
        CobaltSplitter.fixDoubledCoordinates(upRings);
        return new List[]{this.fixLineStringsDownUp(splitY, downRings), this.fixLineStringsDownUp(splitY, upRings)};
    }

    private static void fixDoubledCoordinates(List<List<Coordinate>> downRings) {
        for (int i = 0; i < downRings.size(); ++i) {
            List<Coordinate> coordinates = downRings.get(i);
            for (int j = 0; j < coordinates.size() - 2; ++j) {
                if (!coordinates.get(j).equals((Object)coordinates.get(j + 1))) continue;
                coordinates.remove(j);
                --j;
            }
        }
    }

    public List<LinearRing> fixLineStringsLeftRight(double splitX, List<List<Coordinate>> rings) {
        TreeMap<Coordinate, List> map = new TreeMap<Coordinate, List>(Comparator.comparingDouble(Coordinate::getY));
        ArrayList<List> result = new ArrayList<List>();
        if (rings.size() == 1) {
            List<Coordinate> coordinates2 = rings.get(0);
            coordinates2.add(coordinates2.get(0));
            result.add(coordinates2);
        } else if (rings.size() > 1) {
            for (List<Coordinate> ring : rings) {
                if (ring.get((int)0).x == splitX) {
                    map.put(ring.get(0), ring);
                }
                if (ring.get((int)(ring.size() - 1)).x != splitX) continue;
                map.put(ring.get(ring.size() - 1), ring);
            }
            boolean snap = false;
            Coordinate lastCoord = null;
            for (Coordinate c : map.keySet()) {
                if (!snap) {
                    snap = true;
                } else {
                    snap = false;
                    List coordinates3 = (List)map.get(c);
                    if (coordinates3.contains(lastCoord)) {
                        coordinates3.add((Coordinate)coordinates3.get(0));
                        result.add(coordinates3);
                    } else {
                        List lastCoords = (List)map.get(lastCoord);
                        if (((Coordinate)coordinates3.get(coordinates3.size() - 1)).equals((Object)c)) {
                            if (!coordinates3.contains(lastCoord)) {
                                coordinates3.addAll(lastCoords);
                                map.replace((Coordinate)lastCoords.get(0), coordinates3);
                                map.replace((Coordinate)lastCoords.get(lastCoords.size() - 1), coordinates3);
                            } else {
                                coordinates3.add((Coordinate)coordinates3.get(0));
                                result.add(coordinates3);
                            }
                        } else if (!lastCoords.contains(c)) {
                            lastCoords.addAll(coordinates3);
                            map.replace((Coordinate)coordinates3.get(0), lastCoords);
                            map.replace((Coordinate)coordinates3.get(coordinates3.size() - 1), lastCoords);
                        } else {
                            lastCoords.add((Coordinate)lastCoords.get(0));
                            result.add(lastCoords);
                        }
                    }
                }
                lastCoord = c;
            }
        }
        return result.stream().filter(coordinates -> coordinates.stream().noneMatch(coordinate -> Double.isNaN(coordinate.x) || Double.isNaN(coordinate.y))).filter(coordinates -> coordinates.size() >= 4).map(coordinates -> this.factory.createLinearRing((Coordinate[])coordinates.toArray(Coordinate[]::new))).collect(Collectors.toList());
    }

    public List<LinearRing> fixLineStringsDownUp(double splitY, List<List<Coordinate>> rings) {
        TreeMap<Coordinate, List> map = new TreeMap<Coordinate, List>(Comparator.comparingDouble(Coordinate::getX));
        ArrayList<List> result = new ArrayList<List>();
        if (rings.size() == 1) {
            List<Coordinate> coordinates2 = rings.get(0);
            coordinates2.add(coordinates2.get(0));
            result.add(coordinates2);
        } else if (rings.size() > 1) {
            for (List<Coordinate> ring : rings) {
                if (ring.get((int)0).y == splitY) {
                    map.put(ring.get(0), ring);
                }
                if (ring.get((int)(ring.size() - 1)).y != splitY) continue;
                map.put(ring.get(ring.size() - 1), ring);
            }
            boolean snap = false;
            Coordinate lastCoord = null;
            for (Coordinate c : map.keySet()) {
                if (!snap) {
                    snap = true;
                } else {
                    snap = false;
                    List coordinates3 = (List)map.get(c);
                    if (coordinates3.contains(lastCoord)) {
                        coordinates3.add((Coordinate)coordinates3.get(0));
                        result.add(coordinates3);
                    } else {
                        List lastCoords = (List)map.get(lastCoord);
                        if (((Coordinate)coordinates3.get(coordinates3.size() - 1)).equals((Object)c)) {
                            if (!coordinates3.contains(lastCoord)) {
                                coordinates3.addAll(lastCoords);
                                map.put((Coordinate)lastCoords.get(0), coordinates3);
                                map.put((Coordinate)lastCoords.get(lastCoords.size() - 1), coordinates3);
                            } else {
                                coordinates3.add((Coordinate)coordinates3.get(0));
                                result.add(coordinates3);
                            }
                        } else if (!lastCoords.contains(c)) {
                            lastCoords.addAll(coordinates3);
                            map.put((Coordinate)coordinates3.get(0), lastCoords);
                            map.put((Coordinate)coordinates3.get(coordinates3.size() - 1), lastCoords);
                        } else {
                            lastCoords.add((Coordinate)lastCoords.get(0));
                            result.add(lastCoords);
                        }
                    }
                }
                lastCoord = c;
            }
        }
        return result.stream().filter(coordinates -> coordinates.stream().noneMatch(coordinate -> Double.isNaN(coordinate.x) || Double.isNaN(coordinate.y))).filter(coordinates -> coordinates.size() >= 4).map(coordinates -> this.factory.createLinearRing((Coordinate[])coordinates.toArray(Coordinate[]::new))).collect(Collectors.toList());
    }
}

