/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt.matcher;

import org.aksw.limes.core.measures.mapper.topology.cobalt.CobaltMeasures;
import org.aksw.limes.core.measures.mapper.topology.cobalt.matcher.ICobaltMatcher;
import org.locationtech.jts.geom.Envelope;

public class CobaltMixedMatcher
implements ICobaltMatcher {
    @Override
    public boolean relate(Envelope mbrA, Envelope mbrB, String relation) {
        double X = CobaltMeasures.fM(mbrA, mbrB);
        double Y = CobaltMeasures.fM(mbrB, mbrA);
        double Z = X + Y;
        return this.relate(X, Y, Z, relation);
    }

    public boolean relate(double X, double Y, double Z, String relation) {
        switch (relation) {
            case "equals": {
                return X == -1.0 && Y == -1.0;
            }
            case "disjoint": {
                return 1.0 < X && 1.0 < Y;
            }
            case "intersects": {
                return this.relate(X, Y, Z, "equals") || this.relate(X, Y, Z, "touches") || this.relate(X, Y, Z, "contains") || this.relate(X, Y, Z, "covers") || this.relate(X, Y, Z, "coveredby") || this.relate(X, Y, Z, "within") || this.relate(X, Y, Z, "overlaps");
            }
            case "touches": {
                return X == 1.0 && Y == 1.0;
            }
            case "contains": 
            case "covers": {
                return Math.abs(X) < 1.0 && Y == -1.0 || Math.abs(X) < 1.0 && Y < -1.0 || this.relate(X, Y, Z, "equals");
            }
            case "within": 
            case "coveredby": {
                return X < -1.0 && Math.abs(Y) < 1.0 || X == -1.0 && Math.abs(Y) < 1.0 || this.relate(X, Y, Z, "equals");
            }
            case "overlaps": {
                return Math.abs(X) < 1.0 && Math.abs(Y) < 1.0;
            }
        }
        return false;
    }
}

