/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class RTree {
    private boolean leaf;
    private Envelope boundary;
    private List<RTree> children;
    private List<Entry> contents;
    private static int capacity = 4;

    private static RTree createLeaf(List<Entry> contents) {
        RTree tree = new RTree();
        tree.leaf = true;
        tree.contents = contents;
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (Entry content : contents) {
            if (content.envelope.getMinX() < minX) {
                minX = content.envelope.getMinX();
            }
            if (content.envelope.getMinY() < minY) {
                minY = content.envelope.getMinY();
            }
            if (content.envelope.getMaxX() > maxX) {
                maxX = content.envelope.getMaxX();
            }
            if (!(content.envelope.getMaxY() > maxY)) continue;
            maxY = content.envelope.getMaxY();
        }
        tree.boundary = new Envelope(minX, maxX, minY, maxY);
        return tree;
    }

    private static RTree createParent(List<RTree> children) {
        RTree tree = new RTree();
        tree.leaf = false;
        tree.children = new ArrayList<RTree>(children.size());
        for (RTree child : children) {
            if (child.boundary.getMinX() != Double.POSITIVE_INFINITY) {
                tree.children.add(child);
                continue;
            }
            throw new RuntimeException("");
        }
        double minX = Double.POSITIVE_INFINITY;
        double minY = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double maxY = Double.NEGATIVE_INFINITY;
        for (RTree content : tree.children) {
            if (content.boundary.getMinX() < minX) {
                minX = content.boundary.getMinX();
            }
            if (content.boundary.getMinY() < minY) {
                minY = content.boundary.getMinY();
            }
            if (content.boundary.getMaxX() > maxX) {
                maxX = content.boundary.getMaxX();
            }
            if (!(content.boundary.getMaxY() > maxY)) continue;
            maxY = content.boundary.getMaxY();
        }
        tree.boundary = new Envelope(minX, maxX, minY, maxY);
        return tree;
    }

    public Envelope getBoundary() {
        return this.boundary;
    }

    public void setBoundary(Envelope boundary) {
        this.boundary = boundary;
    }

    public List<RTree> getChildren() {
        return this.children;
    }

    public void setChildren(List<RTree> children) {
        this.children = children;
    }

    public List<Entry> getContents() {
        return this.contents;
    }

    public void setContents(List<Entry> contents) {
        this.contents = contents;
    }

    public static RTree buildSTR(List<Entry> entries) {
        List<RTree> nodes = RTree.buildSTRBottomLayer(entries);
        return RTree.buildSTRRec(nodes);
    }

    private static List<RTree> buildSTRBottomLayer(List<Entry> entries) {
        int requiredNodeAmount = (int)Math.ceil((0.0 + (double)entries.size()) / (double)capacity);
        int sliceAmount = (int)Math.ceil(Math.sqrt(requiredNodeAmount));
        int entriesPerSlice = (int)Math.ceil((0.0 + (double)entries.size()) / (double)sliceAmount);
        int nodesPerSlice = (int)Math.ceil((0.0 + (double)entriesPerSlice) / (double)capacity);
        ArrayList<RTree> nodes = new ArrayList<RTree>(requiredNodeAmount);
        entries.sort(Comparator.comparingDouble(o -> o.envelope.getMinX() + o.envelope.getMaxX()));
        for (int i = 0; i < sliceAmount; ++i) {
            List<Entry> sliceEntries = entries.subList(i * entriesPerSlice, Math.min((i + 1) * entriesPerSlice, entries.size()));
            sliceEntries.sort(Comparator.comparingDouble(o -> o.envelope.getMinY() + o.envelope.getMaxY()));
            for (int j = 0; j < nodesPerSlice; ++j) {
                List<Entry> nodeEntries = sliceEntries.subList(Math.min(j * capacity, sliceEntries.size()), Math.min((j + 1) * capacity, sliceEntries.size()));
                if (nodeEntries.isEmpty()) continue;
                nodes.add(RTree.createLeaf(nodeEntries));
            }
        }
        return nodes;
    }

    private static RTree buildSTRRec(List<RTree> entries) {
        int requiredNodeAmount = (int)Math.ceil((0.0 + (double)entries.size()) / (double)capacity);
        if (requiredNodeAmount == 0) {
            return RTree.createLeaf(new ArrayList<Entry>());
        }
        if (requiredNodeAmount == 1) {
            return RTree.createParent(entries);
        }
        int sliceAmount = (int)Math.ceil(Math.sqrt(requiredNodeAmount));
        int entriesPerSlice = (int)Math.ceil((0.0 + (double)entries.size()) / (double)sliceAmount);
        int nodesPerSlice = (int)Math.ceil((0.0 + (double)entriesPerSlice) / (double)capacity);
        ArrayList<RTree> nodes = new ArrayList<RTree>(requiredNodeAmount);
        entries.sort(Comparator.comparingDouble(o -> o.boundary.getMinX() + o.boundary.getMaxX()));
        for (int i = 0; i < sliceAmount; ++i) {
            List<RTree> sliceEntries = entries.subList(i * entriesPerSlice, Math.min((i + 1) * entriesPerSlice, entries.size()));
            sliceEntries.sort(Comparator.comparingDouble(o -> o.boundary.getMinY() + o.boundary.getMaxY()));
            for (int j = 0; j < nodesPerSlice; ++j) {
                List<RTree> nodeEntries = sliceEntries.subList(Math.min(j * capacity, sliceEntries.size()), Math.min((j + 1) * capacity, sliceEntries.size()));
                if (nodeEntries.isEmpty()) continue;
                nodes.add(RTree.createParent(nodeEntries));
            }
        }
        return RTree.buildSTRRec(nodes);
    }

    public List<Entry> search(Envelope envelope) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        this.search(envelope, result);
        return result;
    }

    private void search(Envelope envelope, List<Entry> result) {
        if (this.leaf) {
            for (Entry content : this.contents) {
                if (!content.envelope.intersects(envelope)) continue;
                result.add(content);
            }
        } else {
            for (RTree child : this.children) {
                if (!child.boundary.intersects(envelope)) continue;
                child.search(envelope, result);
            }
        }
    }

    public List<Entry> searchExcept(Envelope envelope) {
        ArrayList<Entry> result = new ArrayList<Entry>();
        this.searchExcept(envelope, result);
        return result;
    }

    private void searchExcept(Envelope envelope, List<Entry> result) {
        if (this.leaf) {
            for (Entry content : this.contents) {
                if (content.envelope.intersects(envelope)) continue;
                result.add(content);
            }
        } else {
            for (RTree child : this.children) {
                if (child.boundary.intersects(envelope)) {
                    child.searchExcept(envelope, result);
                    continue;
                }
                child.addRecursive(result);
            }
        }
    }

    private void addRecursive(List<Entry> result) {
        if (this.leaf) {
            result.addAll(this.contents);
        } else {
            for (RTree child : this.children) {
                child.addRecursive(result);
            }
        }
    }

    public static class Entry {
        private final String uri;
        private final Envelope envelope;
        private final Geometry geometry;

        public Entry(String uri, Envelope envelope, Geometry geometry) {
            this.uri = uri;
            this.envelope = envelope;
            this.geometry = geometry;
        }

        public String getUri() {
            return this.uri;
        }

        public Envelope getEnvelope() {
            return this.envelope;
        }

        public Geometry getGeometry() {
            return this.geometry;
        }
    }
}

