/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt;

import org.locationtech.jts.geom.Envelope;

public class CobaltMeasures {
    public static final String EQUALS = "equals";
    public static final String DISJOINT = "disjoint";
    public static final String INTERSECTS = "intersects";
    public static final String TOUCHES = "touches";
    public static final String WITHIN = "within";
    public static final String CONTAINS = "contains";
    public static final String OVERLAPS = "overlaps";
    public static final String COVERS = "covers";
    public static final String COVEREDBY = "coveredby";

    public static double area(Envelope mbb) {
        return mbb.getArea();
    }

    public static double diagonal(Envelope mbb) {
        return Math.sqrt(mbb.getHeight() * mbb.getHeight() + mbb.getWidth() * mbb.getWidth());
    }

    public static Envelope union(Envelope mbbA, Envelope mbbB) {
        return new Envelope(Math.min(mbbA.getMinX(), mbbB.getMinX()), Math.max(mbbA.getMaxX(), mbbB.getMaxX()), Math.min(mbbA.getMinY(), mbbB.getMinY()), Math.max(mbbA.getMaxY(), mbbB.getMaxY()));
    }

    public static Envelope intersection(Envelope mbbA, Envelope mbbB) {
        return mbbA.intersection(mbbB);
    }

    public static boolean projectionX(Envelope mbbA, Envelope mbbB) {
        if (mbbA.getMinX() > mbbB.getMaxX()) {
            return false;
        }
        return !(mbbA.getMaxX() < mbbB.getMinX());
    }

    public static boolean projectionY(Envelope mbbA, Envelope mbbB) {
        if (mbbA.getMinY() > mbbB.getMaxY()) {
            return false;
        }
        return !(mbbA.getMaxY() < mbbB.getMinY());
    }

    public static double distance(Envelope mbbA, Envelope mbbB) {
        if (!CobaltMeasures.projectionX(mbbA, mbbB) && !CobaltMeasures.projectionY(mbbA, mbbB)) {
            return Math.sqrt(Math.pow(Math.min(Math.abs(mbbA.getMinX() - mbbB.getMaxX()), Math.abs(mbbA.getMaxX() - mbbB.getMinX())), 2.0) + Math.pow(Math.min(Math.abs(mbbA.getMinY() - mbbB.getMaxY()), Math.abs(mbbA.getMaxY() - mbbB.getMinY())), 2.0));
        }
        if (CobaltMeasures.union(mbbA, mbbB).getArea() == Math.max(mbbA.getArea(), mbbB.getArea())) {
            return -Math.min(Math.min(Math.abs(mbbA.getMinX() - mbbB.getMinX()), Math.abs(mbbA.getMaxX() - mbbB.getMaxX())), Math.min(Math.abs(mbbA.getMinY() - mbbB.getMinY()), Math.abs(mbbA.getMaxY() - mbbB.getMaxY())));
        }
        if (CobaltMeasures.projectionX(mbbA, mbbB) && !CobaltMeasures.projectionY(mbbA, mbbB)) {
            return Math.min(Math.abs(mbbA.getMinY() - mbbB.getMaxY()), Math.abs(mbbA.getMaxY() - mbbB.getMinY()));
        }
        if (!CobaltMeasures.projectionX(mbbA, mbbB) && CobaltMeasures.projectionY(mbbA, mbbB)) {
            return Math.min(Math.abs(mbbA.getMinX() - mbbB.getMaxX()), Math.abs(mbbA.getMaxX() - mbbB.getMinX()));
        }
        return 0.0;
    }

    public static double fA(Envelope mbbA, Envelope mbbB) {
        return CobaltMeasures.area(mbbA) / CobaltMeasures.area(CobaltMeasures.union(mbbA, mbbB));
    }

    public static double fD(Envelope mbbA, Envelope mbbB) {
        return CobaltMeasures.diagonal(mbbA) / CobaltMeasures.diagonal(CobaltMeasures.union(mbbA, mbbB));
    }

    public static double fM(Envelope mbbA, Envelope mbbB) {
        return (CobaltMeasures.area(mbbA) - 2.0 * CobaltMeasures.area(CobaltMeasures.intersection(mbbA, mbbB))) / CobaltMeasures.area(mbbA) + CobaltMeasures.distance(mbbA, mbbB) / CobaltMeasures.diagonal(mbbA);
    }
}

