/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.cobalt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.mapper.topology.cobalt.RTree;
import org.aksw.limes.core.measures.mapper.topology.cobalt.matcher.ICobaltMatcher;
import org.aksw.limes.core.measures.mapper.topology.cobalt.splitting.CobaltSplitMatcher;
import org.aksw.limes.core.measures.mapper.topology.cobalt.splitting.CobaltSplitter;
import org.aksw.limes.core.measures.mapper.topology.cobalt.splitting.FittingSplitter;
import org.aksw.limes.core.util.LimesWktReader;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cobalt {
    private static final Logger logger = LoggerFactory.getLogger(Cobalt.class);
    public static CobaltSplitter DEFAULT_SPLITTER = new FittingSplitter();

    public static Map<String, Geometry> getGeometryMapFromCache(ACache c, String property) {
        LimesWktReader wktReader = new LimesWktReader();
        HashMap<String, Geometry> gMap = new HashMap<String, Geometry>();
        for (String uri : c.getAllUris()) {
            TreeSet<String> values = c.getInstance(uri).getProperty(property);
            if (values.size() <= 0) continue;
            String wkt = (String)values.iterator().next();
            try {
                gMap.put(uri, wktReader.read(wkt));
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + uri + "...");
            }
        }
        return gMap;
    }

    public static AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold, String relation, ICobaltMatcher matcher) {
        return Cobalt.getMapping(source, target, sourceVar, targetVar, expression, threshold, relation, matcher, 0);
    }

    public static AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold, String relation, ICobaltMatcher matcher, int splits) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Geometry> sourceMap = Cobalt.getGeometryMapFromCache(source, properties.get(0));
        Map<String, Geometry> targetMap = Cobalt.getGeometryMapFromCache(target, properties.get(1));
        if (splits > 0) {
            return Cobalt.getMappingSplits(sourceMap, targetMap, relation, matcher, splits);
        }
        return Cobalt.getMappingEnvelope(Cobalt.toEnvelopeMap(sourceMap), Cobalt.toEnvelopeMap(targetMap), relation, matcher);
    }

    public static AMapping getMapping(Set<Polygon> sourceData, Set<Polygon> targetData, String relation, ICobaltMatcher matcher) {
        return Cobalt.getMapping(sourceData, targetData, relation, matcher, 0);
    }

    public static AMapping getMapping(Set<Polygon> sourceData, Set<Polygon> targetData, String relation, ICobaltMatcher matcher, int splits) {
        HashMap<String, Geometry> source = new HashMap<String, Geometry>();
        HashMap<String, Geometry> target = new HashMap<String, Geometry>();
        for (Polygon polygon : sourceData) {
            try {
                source.put(polygon.uri, polygon.getGeometry());
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + polygon.uri + "...");
            }
        }
        for (Polygon polygon : targetData) {
            try {
                target.put(polygon.uri, polygon.getGeometry());
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + polygon.uri + "...");
            }
        }
        if (splits > 0) {
            return Cobalt.getMappingSplits(source, target, relation, matcher, splits);
        }
        return Cobalt.getMappingEnvelope(Cobalt.toEnvelopeMap(source), Cobalt.toEnvelopeMap(target), relation, matcher);
    }

    public static AMapping getMapping(Map<String, Geometry> sourceData, Map<String, Geometry> targetData, String relation, ICobaltMatcher matcher) {
        return Cobalt.getMapping(sourceData, targetData, relation, matcher, 0);
    }

    public static AMapping getMapping(Map<String, Geometry> sourceData, Map<String, Geometry> targetData, String relation, ICobaltMatcher matcher, int splits) {
        if (splits > 0) {
            return Cobalt.getMappingSplits(sourceData, targetData, relation, matcher, splits);
        }
        return Cobalt.getMappingEnvelope(Cobalt.toEnvelopeMap(sourceData), Cobalt.toEnvelopeMap(targetData), relation, matcher);
    }

    public static Map<String, Envelope> toEnvelopeMap(Map<String, Geometry> data) {
        HashMap<String, Envelope> envelopeMap = new HashMap<String, Envelope>();
        data.forEach((s, geometry) -> envelopeMap.put((String)s, geometry.getEnvelopeInternal()));
        return envelopeMap;
    }

    private static AMapping getMappingEnvelope(Map<String, Envelope> sourceData, Map<String, Envelope> targetData, String relation, ICobaltMatcher matcher) {
        int numThreads = 1;
        ArrayList<RTree.Entry> entries = new ArrayList<RTree.Entry>(sourceData.size());
        sourceData.forEach((s, geometry) -> entries.add(new RTree.Entry((String)s, (Envelope)geometry, null)));
        AMapping m = MappingFactory.createDefaultMapping();
        RTree rTree = RTree.buildSTR(entries);
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        HashMap results = new HashMap();
        for (Map.Entry<String, Envelope> entry : targetData.entrySet()) {
            String uri = entry.getKey();
            Envelope envelope = entry.getValue();
            if (numThreads > 1) {
                HashSet value = new HashSet();
                results.put(uri, value);
                String finalRelation = relation;
                exec.submit(() -> {
                    List<RTree.Entry> search = rTree.search(envelope);
                    search.stream().filter(x -> {
                        Envelope abb = x.getEnvelope();
                        Envelope bbb = envelope;
                        return matcher.relate(abb, bbb, finalRelation);
                    }).forEach(x -> value.add(x.getUri()));
                    if (relation.equals("disjoint")) {
                        value.addAll(rTree.searchExcept(envelope).stream().map(RTree.Entry::getUri).collect(Collectors.toList()));
                    }
                });
                continue;
            }
            String finalRelation = relation;
            AMapping finalM = m;
            List<RTree.Entry> search = rTree.search(envelope);
            search.stream().filter(x -> {
                Envelope abb = x.getEnvelope();
                Envelope bbb = envelope;
                return matcher.relate(abb, bbb, finalRelation);
            }).forEach(x -> finalM.add(x.getUri(), uri, 1.0));
            if (!relation.equals("disjoint")) continue;
            rTree.searchExcept(envelope).stream().map(RTree.Entry::getUri).forEach(sourceUri -> finalM.add((String)sourceUri, uri, 1.0));
        }
        if (numThreads > 1) {
            exec.shutdown();
            try {
                exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                String t = entry.getKey();
                for (String s2 : (Set)entry.getValue()) {
                    m.add(s2, t, 1.0);
                }
            }
        }
        return m;
    }

    private static AMapping getMappingSplits(Map<String, Geometry> sourceData, Map<String, Geometry> targetData, String relation, ICobaltMatcher matcher, int splits) {
        int numThreads = 1;
        CobaltSplitMatcher splitMatcher = new CobaltSplitMatcher(splits, DEFAULT_SPLITTER, matcher);
        ArrayList<RTree.Entry> entries = new ArrayList<RTree.Entry>(sourceData.size());
        sourceData.forEach((s, geometry) -> entries.add(new RTree.Entry((String)s, geometry.getEnvelopeInternal(), (Geometry)geometry)));
        AMapping m = MappingFactory.createDefaultMapping();
        RTree rTree = RTree.buildSTR(entries);
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        HashMap results = new HashMap();
        for (Map.Entry<String, Geometry> entry : targetData.entrySet()) {
            String uri = entry.getKey();
            Geometry geoEntry = entry.getValue();
            Envelope envelope = geoEntry.getEnvelopeInternal();
            if (numThreads > 1) {
                HashSet value = new HashSet();
                results.put(uri, value);
                String finalRelation = relation;
                exec.submit(() -> {
                    List<RTree.Entry> search = rTree.search(envelope);
                    search.stream().filter(x -> {
                        Envelope abb = x.getEnvelope();
                        Envelope bbb = envelope;
                        return splitMatcher.relate(x.getUri(), x.getGeometry(), uri, geoEntry, finalRelation);
                    }).forEach(x -> value.add(x.getUri()));
                    if (relation.equals("disjoint")) {
                        value.addAll(rTree.searchExcept(envelope).stream().map(RTree.Entry::getUri).collect(Collectors.toList()));
                    }
                });
                continue;
            }
            String finalRelation = relation;
            AMapping finalM = m;
            List<RTree.Entry> search = rTree.search(envelope);
            search.stream().filter(x -> {
                Envelope abb = x.getEnvelope();
                Envelope bbb = envelope;
                return splitMatcher.relate(x.getUri(), x.getGeometry(), uri, geoEntry, finalRelation);
            }).forEach(x -> finalM.add(x.getUri(), uri, 1.0));
            if (!relation.equals("disjoint")) continue;
            rTree.searchExcept(envelope).stream().map(RTree.Entry::getUri).forEach(sourceUri -> finalM.add((String)sourceUri, uri, 1.0));
        }
        if (numThreads > 1) {
            exec.shutdown();
            try {
                exec.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            for (Map.Entry<String, Object> entry : results.entrySet()) {
                String t = entry.getKey();
                for (String s2 : (Set)entry.getValue()) {
                    m.add(s2, t, 1.0);
                }
            }
        }
        return m;
    }
}

