/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.RCC8;

import com.vividsolutions.jts.geom.Dimension;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.IntersectionMatrix;
import com.vividsolutions.jts.operation.relate.RelateOp;

public class ReducedIntersectionMatrix {
    private static int[][] im;

    public ReducedIntersectionMatrix(String elements) {
        this();
        im = new int[2][2];
        this.set(elements);
    }

    public ReducedIntersectionMatrix(Geometry g1, Geometry g2) {
        this();
        this.computeIM(g1, g2);
    }

    public ReducedIntersectionMatrix() {
    }

    public void computeIM(Geometry g1, Geometry g2) {
        int row = 0;
        int col = 0;
        RelateOp relateOp = new RelateOp(g1, g2);
        IntersectionMatrix deIM = relateOp.getIntersectionMatrix();
        im = new int[2][2];
        for (int i = 0; i < 4; ++i) {
            row = i / 2;
            col = i % 2;
            ReducedIntersectionMatrix.im[row][col] = deIM.get(row, col);
        }
    }

    public static boolean isTrue(int actualDimensionValue) {
        return actualDimensionValue >= 0 || actualDimensionValue == -2;
    }

    public void set(String dimensionSymbols) {
        for (int i = 0; i < 4; ++i) {
            int row = i / 2;
            int col = i % 2;
            ReducedIntersectionMatrix.im[row][col] = Dimension.toDimensionValue((char)dimensionSymbols.charAt(i));
        }
    }

    public boolean disConnected_DC() {
        return im[0][0] == -1 && im[1][1] == -1;
    }

    public boolean connected_C() {
        return !this.disConnected_DC();
    }

    public boolean externallyConnected_EC() {
        return im[0][0] == -1 && ReducedIntersectionMatrix.isTrue(im[1][1]);
    }

    public boolean properlyOverlap_PO() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && ReducedIntersectionMatrix.isTrue(im[0][1]) && ReducedIntersectionMatrix.isTrue(im[1][0]) && ReducedIntersectionMatrix.isTrue(im[1][1]);
    }

    public boolean equal_EQ() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && ReducedIntersectionMatrix.isTrue(im[1][1]) && im[0][1] == -1 && im[1][0] == -1;
    }

    public boolean tangentialProperPart_TPP() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && ReducedIntersectionMatrix.isTrue(im[1][1]) && ReducedIntersectionMatrix.isTrue(im[1][0]) && im[0][1] == -1;
    }

    public boolean nonTangentialProperPart_NTPP() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && im[1][1] == -1 && im[0][1] == -1 && ReducedIntersectionMatrix.isTrue(im[1][0]);
    }

    public boolean tangentialProperPartConvers_TPPc() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && ReducedIntersectionMatrix.isTrue(im[1][1]) && ReducedIntersectionMatrix.isTrue(im[0][1]) && im[1][0] == -1;
    }

    public boolean nonTangentialProperPartConvers_NTPPc() {
        return ReducedIntersectionMatrix.isTrue(im[0][0]) && im[1][1] == -1 && ReducedIntersectionMatrix.isTrue(im[0][1]) && im[1][0] == -1;
    }
}

