/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.topology.RCC8;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import com.vividsolutions.jts.io.WKTReader;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.mapper.topology.RCC8.ReducedIntersectionMatrix;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LDbasedRCC {
    public static String heuristicStatMeasure = "avg";
    private static final Logger logger = LoggerFactory.getLogger(LDbasedRCC.class);

    public static Map<String, Geometry> getGeometryMapFromCache(ACache c, String property) {
        WKTReader wktReader = new WKTReader();
        HashMap<String, Geometry> gMap = new HashMap<String, Geometry>();
        for (String uri : c.getAllUris()) {
            TreeSet<String> values = c.getInstance(uri).getProperty(property);
            if (values.size() <= 0) continue;
            String wkt = (String)values.iterator().next();
            try {
                gMap.put(uri, wktReader.read(wkt));
            }
            catch (ParseException e) {
                logger.warn("Skipping malformed geometry at " + uri + "...");
            }
        }
        return gMap;
    }

    public static List<AMapping> getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        Map<String, Geometry> sourceMap = LDbasedRCC.getGeometryMapFromCache(source, properties.get(0));
        Map<String, Geometry> targetMap = LDbasedRCC.getGeometryMapFromCache(target, properties.get(1));
        return LDbasedRCC.getMapping(sourceMap, targetMap);
    }

    public static List<AMapping> getMapping(Map<String, Geometry> sourceData, Map<String, Geometry> targetData) {
        int numThreads = new Double(Math.ceil((double)Runtime.getRuntime().availableProcessors() / 2.0)).intValue();
        GridSizeHeuristics heuristicsS = new GridSizeHeuristics(sourceData.values());
        GridSizeHeuristics heuristicsT = new GridSizeHeuristics(targetData.values());
        double[] theta = GridSizeHeuristics.decideForTheta(heuristicsS, heuristicsT, heuristicStatMeasure);
        double thetaX = theta[0];
        double thetaY = theta[1];
        boolean swapped = GridSizeHeuristics.swap;
        if (swapped) {
            Map<String, Geometry> swap = sourceData;
            sourceData = targetData;
            targetData = swap;
        }
        SquareIndex sourceIndex = LDbasedRCC.index(sourceData, null, thetaX, thetaY);
        SquareIndex targetIndex = LDbasedRCC.index(targetData, sourceIndex, thetaX, thetaY);
        ArrayList<AMapping> allMapResults = new ArrayList<AMapping>();
        AMapping connected_C = MappingFactory.createDefaultMapping();
        AMapping externallyConnected_EC = MappingFactory.createDefaultMapping();
        AMapping properlyOverlap_PO = MappingFactory.createDefaultMapping();
        AMapping equal_EQ = MappingFactory.createDefaultMapping();
        AMapping tangentialProperPart_TPP = MappingFactory.createDefaultMapping();
        AMapping nonTangentialProperPart_NTPP = MappingFactory.createDefaultMapping();
        AMapping tangentialProperPartConvers_TPPc = MappingFactory.createDefaultMapping();
        AMapping nonTangentialProperPartConvers_NTPPc = MappingFactory.createDefaultMapping();
        allMapResults.add(connected_C);
        allMapResults.add(externallyConnected_EC);
        allMapResults.add(properlyOverlap_PO);
        allMapResults.add(equal_EQ);
        allMapResults.add(tangentialProperPart_TPP);
        allMapResults.add(nonTangentialProperPart_NTPP);
        allMapResults.add(tangentialProperPartConvers_TPPc);
        allMapResults.add(nonTangentialProperPartConvers_NTPPc);
        ExecutorService matchExec = Executors.newFixedThreadPool(numThreads);
        ExecutorService mergerExec = Executors.newFixedThreadPool(1);
        List<Map<String, Set<String>>> results = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results1 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results2 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results3 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results4 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results5 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results6 = Collections.synchronizedList(new ArrayList());
        List<Map<String, Set<String>>> results7 = Collections.synchronizedList(new ArrayList());
        List<List<Map<String, Set<String>>>> allResults = Collections.synchronizedList(new ArrayList());
        allResults.add(results);
        allResults.add(results1);
        allResults.add(results2);
        allResults.add(results3);
        allResults.add(results4);
        allResults.add(results5);
        allResults.add(results6);
        allResults.add(results7);
        HashMap computed = new HashMap();
        Matcher matcher = new Matcher(results);
        Matcher matcher1 = new Matcher(results1);
        Matcher matcher2 = new Matcher(results2);
        Matcher matcher3 = new Matcher(results3);
        Matcher matcher4 = new Matcher(results4);
        Matcher matcher5 = new Matcher(results5);
        Matcher matcher6 = new Matcher(results6);
        Matcher matcher7 = new Matcher(results7);
        ArrayList<Matcher> matchers = new ArrayList<Matcher>();
        matchers.add(matcher);
        matchers.add(matcher1);
        matchers.add(matcher2);
        matchers.add(matcher3);
        matchers.add(matcher4);
        matchers.add(matcher5);
        matchers.add(matcher6);
        matchers.add(matcher7);
        for (Integer lat : sourceIndex.map.keySet()) {
            for (Integer lon : sourceIndex.map.get(lat).keySet()) {
                List<MBBIndex> source = sourceIndex.getSquare(lat, lon);
                List<MBBIndex> target = targetIndex.getSquare(lat, lon);
                if (target == null || target.size() <= 0) continue;
                for (MBBIndex a : source) {
                    if (!computed.containsKey(a.uri)) {
                        computed.put(a.uri, new HashSet());
                    }
                    for (MBBIndex b : target) {
                        if (((Set)computed.get(a.uri)).contains(b.uri)) continue;
                        ((Set)computed.get(a.uri)).add(b.uri);
                        List<Object> allRelations = new ArrayList();
                        allRelations = Matcher.relate1(a.polygon, b.polygon);
                        if (numThreads == 1) {
                            if (((Boolean)allRelations.get(0)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(0)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(0)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(1)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(1)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(1)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(2)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(2)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(2)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(3)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(3)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(3)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(4)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(4)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(4)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(5)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(5)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(5)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (((Boolean)allRelations.get(6)).booleanValue()) {
                                if (swapped) {
                                    ((AMapping)allMapResults.get(6)).add(b.origin_uri, a.origin_uri, 1.0);
                                } else {
                                    ((AMapping)allMapResults.get(6)).add(a.origin_uri, b.origin_uri, 1.0);
                                }
                            }
                            if (!((Boolean)allRelations.get(7)).booleanValue()) continue;
                            if (swapped) {
                                ((AMapping)allMapResults.get(7)).add(b.origin_uri, a.origin_uri, 1.0);
                                continue;
                            }
                            ((AMapping)allMapResults.get(7)).add(a.origin_uri, b.origin_uri, 1.0);
                            continue;
                        }
                        if (((Boolean)allRelations.get(0)).booleanValue()) {
                            ((Matcher)matchers.get(0)).schedule(a, b);
                            if (((Matcher)matchers.get(0)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(0));
                                matcher = new Matcher((List)allResults.get(0));
                                if (((List)allResults.get(0)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(0), (AMapping)allMapResults.get(0)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(1)).booleanValue()) {
                            ((Matcher)matchers.get(1)).schedule(a, b);
                            if (((Matcher)matchers.get(1)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(1));
                                matcher1 = new Matcher((List)allResults.get(1));
                                if (((List)allResults.get(1)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(1), (AMapping)allMapResults.get(1)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(2)).booleanValue()) {
                            ((Matcher)matchers.get(2)).schedule(a, b);
                            if (((Matcher)matchers.get(2)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(2));
                                matcher2 = new Matcher((List)allResults.get(2));
                                if (((List)allResults.get(2)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(2), (AMapping)allMapResults.get(2)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(3)).booleanValue()) {
                            ((Matcher)matchers.get(3)).schedule(a, b);
                            if (((Matcher)matchers.get(3)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(3));
                                matcher3 = new Matcher((List)allResults.get(3));
                                if (((List)allResults.get(3)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(3), (AMapping)allMapResults.get(3)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(4)).booleanValue()) {
                            ((Matcher)matchers.get(4)).schedule(a, b);
                            if (((Matcher)matchers.get(4)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(4));
                                matcher4 = new Matcher((List)allResults.get(4));
                                if (((List)allResults.get(4)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(4), (AMapping)allMapResults.get(4)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(5)).booleanValue()) {
                            ((Matcher)matchers.get(5)).schedule(a, b);
                            if (((Matcher)matchers.get(5)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(5));
                                matcher5 = new Matcher((List)allResults.get(5));
                                if (((List)allResults.get(5)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(5), (AMapping)allMapResults.get(5)));
                                }
                            }
                        }
                        if (((Boolean)allRelations.get(6)).booleanValue()) {
                            ((Matcher)matchers.get(6)).schedule(a, b);
                            if (((Matcher)matchers.get(6)).size() == Matcher.maxSize) {
                                matchExec.execute((Runnable)matchers.get(6));
                                matcher6 = new Matcher((List)allResults.get(6));
                                if (((List)allResults.get(6)).size() > 0) {
                                    mergerExec.execute(new Merger((List)allResults.get(6), (AMapping)allMapResults.get(6)));
                                }
                            }
                        }
                        if (!((Boolean)allRelations.get(7)).booleanValue()) continue;
                        ((Matcher)matchers.get(7)).schedule(a, b);
                        if (((Matcher)matchers.get(7)).size() != Matcher.maxSize) continue;
                        matchExec.execute((Runnable)matchers.get(7));
                        matcher7 = new Matcher((List)allResults.get(7));
                        if (((List)allResults.get(7)).size() <= 0) continue;
                        mergerExec.execute(new Merger((List)allResults.get(7), (AMapping)allMapResults.get(7)));
                    }
                }
            }
        }
        if (numThreads > 1) {
            if (((Matcher)matchers.get(0)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(0));
            }
            if (((Matcher)matchers.get(1)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(1));
            }
            if (((Matcher)matchers.get(2)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(2));
            }
            if (((Matcher)matchers.get(3)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(3));
            }
            if (((Matcher)matchers.get(4)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(4));
            }
            if (((Matcher)matchers.get(5)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(5));
            }
            if (((Matcher)matchers.get(6)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(6));
            }
            if (((Matcher)matchers.get(7)).size() > 0) {
                matchExec.execute((Runnable)matchers.get(7));
            }
            matchExec.shutdown();
            while (!matchExec.isTerminated()) {
                try {
                    if (((List)allResults.get(0)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(0), (AMapping)allMapResults.get(0)));
                    }
                    if (((List)allResults.get(1)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(1), (AMapping)allMapResults.get(1)));
                    }
                    if (((List)allResults.get(2)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(2), (AMapping)allMapResults.get(2)));
                    }
                    if (((List)allResults.get(3)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(3), (AMapping)allMapResults.get(3)));
                    }
                    if (((List)allResults.get(4)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(4), (AMapping)allMapResults.get(4)));
                    }
                    if (((List)allResults.get(5)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(5), (AMapping)allMapResults.get(5)));
                    }
                    if (((List)allResults.get(6)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(6), (AMapping)allMapResults.get(6)));
                    }
                    if (((List)allResults.get(7)).size() > 0) {
                        mergerExec.execute(new Merger((List)allResults.get(7), (AMapping)allMapResults.get(7)));
                    }
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            if (((List)allResults.get(0)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(0), (AMapping)allMapResults.get(0)));
            }
            if (((List)allResults.get(1)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(1), (AMapping)allMapResults.get(1)));
            }
            if (((List)allResults.get(2)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(2), (AMapping)allMapResults.get(2)));
            }
            if (((List)allResults.get(3)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(3), (AMapping)allMapResults.get(3)));
            }
            if (((List)allResults.get(4)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(4), (AMapping)allMapResults.get(4)));
            }
            if (((List)allResults.get(5)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(5), (AMapping)allMapResults.get(5)));
            }
            if (((List)allResults.get(6)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(6), (AMapping)allMapResults.get(6)));
            }
            if (((List)allResults.get(7)).size() > 0) {
                mergerExec.execute(new Merger((List)allResults.get(7), (AMapping)allMapResults.get(7)));
            }
            mergerExec.shutdown();
            while (!mergerExec.isTerminated()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        return allMapResults;
    }

    public static SquareIndex index(Map<String, Geometry> input, SquareIndex extIndex, double thetaX, double thetaY) {
        SquareIndex result = new SquareIndex();
        for (String p : input.keySet()) {
            Geometry g = input.get(p);
            Envelope envelope = g.getEnvelopeInternal();
            int minLatIndex = (int)Math.floor(envelope.getMinY() * thetaY);
            int maxLatIndex = (int)Math.ceil(envelope.getMaxY() * thetaY);
            int minLongIndex = (int)Math.floor(envelope.getMinX() * thetaX);
            int maxLongIndex = (int)Math.ceil(envelope.getMaxX() * thetaX);
            if (minLongIndex < (int)Math.floor(-90.0 * thetaX) && maxLongIndex > (int)Math.ceil(90.0 * thetaX)) {
                MBBIndex westernPart = new MBBIndex(minLatIndex, (int)Math.floor(-180.0 * thetaX), maxLatIndex, minLongIndex, g, p + "<}W", p);
                LDbasedRCC.addToIndex(westernPart, result, extIndex);
                MBBIndex easternPart = new MBBIndex(minLatIndex, maxLongIndex, maxLatIndex, (int)Math.ceil(180.0 * thetaX), g, p + "<}E", p);
                LDbasedRCC.addToIndex(easternPart, result, extIndex);
                continue;
            }
            MBBIndex mbbIndex = new MBBIndex(minLatIndex, minLongIndex, maxLatIndex, maxLongIndex, g, p);
            LDbasedRCC.addToIndex(mbbIndex, result, extIndex);
        }
        return result;
    }

    private static void addToIndex(MBBIndex mbbIndex, SquareIndex result, SquareIndex extIndex) {
        if (extIndex == null) {
            for (int latIndex = mbbIndex.lat1; latIndex <= mbbIndex.lat2; ++latIndex) {
                for (int longIndex = mbbIndex.lon1; longIndex <= mbbIndex.lon2; ++longIndex) {
                    result.add(latIndex, longIndex, mbbIndex);
                }
            }
        } else {
            for (int latIndex = mbbIndex.lat1; latIndex <= mbbIndex.lat2; ++latIndex) {
                for (int longIndex = mbbIndex.lon1; longIndex <= mbbIndex.lon2; ++longIndex) {
                    if (extIndex.getSquare(latIndex, longIndex) == null) continue;
                    result.add(latIndex, longIndex, mbbIndex);
                }
            }
        }
    }

    public static class Merger
    implements Runnable {
        private AMapping m;
        private List<Map<String, Set<String>>> localResults = new ArrayList<Map<String, Set<String>>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Merger(List<Map<String, Set<String>>> results, AMapping m) {
            this.m = m;
            List<Map<String, Set<String>>> list = results;
            synchronized (list) {
                ListIterator<Map<String, Set<String>>> iterator = results.listIterator();
                while (iterator.hasNext()) {
                    this.localResults.add((Map)iterator.next());
                    iterator.remove();
                }
            }
        }

        @Override
        public void run() {
            for (Map<String, Set<String>> result : this.localResults) {
                for (String s : result.keySet()) {
                    for (String t : result.get(s)) {
                        if (GridSizeHeuristics.swap) {
                            this.m.add(t, s, 1.0);
                            continue;
                        }
                        this.m.add(s, t, 1.0);
                    }
                }
            }
        }
    }

    public static class Matcher
    implements Runnable {
        public static int maxSize = 1000;
        private final List<Map<String, Set<String>>> result;
        private List<MBBIndex> scheduled;

        public Matcher(List<Map<String, Set<String>>> result) {
            this.result = result;
            this.scheduled = new ArrayList<MBBIndex>();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            HashMap temp = new HashMap();
            for (int i = 0; i < this.scheduled.size(); i += 2) {
                MBBIndex s = this.scheduled.get(i);
                MBBIndex t = this.scheduled.get(i + 1);
                if (!temp.containsKey(s.origin_uri)) {
                    temp.put(s.origin_uri, new HashSet());
                }
                ((Set)temp.get(s.origin_uri)).add(t.origin_uri);
            }
            List<Map<String, Set<String>>> list = this.result;
            synchronized (list) {
                this.result.add(temp);
            }
        }

        public void schedule(MBBIndex s, MBBIndex t) {
            this.scheduled.add(s);
            this.scheduled.add(t);
        }

        public int size() {
            return this.scheduled.size();
        }

        private static List<Boolean> relate1(Geometry geometry1, Geometry geometry2) {
            ArrayList<Boolean> allRelations = new ArrayList<Boolean>();
            ReducedIntersectionMatrix relationIM = new ReducedIntersectionMatrix(geometry1, geometry2);
            boolean connected_C = relationIM.connected_C();
            boolean externallyConnected_EC = relationIM.externallyConnected_EC();
            boolean properlyOverlap_PO = relationIM.properlyOverlap_PO();
            boolean equal_EQ = relationIM.equal_EQ();
            boolean tangentialProperPart_TPP = relationIM.tangentialProperPart_TPP();
            boolean nonTangentialProperPart_NTPP = relationIM.nonTangentialProperPart_NTPP();
            boolean tangentialProperPartConvers_TPPc = relationIM.tangentialProperPartConvers_TPPc();
            boolean nonTangentialProperPartConvers_NTPPc = relationIM.nonTangentialProperPartConvers_NTPPc();
            allRelations.add(connected_C);
            allRelations.add(externallyConnected_EC);
            allRelations.add(properlyOverlap_PO);
            allRelations.add(equal_EQ);
            allRelations.add(tangentialProperPart_TPP);
            allRelations.add(nonTangentialProperPart_NTPP);
            allRelations.add(tangentialProperPartConvers_TPPc);
            allRelations.add(nonTangentialProperPartConvers_NTPPc);
            return allRelations;
        }
    }

    public static class SquareIndex {
        public HashMap<Integer, HashMap<Integer, List<MBBIndex>>> map = new HashMap();

        public SquareIndex() {
        }

        public SquareIndex(int capacity) {
            this.map = new HashMap(capacity);
        }

        public void add(int i, int j, MBBIndex m) {
            if (!this.map.containsKey(i)) {
                this.map.put(i, new HashMap());
            }
            if (!this.map.get(i).containsKey(j)) {
                this.map.get(i).put(j, new ArrayList());
            }
            this.map.get(i).get(j).add(m);
        }

        public List<MBBIndex> getSquare(int i, int j) {
            if (!this.map.containsKey(i) || !this.map.get(i).containsKey(j)) {
                return null;
            }
            return this.map.get(i).get(j);
        }
    }

    public static class MBBIndex {
        public int lat1;
        public int lat2;
        public int lon1;
        public int lon2;
        public Geometry polygon;
        private String uri;
        private String origin_uri;

        public MBBIndex(int lat1, int lon1, int lat2, int lon2, Geometry polygon, String uri) {
            this.lat1 = lat1;
            this.lat2 = lat2;
            this.lon1 = lon1;
            this.lon2 = lon2;
            this.polygon = polygon;
            this.uri = uri;
            this.origin_uri = uri;
        }

        public MBBIndex(int lat1, int lon1, int lat2, int lon2, Geometry polygon, String uri, String origin_uri) {
            this.lat1 = lat1;
            this.lat2 = lat2;
            this.lon1 = lon1;
            this.lon2 = lon2;
            this.polygon = polygon;
            this.uri = uri;
            this.origin_uri = origin_uri;
        }

        public boolean contains(MBBIndex i) {
            return this.lat1 <= i.lat1 && this.lon1 <= i.lon1 && this.lon2 >= i.lon2 && this.lat2 >= i.lat2;
        }

        public boolean covers(MBBIndex i) {
            return this.lat1 <= i.lat1 && this.lon1 <= i.lon1 && this.lon2 >= i.lon2 && this.lat2 >= i.lat2;
        }

        public boolean intersects(MBBIndex i) {
            return !this.disjoint(i);
        }

        public boolean disjoint(MBBIndex i) {
            return this.lat2 < i.lat1 || this.lat1 > i.lat2 || this.lon2 < i.lon1 || this.lon1 > i.lon2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof MBBIndex)) {
                return false;
            }
            MBBIndex i = (MBBIndex)o;
            return this.lat1 == i.lat1 && this.lat2 == i.lat2 && this.lon1 == i.lon1 && this.lon2 == i.lon2;
        }
    }

    public static class GridSizeHeuristics {
        public static final String AVG = "avg";
        public static final String MIN = "min";
        public static final String MAX = "max";
        public static final String MED = "median";
        public static boolean swap = false;
        private double size;
        private double minX;
        private double maxX;
        private double avgX;
        private double medX;
        private double minY;
        private double maxY;
        private double avgY;
        private double medY;

        public static double[] decideForTheta(GridSizeHeuristics s, GridSizeHeuristics t, String measure) {
            double[] stats;
            switch (measure) {
                case "max": {
                    stats = new double[]{s.maxX, s.maxY, t.maxX, t.maxY};
                    break;
                }
                case "avg": {
                    stats = new double[]{s.avgX, s.avgY, t.avgX, t.avgY};
                    break;
                }
                case "median": {
                    stats = new double[]{s.medX, s.medY, t.medX, t.medY};
                    break;
                }
                default: {
                    stats = new double[]{s.minX, s.minY, t.minX, t.minY};
                }
            }
            double estAreaS = stats[0] * stats[1] * s.size;
            double estAreaT = stats[2] * stats[3] * t.size;
            swap = estAreaS > estAreaT;
            return new double[]{2.0 / (stats[0] + stats[2]), 2.0 / (stats[1] + stats[3])};
        }

        public GridSizeHeuristics(Collection<Geometry> input) {
            double[] x = new double[input.size()];
            double[] y = new double[input.size()];
            int i = 0;
            for (Geometry geometry : input) {
                Envelope e = geometry.getEnvelopeInternal();
                y[i] = e.getHeight();
                x[i] = e.getWidth();
                ++i;
            }
            this.size = input.size();
            Arrays.sort(x);
            this.minX = x[0];
            this.maxX = x[x.length - 1];
            this.avgX = Arrays.stream(x).average().getAsDouble();
            this.medX = x.length % 2 == 0 ? (x[x.length / 2 - 1] + x[x.length / 2]) / 2.0 : x[x.length / 2];
            Arrays.sort(y);
            this.minY = y[0];
            this.maxY = y[y.length - 1];
            this.avgY = Arrays.stream(y).average().getAsDouble();
            this.medY = y.length % 2 == 0 ? (y[y.length / 2 - 1] + y[y.length / 2]) / 2.0 : y[y.length / 2];
        }

        public double getSize() {
            return this.size;
        }

        public double getMinX() {
            return this.minX;
        }

        public double getMaxX() {
            return this.maxX;
        }

        public double getAvgX() {
            return this.avgX;
        }

        public double getMedX() {
            return this.medX;
        }

        public double getMinY() {
            return this.minY;
        }

        public double getMaxY() {
            return this.maxY;
        }

        public double getAvgY() {
            return this.avgY;
        }

        public double getMedY() {
            return this.medY;
        }

        public String toString() {
            DecimalFormat df = new DecimalFormat("0.0000");
            return "[MIN(" + df.format(this.minX) + ";" + df.format(this.minY) + ");MAX(" + df.format(this.maxX) + ";" + df.format(this.maxY) + ";AVG(" + df.format(this.avgX) + ";" + df.format(this.avgY) + ");MED(" + df.format(this.medX) + ";" + df.format(this.medY) + ")]";
        }
    }
}

