/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls.nlg.en;

import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.ls.nlg.ALSPreprocessor;
import simplenlg.framework.CoordinatedPhraseElement;
import simplenlg.framework.NLGElement;
import simplenlg.framework.NLGFactory;
import simplenlg.lexicon.Lexicon;
import simplenlg.lexicon.XMLLexicon;
import simplenlg.phrasespec.NPPhraseSpec;
import simplenlg.phrasespec.PPPhraseSpec;

public class LsPreProcessorEN
extends ALSPreprocessor {
    protected Lexicon lexicon = new XMLLexicon();
    protected NLGFactory nlgFactory = new NLGFactory(this.lexicon);

    public NPPhraseSpec atomicMeasure(LinkSpecification linkSpec) {
        String atomicMeasureString = linkSpec.getAtomicMeasure();
        NPPhraseSpec n1 = this.nlgFactory.createNounPhrase((Object)atomicMeasureString);
        return n1;
    }

    public NPPhraseSpec atomicSimilarity(LinkSpecification linkSpec) {
        String atomicMeasureString = linkSpec.getAtomicMeasure();
        atomicMeasureString = this.makeFirstCharUppercaseRestLowercase(atomicMeasureString);
        NPPhraseSpec n2 = this.nlgFactory.createNounPhrase((Object)atomicMeasureString);
        NPPhraseSpec similarity = this.nlgFactory.createNounPhrase((Object)" similarity");
        n2.setDeterminer((Object)"a");
        n2.addPostModifier((NLGElement)similarity);
        return n2;
    }

    public CoordinatedPhraseElement coordinate(LinkSpecification linkSpec) {
        String leftProp = this.leftProperty(linkSpec);
        String rightProp = this.rightProperty(linkSpec);
        NPPhraseSpec leftP = this.nlgFactory.createNounPhrase((Object)"the", (Object)"resource");
        leftP.setFeature("possessive", true);
        NPPhraseSpec leftPValue = this.nlgFactory.createNounPhrase((Object)leftProp);
        leftPValue.setFeature("specifier", (Object)leftP);
        leftPValue.addComplement("of the source");
        NPPhraseSpec rightP = this.nlgFactory.createNounPhrase((Object)"the", (Object)"resource");
        rightP.setFeature("possessive", true);
        NPPhraseSpec rightPValue = this.nlgFactory.createNounPhrase((Object)rightProp);
        rightPValue.setFeature("specifier", (Object)rightP);
        rightPValue.addComplement("of the target");
        CoordinatedPhraseElement coordinate_1 = this.nlgFactory.createCoordinatedPhrase((Object)leftPValue, (Object)rightPValue);
        return coordinate_1;
    }

    public NPPhraseSpec theta(LinkSpecification linkSpec) {
        double d = linkSpec.getThreshold() * 100.0;
        d = Math.round(d * 100.0 / 100.0);
        int dAsInteger = (int)d;
        NPPhraseSpec theta = this.nlgFactory.createNounPhrase((Object)(dAsInteger + "%"));
        PPPhraseSpec pp = this.nlgFactory.createPrepositionPhrase();
        pp.addComplement((NLGElement)theta);
        pp.setPreposition((Object)"of");
        return theta;
    }

    public NPPhraseSpec resourceValue(LinkSpecification linkSpec) {
        String function = linkSpec.getMeasure().substring(0, linkSpec.getMeasure().indexOf("("));
        NPPhraseSpec resource = this.nlgFactory.createNounPhrase((Object)"resource");
        resource.setFeature("possessive", true);
        NPPhraseSpec resourceValue = this.nlgFactory.createNounPhrase((Object)function);
        return resourceValue;
    }
}

