/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls.nlg.de;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.ls.nlg.de.LsPreProcessorDE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import simplenlgde.features.DiscourseFunction;
import simplenlgde.features.NumberAgreement;
import simplenlgde.framework.CoordinatedPhraseElement;
import simplenlgde.framework.NLGElement;
import simplenlgde.framework.NLGFactory;
import simplenlgde.framework.StringElement;
import simplenlgde.lexicon.Lexicon;
import simplenlgde.phrasespec.AdjPhraseSpec;
import simplenlgde.phrasespec.NPPhraseSpec;
import simplenlgde.phrasespec.SPhraseSpec;
import simplenlgde.realiser.Realiser;

public class LinkSpecSummeryDE {
    private static Logger logger = LoggerFactory.getLogger(LinkSpecSummeryDE.class);
    private List<NLGElement> allOperator = new ArrayList<NLGElement>();
    private String AggregationResult = "";
    private Lexicon lexicon = Lexicon.getDefaultLexicon();
    protected NLGFactory nlgFactory = new NLGFactory(this.lexicon);
    private NPPhraseSpec name;
    private NPPhraseSpec subject;
    private NPPhraseSpec measureName;
    private NPPhraseSpec theta;
    protected String previousSubject = "";
    private String previousStringTheta = "";
    private List<NLGElement> result = new ArrayList<NLGElement>();
    protected CoordinatedPhraseElement objCollection = this.nlgFactory.createCoordinatedPhrase();
    private LsPreProcessorDE lsPreProcessor = new LsPreProcessorDE();

    protected List<NLGElement> fullMeasureNLG(LinkSpecification linkspec) {
        SPhraseSpec clause = this.nlgFactory.createClause();
        if (linkspec.isAtomic()) {
            NPPhraseSpec name = this.lsPreProcessor.atomicSimilarity(linkspec);
            NPPhraseSpec resourceValue = this.lsPreProcessor.resourceValue(linkspec);
            NPPhraseSpec theta = this.lsPreProcessor.theta(linkspec);
            CoordinatedPhraseElement coordinate = this.lsPreProcessor.coordinate(linkspec);
            double d = linkspec.getLowThreshold();
        } else {
            for (int i = 0; i < linkspec.getChildren().size(); ++i) {
                String operatorAsString = linkspec.getOperator().toString().toLowerCase();
                StringElement complementElement = null;
                if (operatorAsString.equals("and")) {
                    complementElement = new StringElement("und");
                } else if (operatorAsString.equals("or")) {
                    complementElement = new StringElement("oder");
                }
                if (!this.allOperator.isEmpty()) {
                    this.AggregationResult = this.AggregationResult + "," + complementElement.toString();
                }
                this.allOperator.add((NLGElement)complementElement);
                LinkSpecification linkSpecification = linkspec.getChildren().get(i);
                if (linkSpecification.isAtomic()) {
                    AdjPhraseSpec adjective;
                    this.name = this.lsPreProcessor.atomicSimilarity(linkSpecification);
                    NPPhraseSpec resourceValue = this.lsPreProcessor.resourceValue(linkSpecification);
                    this.theta = this.lsPreProcessor.theta(linkSpecification);
                    CoordinatedPhraseElement coordinate = this.lsPreProcessor.coordinate(linkSpecification);
                    String rightProp2 = this.lsPreProcessor.leftProperty(linkSpecification);
                    String leftProp2 = this.lsPreProcessor.rightProperty(linkSpecification);
                    NPPhraseSpec firstSubject = this.subject(coordinate, rightProp2, leftProp2);
                    double d = linkSpecification.getThreshold();
                    String stringTheta = "";
                    if (d == 1.0) {
                        stringTheta = " \u00dcbereinstimmung";
                        adjective = this.nlgFactory.createAdjectivePhrase((Object)"genau");
                        adjective.setFeature("is_comparative", true);
                        this.subject = this.nlgFactory.createNounPhrase((Object)stringTheta);
                        this.subject.addModifier((NLGElement)adjective);
                        this.name.setFeature("case", (Object)DiscourseFunction.GENITIVE);
                        this.subject.addComplement((NLGElement)this.name);
                    }
                    if (d == 0.0) {
                        stringTheta = "Nicht\u00fcbereinstimmung";
                        adjective = this.nlgFactory.createAdjectivePhrase((Object)"vollst\u00e4ndig");
                        adjective.setFeature("is_comparative", true);
                        this.subject = this.nlgFactory.createNounPhrase((Object)stringTheta);
                        this.subject.addModifier((NLGElement)adjective);
                        this.name.setFeature("case", (Object)DiscourseFunction.GENITIVE);
                        this.subject.addComplement((NLGElement)this.name);
                    }
                    if (d > 0.0 && d < 1.0) {
                        Realiser clause2Realiser = new Realiser(this.lexicon);
                        NLGElement thetaRealised = clause2Realiser.realise((NLGElement)this.theta);
                        String thetaAString = thetaRealised.toString();
                        this.subject = this.nlgFactory.createNounPhrase((Object)thetaAString);
                        this.name.setFeature("case", (Object)DiscourseFunction.GENITIVE);
                        this.subject.addComplement((NLGElement)this.name);
                    }
                    this.measureName = this.lsPreProcessor.atomicSimilarity(linkSpecification);
                    Realiser firstSubjectRealiser = new Realiser(this.lexicon);
                    NLGElement firstSubjectRealised = firstSubjectRealiser.realise((NLGElement)firstSubject);
                    if (this.previousSubject.equals(firstSubjectRealised.toString())) {
                        if (operatorAsString.equals("and")) {
                            this.objCollection.addCoordinate((Object)"und");
                        }
                        if (operatorAsString.equals("or")) {
                            this.objCollection.addCoordinate((Object)"oder");
                        }
                        this.objCollection.setFeature("conjunction", (Object)"");
                        if (this.previousStringTheta.equals(stringTheta)) {
                            this.objCollection.setFeature("conjunction", (Object)"");
                            this.objCollection.addCoordinate((Object)this.measureName);
                            continue;
                        }
                        this.objCollection.setFeature("conjunction", (Object)"");
                        this.objCollection.addCoordinate((Object)this.subject);
                        this.previousStringTheta = stringTheta;
                        continue;
                    }
                    if (!this.objCollection.getChildren().isEmpty()) {
                        NPPhraseSpec tempS = this.nlgFactory.createNounPhrase((Object)this.previousSubject);
                        if (this.previousSubject.contains("die Ressource")) {
                            tempS.setPlural(true);
                        }
                        clause.setSubject((Object)tempS);
                        clause.setVerb((Object)"haben");
                        clause.setObject((Object)this.objCollection);
                        Realiser clauseRealiser = new Realiser(this.lexicon);
                        NLGElement clauseRealised = clauseRealiser.realise((NLGElement)clause);
                        this.result.add(clauseRealised);
                        this.result.add((NLGElement)complementElement);
                        this.objCollection.clearCoordinates();
                        this.previousSubject = firstSubjectRealised.toString();
                        this.objCollection.setFeature("conjunction", (Object)"");
                        this.objCollection.addCoordinate((Object)this.subject);
                        continue;
                    }
                    this.previousSubject = firstSubjectRealised.toString();
                    this.objCollection.addCoordinate((Object)this.subject);
                    this.objCollection.setFeature("conjunction", (Object)"");
                    continue;
                }
                this.fullMeasureNLG(linkSpecification);
            }
        }
        return this.result;
    }

    public NPPhraseSpec subject(CoordinatedPhraseElement coordinate, String leftProp, String rightProp) {
        Realiser clause22Realiser = new Realiser(this.lexicon);
        String p = leftProp + " von der Datenquelle und dem Datenziel Ressourcen";
        if (rightProp.equals(leftProp)) {
            NPPhraseSpec subject1 = this.nlgFactory.createNounPhrase((Object)p);
            subject1.setFeature("number", (Object)NumberAgreement.SINGULAR);
            return subject1;
        }
        NLGElement differentResource = clause22Realiser.realise((NLGElement)coordinate);
        NPPhraseSpec subject2 = this.nlgFactory.createNounPhrase((Object)differentResource.toString());
        subject2.setFeature("number", (Object)NumberAgreement.PLURAL);
        return subject2;
    }
}

