/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.ls.nlg;

import java.util.LinkedHashMap;
import java.util.Map;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.ls.nlg.ILSVerbalizer;
import org.aksw.limes.core.io.ls.nlg.de.LSVerbalizerDE;
import org.aksw.limes.core.io.ls.nlg.en.LSVerbalizerEN;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSVerbalization {
    private static Logger logger = LoggerFactory.getLogger((String)LSVerbalization.class.getName());

    public static Map<String, String> getLSVerbalizationByLanguage(String explainLSConfigString, LinkSpecification linkSpec) {
        explainLSConfigString = explainLSConfigString.replaceAll(" ", "");
        String[] split = explainLSConfigString.split(",");
        LinkedHashMap<String, String> languageToVerbalizationMap = new LinkedHashMap<String, String>();
        String[] stringArray = split;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            ILSVerbalizer verbalizer;
            String language;
            switch (language = stringArray[i]) {
                case "None": {
                    verbalizer = null;
                    break;
                }
                case "English": {
                    verbalizer = new LSVerbalizerEN();
                    break;
                }
                case "German": {
                    verbalizer = new LSVerbalizerDE();
                    break;
                }
                default: {
                    verbalizer = linkSpecification -> "Error: Language not implemented";
                }
            }
            if (verbalizer == null) continue;
            String verbalized = verbalizer.verbalize(linkSpec);
            logger.info("LS-Verbalization-" + language + " : " + verbalized);
            languageToVerbalizationMap.put(language, verbalized);
        }
        return languageToVerbalizationMap;
    }
}

