/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config.reader.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.aksw.limes.core.evaluation.evaluationDataLoader.PropMapper;
import org.aksw.limes.core.io.config.Configuration;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.config.reader.AConfigurationReader;
import org.aksw.limes.core.io.config.reader.xml.DtdChecker;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.ml.algorithm.MLAlgorithmFactory;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLConfigurationReader
extends AConfigurationReader {
    private static final Logger logger = LoggerFactory.getLogger(XMLConfigurationReader.class);
    protected static final String FILE = "FILE";
    protected static final String GRANULARITY = "GRANULARITY";
    protected static final String TARGET = "TARGET";
    protected static final String LABEL = "LABEL";
    protected static final String RELATION = "RELATION";
    protected static final String THRESHOLD = "THRESHOLD";
    protected static final String REVIEW = "REVIEW";
    protected static final String ACCEPTANCE = "ACCEPTANCE";
    protected static final String EXECUTION = "EXECUTION";
    protected static final String OUTPUT = "OUTPUT";
    protected static final String TYPE = "TYPE";
    protected static final String VAR = "VAR";
    protected static final String ID = "ID";
    protected static final String SOURCE = "SOURCE";
    protected static final String PREFIX = "PREFIX";
    protected static final String PAGESIZE = "PAGESIZE";
    protected static final String ENDPOINT = "ENDPOINT";
    protected static final String GRAPH = "GRAPH";
    protected static final String RESTRICTION = "RESTRICTION";
    protected static final String PROPERTY = "PROPERTY";
    protected static final String OPTIONAL_PROPERTY = "OPTIONAL_PROPERTY";
    protected static final String AS = " AS ";
    protected static final String RENAME = " RENAME ";
    protected static final String METRIC = "METRIC";
    protected static final String EXPLAIN_LS = "EXPLAIN_LS";
    protected static final String NAMESPACE = "NAMESPACE";
    protected static final String REWRITER = "REWRITER";
    protected static final String PLANNER = "PLANNER";
    protected static final String ENGINE = "ENGINE";
    protected static final String MLALGORITHM = "MLALGORITHM";
    protected static final String NAME = "NAME";
    protected static final String TRAINING = "TRAINING";
    protected static final String VALUE = "VALUE";
    protected static final String PARAMETER = "PARAMETER";
    protected static final String MAXOFFSET = "MAXOFFSET";
    protected static final String MINOFFSET = "MINOFFSET";
    protected static final String FUNCTION = "FUNCTION";
    protected static final String OPTIMIZATION_TIME = "OPTIMIZATION_TIME";
    protected static final String EXPECTED_SELECTIVITY = "EXPECTED_SELECTIVITY";

    public XMLConfigurationReader(String xmlFile) {
        super(xmlFile);
    }

    public static void processProperty(KBInfo kbinfo, String property) {
        String function = "";
        String propertyLabel = "";
        String propertyRename = "";
        if (!property.contains(RENAME) && !property.contains(AS)) {
            propertyLabel = property;
            propertyRename = property;
        } else if (!property.contains(RENAME) && property.contains(AS)) {
            propertyRename = propertyLabel = property.substring(0, property.indexOf(AS));
            function = property.substring(property.indexOf(AS) + AS.length(), property.length());
        } else if (!property.contains(AS) && property.contains(RENAME)) {
            propertyLabel = property.substring(0, property.indexOf(RENAME));
            propertyRename = property.substring(property.indexOf(RENAME) + RENAME.length(), property.length());
            function = null;
        } else {
            propertyLabel = property.substring(0, property.indexOf(AS));
            function = property.substring(property.indexOf(AS) + AS.length(), property.indexOf(RENAME));
            propertyRename = property.substring(property.indexOf(RENAME) + RENAME.length(), property.length());
        }
        if (!kbinfo.getFunctions().containsKey(propertyLabel)) {
            kbinfo.getFunctions().put(propertyLabel, new HashMap());
        }
        kbinfo.getFunctions().get(propertyLabel).put(propertyRename, function);
        if (!kbinfo.getProperties().contains(propertyLabel)) {
            kbinfo.getProperties().add(propertyLabel);
        }
    }

    public static void processOptionalProperty(KBInfo kbinfo, String property) {
        String function = "";
        String propertyLabel = "";
        String propertyRename = "";
        if (!property.contains(RENAME) && !property.contains(AS)) {
            propertyLabel = property;
            propertyRename = property;
        } else if (!property.contains(RENAME) && property.contains(AS)) {
            propertyRename = propertyLabel = property.substring(0, property.indexOf(AS));
            function = property.substring(property.indexOf(AS) + AS.length(), property.length());
        } else if (!property.contains(AS) && property.contains(RENAME)) {
            propertyLabel = property.substring(0, property.indexOf(RENAME));
            propertyRename = property.substring(property.indexOf(RENAME) + RENAME.length(), property.length());
            function = null;
        } else {
            propertyLabel = property.substring(0, property.indexOf(AS));
            function = property.substring(property.indexOf(AS) + AS.length(), property.indexOf(RENAME));
            propertyRename = property.substring(property.indexOf(RENAME) + RENAME.length(), property.length());
        }
        if (!kbinfo.getFunctions().containsKey(propertyLabel)) {
            kbinfo.getFunctions().put(propertyLabel, new HashMap());
        }
        kbinfo.getFunctions().get(propertyLabel).put(propertyRename, function);
        if (!kbinfo.getOptionalProperties().contains(propertyLabel)) {
            kbinfo.getOptionalProperties().add(propertyLabel);
        }
    }

    public static String getText(Node node) {
        short type = node.getNodeType();
        if (type == 8 || type == 7) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        String value = node.getNodeValue();
        if (value != null) {
            text.append(value);
        }
        if (node.hasChildNodes()) {
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                text.append(XMLConfigurationReader.getText(child));
            }
        }
        return text.toString();
    }

    @Override
    public Configuration read() {
        try {
            File f = new File(this.fileNameOrUri);
            FileInputStream input = new FileInputStream(f);
            return this.validateAndRead(input, this.fileNameOrUri);
        }
        catch (FileNotFoundException e) {
            logger.warn(e.getMessage());
            e.printStackTrace();
            logger.warn("Some values were not set. Crossing my fingers and using defaults.");
            return this.configuration;
        }
    }

    public void afterPropertiesSet(Configuration configuration) {
        configuration.getSourceInfo().afterPropertiesSet();
        configuration.getTargetInfo().afterPropertiesSet();
        configuration.getSourceInfo().setPrefixes(configuration.getPrefixes());
        configuration.getTargetInfo().setPrefixes(configuration.getPrefixes());
    }

    public void processKBDescription(String kb, NodeList children) {
        boolean partialSource;
        KBInfo kbinfo = kb.equalsIgnoreCase("source") ? this.configuration.getSourceInfo() : this.configuration.getTargetInfo();
        for (int i = 0; i < children.getLength(); ++i) {
            String property;
            Node child = children.item(i);
            if (child.getNodeName().equals(ID)) {
                kbinfo.setId(XMLConfigurationReader.getText(child));
                continue;
            }
            if (child.getNodeName().equals(ENDPOINT)) {
                kbinfo.setEndpoint(XMLConfigurationReader.getText(child));
                continue;
            }
            if (child.getNodeName().equals(GRAPH)) {
                kbinfo.setGraph(XMLConfigurationReader.getText(child));
                continue;
            }
            if (child.getNodeName().equals(MAXOFFSET)) {
                kbinfo.setMaxOffset(Integer.parseInt(XMLConfigurationReader.getText(child)));
                continue;
            }
            if (child.getNodeName().equals(MINOFFSET)) {
                kbinfo.setMinOffset(Integer.parseInt(XMLConfigurationReader.getText(child)));
                continue;
            }
            if (child.getNodeName().equals(RESTRICTION)) {
                String restriction = XMLConfigurationReader.getText(child).trim();
                if (restriction.endsWith(".")) {
                    restriction = restriction.substring(0, restriction.length() - 1);
                }
                kbinfo.addRestriction(restriction);
                continue;
            }
            if (child.getNodeName().equals(PROPERTY)) {
                property = XMLConfigurationReader.getText(child);
                XMLConfigurationReader.processProperty(kbinfo, property);
                continue;
            }
            if (child.getNodeName().equals(OPTIONAL_PROPERTY)) {
                property = XMLConfigurationReader.getText(child);
                XMLConfigurationReader.processOptionalProperty(kbinfo, property);
                continue;
            }
            if (child.getNodeName().equals(PAGESIZE)) {
                kbinfo.setPageSize(Integer.parseInt(XMLConfigurationReader.getText(child)));
                continue;
            }
            if (child.getNodeName().equals(VAR)) {
                kbinfo.setVar(XMLConfigurationReader.getText(child));
                continue;
            }
            if (child.getNodeName().equals(TYPE)) {
                kbinfo.setType(XMLConfigurationReader.getText(child));
                continue;
            }
            if (!child.getNodeName().equals(FUNCTION)) continue;
            XMLConfigurationReader.setComplexFunction(kbinfo, XMLConfigurationReader.getText(child));
        }
        KBInfo targetInfo = this.configuration.getTargetInfo();
        KBInfo sourceInfo = this.configuration.getSourceInfo();
        boolean partialTarget = targetInfo.getMinOffset() > 0 || targetInfo.getMaxOffset() > 0;
        boolean bl = partialSource = sourceInfo.getMinOffset() > 0 || sourceInfo.getMaxOffset() > 0;
        if (partialTarget && partialSource) {
            logger.warn("Looks like you requested only subsets from BOTH endpoints!");
        }
        if (kbinfo.getMinOffset() > 0 && kbinfo.getMaxOffset() > 0 && kbinfo.getMinOffset() > kbinfo.getMaxOffset()) {
            logger.error(kb + " query limit missmatch: MINOFFSET > MAXOFFSET");
            throw new RuntimeException();
        }
        kbinfo.setPrefixes(this.configuration.getPrefixes());
    }

    public static void setComplexFunction(KBInfo info, String function) {
        String newPropertyName;
        if (!function.contains(RENAME)) {
            logger.warn("You did not provide a new property name for your function \"" + function + "\" we will use the function name as new property name\n You can provide a new property name using the  RENAME  keyword");
            newPropertyName = function;
        } else {
            String[] funcArr = function.split(RENAME);
            function = funcArr[0];
            newPropertyName = funcArr[1];
        }
        HashMap<String, String> funcMap = new HashMap<String, String>();
        funcMap.put(newPropertyName, function);
        LinkedHashMap<String, Map<String, String>> functions = info.getFunctions();
        functions.put(newPropertyName, funcMap);
    }

    public Configuration validateAndRead(InputStream input, String filePath) {
        DtdChecker dtdChecker = new DtdChecker();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(dtdChecker);
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                    if (systemId.contains("limes.dtd")) {
                        String dtd = this.getClass().getResource("/limes.dtd").toString();
                        return new InputSource(dtd);
                    }
                    return null;
                }
            });
            Document xmlDocument = builder.parse(input);
            if (dtdChecker.valid) {
                String file;
                Node child;
                int j;
                NodeList children;
                int i;
                NodeList list = xmlDocument.getElementsByTagName(PREFIX);
                String namespace = "";
                String label = "";
                for (i = 0; i < list.getLength(); ++i) {
                    children = list.item(i).getChildNodes();
                    for (j = 0; j < children.getLength(); ++j) {
                        child = children.item(j);
                        if (child.getNodeName().equals(NAMESPACE)) {
                            namespace = XMLConfigurationReader.getText(child);
                            continue;
                        }
                        if (!child.getNodeName().equals(LABEL)) continue;
                        label = XMLConfigurationReader.getText(child);
                    }
                    this.configuration.addPrefix(label, namespace);
                }
                list = xmlDocument.getElementsByTagName(SOURCE);
                children = list.item(0).getChildNodes();
                this.processKBDescription(SOURCE, children);
                list = xmlDocument.getElementsByTagName(TARGET);
                children = list.item(0).getChildNodes();
                this.processKBDescription(TARGET, children);
                list = xmlDocument.getElementsByTagName(EXPLAIN_LS);
                if (list.getLength() > 0) {
                    String explainLs = XMLConfigurationReader.getText(list.item(0));
                    this.configuration.setExplainLS(explainLs);
                }
                if ((list = xmlDocument.getElementsByTagName(METRIC)).getLength() > 0) {
                    this.configuration.setMetricExpression(XMLConfigurationReader.getText(list.item(0)));
                } else {
                    list = xmlDocument.getElementsByTagName(MLALGORITHM);
                    if (list.getLength() > 0) {
                        for (i = 0; i < list.getLength(); ++i) {
                            children = list.item(i).getChildNodes();
                            for (j = 0; j < children.getLength(); ++j) {
                                child = children.item(j);
                                if (child.getNodeName().equals(NAME)) {
                                    this.configuration.setMlAlgorithmName(XMLConfigurationReader.getText(child));
                                    continue;
                                }
                                if (child.getNodeName().equals(TYPE)) {
                                    this.configuration.setMlImplementationType(MLAlgorithmFactory.getImplementationType(XMLConfigurationReader.getText(child)));
                                    continue;
                                }
                                if (child.getNodeName().equals(TRAINING)) {
                                    this.configuration.setMlTrainingDataFile(XMLConfigurationReader.getText(child));
                                    continue;
                                }
                                if (!child.getNodeName().equals(PARAMETER)) continue;
                                Element e = (Element)child;
                                String mlParameterName = XMLConfigurationReader.getText(e.getElementsByTagName(NAME).item(0).getChildNodes().item(0));
                                if (mlParameterName.equalsIgnoreCase("property mapping")) {
                                    String propMapFile = XMLConfigurationReader.getText(e.getElementsByTagName(VALUE).item(0).getChildNodes().item(0));
                                    PropertyMapping propertyMapping = PropMapper.getPropertyMappingFromFile(propMapFile);
                                    this.configuration.addMlAlgorithmParameter(mlParameterName.toLowerCase(), propertyMapping);
                                    continue;
                                }
                                String mlParameterValue = XMLConfigurationReader.getText(e.getElementsByTagName(VALUE).item(0).getChildNodes().item(0));
                                this.configuration.addMlAlgorithmParameter(mlParameterName, mlParameterValue);
                            }
                        }
                    } else {
                        logger.error("Niether METRIC nor MLALGORITHM is provided, exit with error");
                        throw new RuntimeException();
                    }
                }
                list = xmlDocument.getElementsByTagName(ACCEPTANCE);
                children = list.item(0).getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node child2 = children.item(i);
                    if (child2.getNodeName().equals(THRESHOLD)) {
                        this.configuration.setAcceptanceThreshold(Double.parseDouble(XMLConfigurationReader.getText(child2)));
                        continue;
                    }
                    if (child2.getNodeName().equals(FILE)) {
                        file = XMLConfigurationReader.getText(child2);
                        this.configuration.setAcceptanceFile(file);
                        continue;
                    }
                    if (!child2.getNodeName().equals(RELATION)) continue;
                    this.configuration.setAcceptanceRelation(XMLConfigurationReader.getText(child2));
                }
                list = xmlDocument.getElementsByTagName(REVIEW);
                children = list.item(0).getChildNodes();
                for (i = 0; i < children.getLength(); ++i) {
                    Node child3 = children.item(i);
                    if (child3.getNodeName().equals(THRESHOLD)) {
                        this.configuration.setVerificationThreshold(Double.parseDouble(XMLConfigurationReader.getText(child3)));
                        continue;
                    }
                    if (child3.getNodeName().equals(FILE)) {
                        file = XMLConfigurationReader.getText(child3);
                        this.configuration.setVerificationFile(file);
                        continue;
                    }
                    if (!child3.getNodeName().equals(RELATION)) continue;
                    this.configuration.setVerificationRelation(XMLConfigurationReader.getText(child3));
                }
                if (list.getLength() > 0) {
                    list = xmlDocument.getElementsByTagName(EXECUTION);
                    for (i = 0; i < list.getLength(); ++i) {
                        children = list.item(i).getChildNodes();
                        for (int j2 = 0; j2 < children.getLength(); ++j2) {
                            child = children.item(j2);
                            if (child.getNodeName().equals(REWRITER)) {
                                this.configuration.setExecutionRewriter(XMLConfigurationReader.getText(child));
                                continue;
                            }
                            if (child.getNodeName().equals(PLANNER)) {
                                this.configuration.setExecutionPlanner(XMLConfigurationReader.getText(child));
                                continue;
                            }
                            if (child.getNodeName().equals(ENGINE)) {
                                this.configuration.setExecutionEngine(XMLConfigurationReader.getText(child));
                                continue;
                            }
                            if (child.getNodeName().equals(OPTIMIZATION_TIME)) {
                                long maxOpt = Long.parseLong(XMLConfigurationReader.getText(child));
                                if (maxOpt < 0L) {
                                    logger.info("\nIgnore this message if you chose the default or simple execution engine:\nOptimization time cannot be negative. Your input value is " + maxOpt + ".\nSetting it to the default value: 0ms.\n--End of message--");
                                    this.configuration.setOptimizationTime(0L);
                                    continue;
                                }
                                this.configuration.setOptimizationTime(maxOpt);
                                continue;
                            }
                            if (!child.getNodeName().equals(EXPECTED_SELECTIVITY)) continue;
                            double k = Double.parseDouble(XMLConfigurationReader.getText(child));
                            if (k < 0.0 || k > 1.0) {
                                logger.info("\nIgnore this message if you chose the default or simple execution engine:\nExpected selectivity must be between 0.0 and 1.0. Your input value is " + k + ".\nSetting it to the default value: 1.0.\n--End of message--");
                                this.configuration.setExpectedSelectivity(1.0);
                                continue;
                            }
                            this.configuration.setExpectedSelectivity(k);
                        }
                    }
                }
                if ((list = xmlDocument.getElementsByTagName(GRANULARITY)).getLength() > 0) {
                    children = list.item(0).getChildNodes();
                    this.configuration.setGranularity(Integer.parseInt(XMLConfigurationReader.getText(list.item(0))));
                }
                if ((list = xmlDocument.getElementsByTagName(OUTPUT)).getLength() > 0) {
                    children = list.item(0).getChildNodes();
                    this.configuration.setOutputFormat(XMLConfigurationReader.getText(list.item(0)));
                }
                if (this.configuration.getSourceInfo() != null) {
                    XMLConfigurationReader.replaceURIsWithPrefixes(this.configuration.getSourceInfo());
                }
                if (this.configuration.getTargetInfo() != null) {
                    XMLConfigurationReader.replaceURIsWithPrefixes(this.configuration.getTargetInfo());
                }
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            e.printStackTrace();
            logger.warn("Some values were not set. Crossing my fingers and using defaults.");
        }
        return this.configuration;
    }

    public void modifyMetricExpression(LinkSpecification spec) {
        for (LinkSpecification atomicSpec : spec.getAllLeaves()) {
            String metricExpr;
            String m = atomicSpec.getFilterExpression();
            logger.info(m);
            Pattern p = Pattern.compile(Pattern.quote(m) + "\\|\\d*\\.\\d+");
            Matcher mac = p.matcher(metricExpr = this.configuration.getMetricExpression());
            if (!mac.find()) continue;
            int start = mac.start();
            int end = mac.end();
            String subStr = metricExpr.substring(start, end);
            String[] arr = subStr.split("\\|");
            this.configuration.setMetricExpression(metricExpr.replace(subStr, arr[0] + "|" + Double.toString(atomicSpec.getThreshold())));
        }
    }
}

