/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.plan;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.measures.measure.MeasureProcessor;

public class NestedPlan
extends Plan {
    private List<NestedPlan> subPlans = null;
    private Instruction.Command operator;
    private Instruction filteringInstruction = null;
    private boolean executionStatus = false;

    public List<NestedPlan> getSubPlans() {
        return this.subPlans;
    }

    public void setSubPlans(List<NestedPlan> subPlans) {
        this.subPlans = subPlans;
    }

    public Instruction.Command getOperator() {
        return this.operator;
    }

    public void setOperator(Instruction.Command operator) {
        this.operator = operator;
    }

    public Instruction getFilteringInstruction() {
        return this.filteringInstruction;
    }

    public void setFilteringInstruction(Instruction filteringInstruction) {
        this.filteringInstruction = filteringInstruction;
    }

    public boolean getExecutionStatus() {
        return this.executionStatus;
    }

    public void setExecutionStatus(boolean executionStatus) {
        this.executionStatus = executionStatus;
    }

    @Override
    public boolean isEmpty() {
        return this.instructionList.isEmpty() && this.subPlans == null && this.filteringInstruction == null;
    }

    public boolean isAtomic() {
        if (this.subPlans == null) {
            return true;
        }
        return this.subPlans.isEmpty();
    }

    @Override
    public List<Instruction> getInstructionList() {
        ArrayList<Instruction> instructions = new ArrayList<Instruction>();
        for (Instruction inst : this.instructionList) {
            instructions.add(inst);
        }
        if (!this.isAtomic()) {
            for (NestedPlan np : this.subPlans) {
                List<Instruction> instructions2 = np.getInstructionList();
                for (Instruction inst2 : instructions2) {
                    instructions.add(inst2);
                }
            }
        }
        return instructions;
    }

    @Override
    public int size() {
        return this.getInstructionList().size();
    }

    @Override
    public NestedPlan clone() {
        NestedPlan clone = new NestedPlan();
        clone.setMappingSize(this.mappingSize);
        clone.setRuntimeCost(this.runtimeCost);
        clone.setSelectivity(this.selectivity);
        clone.setOperator(this.operator);
        if (this.instructionList != null) {
            if (!this.instructionList.isEmpty()) {
                ArrayList<Instruction> cloneInstructionList = new ArrayList<Instruction>();
                for (Instruction i : this.instructionList) {
                    cloneInstructionList.add(i.clone());
                }
                clone.setInstructionList(cloneInstructionList);
            } else {
                clone.setInstructionList(new ArrayList<Instruction>());
            }
        } else {
            clone.setInstructionList(null);
        }
        if (this.filteringInstruction != null) {
            Instruction cloneFilteringInstruction = this.filteringInstruction.clone();
            clone.setFilteringInstruction(cloneFilteringInstruction);
        } else {
            clone.setFilteringInstruction(null);
        }
        if (this.subPlans != null) {
            if (!this.subPlans.isEmpty()) {
                for (NestedPlan c : this.subPlans) {
                    NestedPlan subPlanCopy = c.clone();
                    clone.addSubplan(subPlanCopy);
                }
            } else {
                clone.setSubPlans(new ArrayList<NestedPlan>());
            }
        }
        return clone;
    }

    public void addSubplan(NestedPlan subplan) {
        if (subplan != null) {
            if (this.subPlans == null) {
                this.setSubPlans(new ArrayList<NestedPlan>());
            }
            this.subPlans.add(subplan);
        }
    }

    public List<String> getAllMeasures() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isAtomic() && this.filteringInstruction != null) {
            result.addAll(MeasureProcessor.getMeasures(this.filteringInstruction.getMeasureExpression()));
        }
        if (this.subPlans != null && !this.subPlans.isEmpty()) {
            for (NestedPlan p : this.subPlans) {
                result.addAll(p.getAllMeasures());
            }
        }
        if (this.instructionList != null) {
            for (Instruction i : this.instructionList) {
                if (i.getMeasureExpression() == null) continue;
                result.addAll(MeasureProcessor.getMeasures(i.getMeasureExpression()));
            }
        }
        return result;
    }

    public String toString() {
        String str = "Selectivity = " + this.selectivity;
        if (this.isEmpty()) {
            return "Empty plan";
        }
        if (!this.instructionList.isEmpty()) {
            if (this.filteringInstruction != null) {
                if (this.subPlans != null) {
                    if (!this.subPlans.isEmpty()) {
                        return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\n-----\n" + this.instructionList + "\n" + this.operator + "\nSubplans\n\n" + this.subPlans + "\nEND\n-----";
                    }
                    return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\n-----\n" + this.instructionList + "\nEND\n-----";
                }
                return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\n-----\n" + this.instructionList + "\nEND\n-----";
            }
            if (this.subPlans != null) {
                if (!this.subPlans.isEmpty()) {
                    return "\nBEGIN\n" + str + "-----\n" + this.instructionList + "\n" + this.operator + "\nSubplans\n" + this.subPlans + "\nEND\n-----";
                }
                return "\nBEGIN\n" + str + "-----\n" + this.instructionList + "\nEND\n-----";
            }
            return "\nBEGIN\n" + str + "-----\n" + this.instructionList + "\nEND\n-----";
        }
        if (this.filteringInstruction != null) {
            if (this.subPlans != null) {
                if (!this.subPlans.isEmpty()) {
                    return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\n-----\n" + this.operator + "\nSubplans\n\n" + this.subPlans + "\nEND\n-----";
                }
                return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\nEND\n-----";
            }
            return "\nBEGIN\n" + str + "-----\n" + this.filteringInstruction + "\nEND\n-----";
        }
        if (this.subPlans != null && !this.subPlans.isEmpty()) {
            return "\nBEGIN\n" + str + "-----\n" + this.operator + "\nSubplans\n\n" + this.subPlans + "\nEND\n-----";
        }
        return str;
    }

    public String getThreshold() {
        if (this.filteringInstruction != null) {
            return this.filteringInstruction.getThreshold();
        }
        return "0";
    }

    public String finalPlan() {
        if (this.isEmpty()) {
            return "Empty plan";
        }
        if (this.isAtomic()) {
            return ((Instruction)this.instructionList.get(0)).getMeasureExpression() + "-" + ((Instruction)this.instructionList.get(0)).getThreshold();
        }
        if (this.operator == null) {
            String child = this.subPlans.get(0).finalPlan();
            Object filter = "";
            filter = this.filteringInstruction.getCommand().equals((Object)Instruction.Command.FILTER) ? "FILTER:" + this.filteringInstruction.getMeasureExpression() + "-" + this.filteringInstruction.getThreshold() : "REVERSEFILTER:" + this.filteringInstruction.getMeasureExpression() + "-" + this.filteringInstruction.getThreshold();
            String mainFilter = "FILTER:" + this.filteringInstruction.getMainThreshold();
            if (this.subPlans.get(0).isAtomic()) {
                return "RUN:" + child + "\n" + (String)filter + "\n" + mainFilter + "\n";
            }
            return child + "\n" + (String)filter + "\n" + mainFilter + "\n";
        }
        String childLeft = this.subPlans.get(0).finalPlan();
        String childRight = this.subPlans.get(1).finalPlan();
        String op = "";
        if (this.operator.equals((Object)Instruction.Command.DIFF)) {
            op = "DIFFERENCE";
        } else if (this.operator.equals((Object)Instruction.Command.INTERSECTION)) {
            op = "INTERSECTION";
        } else if (this.operator.equals((Object)Instruction.Command.UNION)) {
            op = "UNION";
        } else if (this.operator.equals((Object)Instruction.Command.XOR)) {
            op = "XOR";
        }
        String filter = "FILTER:" + this.filteringInstruction.getThreshold();
        if (this.subPlans.get(0).isAtomic() && this.subPlans.get(1).isAtomic()) {
            return "RUN:" + childLeft + "\nRUN:" + childRight + "\n" + op + "\n" + filter + "\n";
        }
        if (this.subPlans.get(0).isAtomic() && !this.subPlans.get(1).isAtomic()) {
            return "RUN:" + childLeft + "\n" + childRight + "\n" + op + "\n" + filter + "\n";
        }
        if (!this.subPlans.get(0).isAtomic() && this.subPlans.get(1).isAtomic()) {
            return childLeft + "\nRUN:" + childRight + "\n" + op + "\n" + filter + "\n";
        }
        if (!this.subPlans.get(0).isAtomic() && !this.subPlans.get(1).isAtomic()) {
            return childLeft + "\n" + childRight + "\n" + op + "\n" + filter + "\n";
        }
        return null;
    }

    @Override
    public boolean equals(Object other) {
        NestedPlan o = (NestedPlan)other;
        if (o == null) {
            return false;
        }
        if (this.isAtomic() && o.isAtomic()) {
            return this.instructionList.equals(o.instructionList);
        }
        if (!this.isAtomic() && !o.isAtomic()) {
            if (this.operator == null && o.operator != null) {
                return false;
            }
            if (this.operator != null && o.operator == null) {
                return false;
            }
            if (this.operator == null && o.operator == null) {
                if (this.filteringInstruction == null && o.filteringInstruction == null) {
                    if (this.instructionList.equals(o.instructionList)) {
                        return this.subPlans.equals(o.subPlans);
                    }
                    return false;
                }
                if (this.filteringInstruction != null && o.filteringInstruction == null) {
                    return false;
                }
                if (this.filteringInstruction == null && o.filteringInstruction != null) {
                    return false;
                }
                if (this.filteringInstruction.equals(o.filteringInstruction)) {
                    if (this.instructionList.equals(o.instructionList)) {
                        return this.subPlans.equals(o.subPlans);
                    }
                    return false;
                }
                return false;
            }
            if (this.operator.equals((Object)o.operator)) {
                if (this.filteringInstruction == null && o.filteringInstruction == null) {
                    if (this.instructionList.equals(o.instructionList)) {
                        return this.subPlans.equals(o.subPlans);
                    }
                    return false;
                }
                if (this.filteringInstruction != null && o.filteringInstruction == null) {
                    return false;
                }
                if (this.filteringInstruction == null && o.filteringInstruction != null) {
                    return false;
                }
                if (this.filteringInstruction.equals(o.filteringInstruction)) {
                    if (this.instructionList.equals(o.instructionList)) {
                        return this.subPlans.equals(o.subPlans);
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }
}

