/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.evaluator;

import de.vandermeer.asciitable.AT_Cell;
import de.vandermeer.asciitable.AT_Row;
import de.vandermeer.asciitable.AsciiTable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.aksw.limes.core.datastrutures.EvaluationRun;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.evaluation.quantitativeMeasures.RunRecord;
import org.apache.commons.math3.util.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Summary {
    public static final Logger logger = LoggerFactory.getLogger(Summary.class);
    private List<EvaluationRun> singleRuns;
    private List<EvaluationRun> averagedRuns;
    private Map<String, Map<String, Map<String, Double>>> statisticalTestResults;
    private List<String> usedDatasets = new ArrayList<String>();
    private List<String> usedAlgorithms = new ArrayList<String>();
    private List<String> usedEvaluators = new ArrayList<String>();
    public static final int PRECISION = 2;
    public static final String MEMORY = "MEM";
    public static final String TIME = "TIME";
    public static final String LS_SIZE = "LS_SIZE";

    public Summary(List<EvaluationRun> singleRuns, int runsPerDataSet) {
        this.singleRuns = singleRuns;
        this.averagedRuns = this.calculateAvgRuns(runsPerDataSet);
    }

    public List<EvaluationRun> calculateAvgRuns(int runsPerDataSet) {
        HashMap<String, Map> algoDataRunMap = new HashMap<String, Map>();
        for (EvaluationRun e : this.singleRuns) {
            String algo2 = e.getAlgorithmName();
            String dataSet = e.getDatasetName();
            if (!algoDataRunMap.containsKey(algo2)) {
                HashMap dataRunMap = new HashMap();
                algoDataRunMap.put(algo2, dataRunMap);
            }
            Object eRun = (EvaluationRun)((Map)algoDataRunMap.get(algo2)).get(dataSet);
            Map dataRunMap = (Map)algoDataRunMap.get(algo2);
            if (eRun != null) {
                for (EvaluatorType measureType : e.qualititativeScores.keySet()) {
                    ((EvaluationRun)eRun).qualititativeScores.put(measureType, ((EvaluationRun)eRun).qualititativeScores.get((Object)measureType) + e.qualititativeScores.get((Object)measureType));
                    if (this.usedEvaluators.contains(measureType.toString())) continue;
                    this.usedEvaluators.add(measureType.toString());
                }
                if (((EvaluationRun)eRun).getQuanititativeRecord() != null) {
                    RunRecord rr = ((EvaluationRun)eRun).getQuanititativeRecord();
                    if (rr.getRunMemory() != 0.0) {
                        rr.setRunMemory(rr.getRunMemory() + e.getQuanititativeRecord().getRunMemory());
                    }
                    if (rr.getRunTime() != 0.0) {
                        rr.setRunTime(rr.getRunTime() + e.getQuanititativeRecord().getRunTime());
                    }
                    if (rr.getLinkSpecSize() != 0.0) {
                        rr.setLinkSpecSize(rr.getLinkSpecSize() + e.getQuanititativeRecord().getLinkSpecSize());
                    }
                    ((EvaluationRun)eRun).setQuanititativeRecord(rr);
                }
            } else {
                eRun = e.clone();
            }
            dataRunMap.put(dataSet, eRun);
            algoDataRunMap.put(algo2, dataRunMap);
            if (!this.usedDatasets.contains(dataSet)) {
                this.usedDatasets.add(dataSet);
            }
            if (this.usedAlgorithms.contains(algo2)) continue;
            this.usedAlgorithms.add(algo2);
        }
        algoDataRunMap.forEach((algo, map) -> map.forEach((data, eRun) -> {
            for (EvaluatorType measureType : eRun.qualititativeScores.keySet()) {
                eRun.qualititativeScores.put(measureType, eRun.qualititativeScores.get((Object)measureType) / (double)runsPerDataSet);
            }
            if (eRun.getQuanititativeRecord() != null) {
                RunRecord rr = eRun.getQuanititativeRecord();
                if (rr.getRunMemory() != 0.0) {
                    rr.setRunMemory(rr.getRunMemory() / (double)runsPerDataSet);
                }
                if (rr.getRunTime() != 0.0) {
                    rr.setRunTime(rr.getRunTime() / (double)runsPerDataSet);
                }
                if (rr.getLinkSpecSize() != 0.0) {
                    rr.setLinkSpecSize(rr.getLinkSpecSize() / (double)runsPerDataSet);
                }
                eRun.setQuanititativeRecord(rr);
            }
        }));
        ArrayList<EvaluationRun> result = new ArrayList<EvaluationRun>();
        for (EvaluationRun e : this.singleRuns) {
            EvaluationRun averagedRun = (EvaluationRun)((Map)algoDataRunMap.get(e.getAlgorithmName())).get(e.getDatasetName());
            for (EvaluatorType eType : e.qualititativeScores.keySet()) {
                double squaredDifference = Math.pow(e.qualititativeScores.get((Object)eType) - averagedRun.qualititativeScores.get((Object)eType), 2.0);
                if (averagedRun.qualititativeScoresWithVariance.get((Object)eType) != null) {
                    Pair<Double, Double> valueVariance = averagedRun.qualititativeScoresWithVariance.get((Object)eType);
                    averagedRun.qualititativeScoresWithVariance.put(eType, (Pair<Double, Double>)new Pair((Object)((Double)valueVariance.getFirst()), (Object)(squaredDifference + (Double)valueVariance.getSecond())));
                    continue;
                }
                averagedRun.qualititativeScoresWithVariance.put(eType, (Pair<Double, Double>)new Pair((Object)averagedRun.qualititativeScores.get((Object)eType), (Object)squaredDifference));
            }
            if (e.getQuanititativeRecord() == null) continue;
            RunRecord rr = e.getQuanititativeRecord();
            if (rr.getRunMemory() != 0.0) {
                double squaredDifference = Math.pow(rr.getRunMemory() - averagedRun.getQuanititativeRecord().getRunMemory(), 2.0);
                averagedRun.getQuanititativeRecord().setRunMemoryVariance(squaredDifference + averagedRun.getQuanititativeRecord().getRunMemoryVariance());
            }
            if (rr.getRunTime() != 0.0) {
                double squaredDifference = Math.pow(rr.getRunTime() - averagedRun.getQuanititativeRecord().getRunTime(), 2.0);
                averagedRun.getQuanititativeRecord().setRunTimeVariance(squaredDifference + averagedRun.getQuanititativeRecord().getRunTimeVariance());
            }
            if (rr.getLinkSpecSize() == 0.0) continue;
            double squaredDifference = Math.pow(rr.getLinkSpecSize() - averagedRun.getQuanititativeRecord().getLinkSpecSize(), 2.0);
            averagedRun.getQuanititativeRecord().setLinkSpecSizeVariance(squaredDifference + averagedRun.getQuanititativeRecord().getLinkSpecSizeVariance());
        }
        algoDataRunMap.forEach((algo, map) -> map.forEach((data, eRun) -> {
            for (EvaluatorType eType : eRun.qualititativeScores.keySet()) {
                Pair<Double, Double> old = eRun.qualititativeScoresWithVariance.get((Object)eType);
                eRun.qualititativeScoresWithVariance.put(eType, (Pair<Double, Double>)new Pair((Object)((Double)old.getFirst()), (Object)((Double)old.getSecond() / (double)runsPerDataSet)));
            }
            if (eRun.getQuanititativeRecord() != null) {
                RunRecord rr = eRun.getQuanititativeRecord();
                if (rr.getRunMemoryVariance() != 0.0) {
                    rr.setRunMemoryVariance(rr.getRunMemoryVariance() / (double)runsPerDataSet);
                }
                if (rr.getRunTimeVariance() != 0.0) {
                    rr.setRunTimeVariance(rr.getRunTimeVariance() / (double)runsPerDataSet);
                }
                if (rr.getLinkSpecSizeVariance() != 0.0) {
                    rr.setLinkSpecSizeVariance(rr.getLinkSpecSizeVariance() / (double)runsPerDataSet);
                }
                eRun.setQuanititativeRecord(rr);
            }
            result.add((EvaluationRun)eRun);
        }));
        return result;
    }

    public String toString() {
        StringBuilder overall = new StringBuilder();
        overall.append(" ========= QUALITATIVE MEASURES ========\n");
        this.averagedRuns.sort((e1, e2) -> {
            if (e1.getAlgorithmName().equals(e2.getAlgorithmName())) {
                return e1.getDatasetName().compareTo(e2.getDatasetName());
            }
            return e1.getAlgorithmName().compareTo(e2.getAlgorithmName());
        });
        ArrayList<String> datasetsCopy = new ArrayList<String>(this.usedDatasets);
        Collections.sort(datasetsCopy);
        datasetsCopy.add(0, "");
        AsciiTable at = new AsciiTable();
        at.addRule();
        at.addRow(datasetsCopy);
        at.addRule();
        String currentAlgo = this.averagedRuns.get(0).getAlgorithmName();
        ArrayList<String> currentRow = new ArrayList<String>();
        currentRow.add(currentAlgo);
        for (EvaluationRun er : this.averagedRuns) {
            if (!er.getAlgorithmName().equals(currentAlgo)) {
                at.addRow(currentRow);
                at.addRule();
                currentRow = new ArrayList();
                currentRow.add(er.getAlgorithmName());
                currentAlgo = er.getAlgorithmName();
            }
            StringBuilder cell = new StringBuilder();
            for (EvaluatorType eType : er.qualititativeScores.keySet()) {
                Pair<Double, Double> valueVariance = er.qualititativeScoresWithVariance.get((Object)eType);
                cell.append((Object)eType).append(": ").append(this.round((Double)valueVariance.getFirst())).append(" (").append(this.round((Double)valueVariance.getSecond())).append(")").append("\n");
            }
            if (er.getQuanititativeRecord() != null) {
                RunRecord rr = er.getQuanititativeRecord();
                if (rr.getRunMemory() != 0.0) {
                    cell.append("Mem: ").append(this.round(rr.getRunMemory())).append(" (").append(this.round(rr.getRunMemoryVariance())).append(")").append("\n");
                }
                if (rr.getRunTime() != 0.0) {
                    cell.append("Time: ").append(this.round(rr.getRunTime())).append(" (").append(this.round(rr.getRunTimeVariance())).append(")").append("\n");
                }
                if (rr.getLinkSpecSize() != 0.0) {
                    cell.append("LSsize: ").append(this.round(rr.getLinkSpecSize())).append(" (").append(this.round(rr.getLinkSpecSizeVariance())).append(")").append("\n");
                }
            }
            currentRow.add(cell.toString());
        }
        at.addRow(currentRow);
        at.addRule();
        overall.append(at.render());
        if (this.statisticalTestResults == null || this.statisticalTestResults.size() == 0) {
            return overall.toString();
        }
        overall.append("\n ========= STATISTICAL TEST RESULTS ========\n");
        for (String dataSet : this.statisticalTestResults.keySet()) {
            overall.append("\n +++++ " + dataSet + " +++++ \n");
            overall.append(this.statisticalResultsToTable(dataSet, true).render());
        }
        return overall.toString();
    }

    public AsciiTable statisticalResultsToTable(String dataSet, boolean round) {
        AsciiTable at = new AsciiTable();
        at.addRule();
        ArrayList<String> header = new ArrayList<String>();
        header.addAll(this.usedAlgorithms);
        header.set(0, "");
        at.addRow(header);
        at.addRule();
        ArrayList<String> firstColumn = new ArrayList<String>(this.usedAlgorithms);
        firstColumn.remove(firstColumn.size() - 1);
        ArrayList<String> currentRow = new ArrayList<String>();
        for (String a : firstColumn) {
            currentRow.add(a);
            for (String b : header) {
                Double value;
                if (b.equals("")) continue;
                if (this.statisticalTestResults.get(dataSet).get(a) == null) {
                    if (this.statisticalTestResults.get(dataSet).get(b) == null) {
                        currentRow.add("-");
                        continue;
                    }
                    value = this.statisticalTestResults.get(dataSet).get(b).get(a);
                    if (value == null) {
                        currentRow.add("-");
                        continue;
                    }
                    if (round) {
                        currentRow.add(this.round(value));
                        continue;
                    }
                    currentRow.add(value.toString());
                    continue;
                }
                value = this.statisticalTestResults.get(dataSet).get(a).get(b);
                if (value == null) {
                    if (this.statisticalTestResults.get(dataSet).get(b) != null) {
                        value = this.statisticalTestResults.get(dataSet).get(b).get(a);
                        if (value == null) {
                            currentRow.add("-");
                            continue;
                        }
                        if (round) {
                            currentRow.add(this.round(value));
                            continue;
                        }
                        currentRow.add(value.toString());
                        continue;
                    }
                    currentRow.add("-");
                    continue;
                }
                if (round) {
                    currentRow.add(this.round(value));
                    continue;
                }
                currentRow.add(value.toString());
            }
            at.addRow(currentRow);
            currentRow = new ArrayList();
        }
        at.addRule();
        return at;
    }

    public String round(double d) {
        try {
            d = BigDecimal.valueOf(d).round(new MathContext(2, RoundingMode.HALF_UP)).doubleValue();
        }
        catch (NumberFormatException e) {
            System.out.println(d);
            return "NaN";
        }
        DecimalFormat twoDForm = new DecimalFormat("########0." + new String(new char[2]).replace("\u0000", "0"));
        return twoDForm.format(d);
    }

    public void printToFiles(String dir) throws FileNotFoundException {
        Object out;
        Object row;
        Map<Integer, Map<String, Map<String, List<EvaluationRun>>>> grouped = this.singleRuns.stream().collect(Collectors.groupingBy(EvaluationRun::getRunInExperiment, Collectors.groupingBy(EvaluationRun::getAlgorithmName, Collectors.groupingBy(EvaluationRun::getDatasetName))));
        ArrayList<String> evaluations = new ArrayList<String>(this.usedEvaluators);
        if (this.singleRuns.get(0).getQuanititativeRecord().getRunMemory() != 0.0) {
            evaluations.add(MEMORY);
        }
        if (this.singleRuns.get(0).getQuanititativeRecord().getRunTime() != 0.0) {
            evaluations.add(TIME);
        }
        if (this.singleRuns.get(0).getQuanititativeRecord().getLinkSpecSize() != 0.0) {
            evaluations.add(LS_SIZE);
        }
        for (String string : evaluations) {
            for (Integer run : grouped.keySet()) {
                Object runDir = "Run" + run;
                runDir = this.createDirectoriesIfNecessary(dir, (String)runDir);
                String rows = "\t" + String.join((CharSequence)"\t", this.usedDatasets) + "\n";
                for (String algo : this.usedAlgorithms) {
                    row = algo;
                    for (String data : this.usedDatasets) {
                        if (string.equals(MEMORY)) {
                            row = (String)row + "\t" + grouped.get(run).get(algo).get(data).get(0).getQuanititativeRecord().getRunMemory();
                            continue;
                        }
                        if (string.equals(TIME)) {
                            row = (String)row + "\t" + grouped.get(run).get(algo).get(data).get(0).getQuanititativeRecord().getRunTime();
                            continue;
                        }
                        if (string.equals(LS_SIZE)) {
                            row = (String)row + "\t" + grouped.get(run).get(algo).get(data).get(0).getQuanititativeRecord().getLinkSpecSize();
                            continue;
                        }
                        row = (String)row + "\t" + grouped.get((Object)run).get((Object)algo).get((Object)data).get((int)0).qualititativeScores.get((Object)EvaluatorType.valueOf(string));
                    }
                    row = (String)row + "\n";
                    rows = rows + (String)row;
                }
                out = new PrintWriter((String)runDir + File.separatorChar + string);
                try {
                    ((PrintWriter)out).print(rows);
                }
                finally {
                    ((PrintWriter)out).close();
                }
            }
        }
        Map<String, Map<String, List<EvaluationRun>>> groupedAvg = this.averagedRuns.stream().collect(Collectors.groupingBy(EvaluationRun::getAlgorithmName, Collectors.groupingBy(EvaluationRun::getDatasetName)));
        for (String eType : evaluations) {
            String runDir = "Avg";
            runDir = this.createDirectoriesIfNecessary(dir, runDir);
            String rows = "\t" + String.join((CharSequence)"\t", this.usedDatasets) + "\n";
            String rowsVar = "\t" + String.join((CharSequence)"\t", this.usedDatasets) + "\n";
            for (String algo : this.usedAlgorithms) {
                row = algo;
                Object rowVar = algo;
                for (String data : this.usedDatasets) {
                    if (eType.equals(MEMORY)) {
                        row = (String)row + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getRunMemory();
                        rowVar = (String)rowVar + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getRunMemoryVariance();
                        continue;
                    }
                    if (eType.equals(TIME)) {
                        row = (String)row + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getRunTime();
                        rowVar = (String)rowVar + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getRunTimeVariance();
                        continue;
                    }
                    if (eType.equals(LS_SIZE)) {
                        row = (String)row + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getLinkSpecSize();
                        rowVar = (String)rowVar + "\t" + groupedAvg.get(algo).get(data).get(0).getQuanititativeRecord().getLinkSpecSizeVariance();
                        continue;
                    }
                    row = (String)row + "\t" + groupedAvg.get((Object)algo).get((Object)data).get((int)0).qualititativeScores.get((Object)EvaluatorType.valueOf(eType));
                    rowVar = (String)rowVar + "\t" + groupedAvg.get((Object)algo).get((Object)data).get((int)0).qualititativeScoresWithVariance.get((Object)EvaluatorType.valueOf(eType)).getSecond();
                }
                row = (String)row + "\n";
                rowVar = (String)rowVar + "\n";
                rows = rows + (String)row;
                rowsVar = rowsVar + (String)rowVar;
            }
            out = new PrintWriter(runDir + File.separatorChar + eType);
            try {
                ((PrintWriter)out).print(rows);
            }
            finally {
                ((PrintWriter)out).close();
            }
            out = new PrintWriter(runDir + File.separatorChar + eType + "Variance");
            try {
                ((PrintWriter)out).print(rowsVar);
            }
            finally {
                ((PrintWriter)out).close();
            }
        }
        String string = this.createDirectoriesIfNecessary(dir, "statistics");
        for (String dataSet : this.statisticalTestResults.keySet()) {
            AsciiTable at = this.statisticalResultsToTable(dataSet, false);
            System.out.println(at.render());
            Object result = "";
            for (AT_Row row2 : at.getRawContent()) {
                if (row2.getCells() == null) continue;
                for (AT_Cell cell : row2.getCells()) {
                    result = (String)result + cell.getContent().toString() + "\t";
                }
                if (((String)result).endsWith("\t")) {
                    result = ((String)result).substring(0, ((String)result).length() - 1);
                }
                result = (String)result + "\n";
            }
            System.out.println((String)result);
            out = new PrintWriter(string + File.separatorChar + dataSet);
            try {
                ((PrintWriter)out).print((String)result);
            }
            finally {
                ((PrintWriter)out).close();
            }
        }
    }

    private String createDirectoriesIfNecessary(String base, String folder) {
        File f = new File(base + File.separatorChar + folder);
        if (!f.exists()) {
            boolean success = f.mkdirs();
            if (success) {
                logger.info("Successfully created directory: " + f.getPath());
            } else {
                logger.error("Error while trying to create: " + f.getPath());
            }
        }
        return f.getAbsolutePath();
    }

    public List<EvaluationRun> getSingleRuns() {
        return this.singleRuns;
    }

    public List<EvaluationRun> getAveragedRuns() {
        return this.averagedRuns;
    }

    public Map<String, Map<String, Map<String, Double>>> getStatisticalTestResults() {
        return this.statisticalTestResults;
    }

    public void setStatisticalTestResults(Map<String, Map<String, Map<String, Double>>> statisticalTestResults) {
        this.statisticalTestResults = statisticalTestResults;
    }
}

