/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.util.datetime;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum DateTimeFormat {
    FORMAT1("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"),
    FORMAT2("yyyy-MM-dd'T'HH:mm:ss.SSS"),
    FORMAT3("yyyy-MM-dd'T'HH:mm:ssXXX"),
    FORMAT4("yyyy-MM-dd'T'HH:mm:ss"),
    FORMAT5("yyyy-MM-dd'T'HH:mmXXX"),
    FORMAT6("yyyy-MM-dd'T'HH:mm"),
    FORMAT7("yyyy-MM-dd"),
    FORMAT8("yyyy-MM"),
    FORMAT9("yyyy");

    private static final Logger logger;
    private String pattern;

    private DateTimeFormat(String value) {
        this.pattern = value;
    }

    public String getPattern() {
        return this.pattern;
    }

    public static Date getDate(String timeStamp) {
        SimpleDateFormat df = null;
        Date date = null;
        for (DateTimeFormat pat : DateTimeFormat.values()) {
            try {
                logger.info("Before: " + date);
                df = new SimpleDateFormat(pat.getPattern());
                date = df.parse(timeStamp);
                logger.info("After: " + date.toString());
                break;
            }
            catch (ParseException parseException) {
            }
        }
        if (date == null) {
            logger.error("Couldn't parse date: " + timeStamp);
            throw new RuntimeException();
        }
        return date;
    }

    static {
        logger = LoggerFactory.getLogger(DateTimeFormat.class);
    }
}

