/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.matching;

import java.util.HashSet;
import java.util.Set;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.ml.algorithm.matching.PropertyMapper;
import org.apache.jena.graph.Node;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.rdf.model.Model;
import org.apache.log4j.Logger;
import uk.ac.shef.wit.simmetrics.similaritymetrics.QGramsDistance;

public class LabelBasedPropertyMapper
implements PropertyMapper {
    static Logger logger = Logger.getLogger((String)"LIMES");
    QGramsDistance metric = new QGramsDistance();
    Model sourceModel;
    Model targetModel;

    public LabelBasedPropertyMapper() {
    }

    public LabelBasedPropertyMapper(Model sourceModel, Model targetModel) {
        this();
        this.sourceModel = sourceModel;
        this.targetModel = targetModel;
    }

    @Override
    public AMapping getPropertyMapping(String endpoint1, String endpoint2, String classExpression1, String classExpression2) {
        Set<Node> properties1 = this.getProperties(endpoint1, classExpression1, this.sourceModel);
        Set<Node> properties2 = this.getProperties(endpoint2, classExpression2, this.targetModel);
        AMapping result = MappingFactory.createDefaultMapping();
        for (Node a : properties1) {
            for (Node b : properties2) {
                String s = a.getLocalName().toLowerCase();
                String t = b.getLocalName().toLowerCase();
                result.add(a.getURI(), b.getURI(), this.metric.getSimilarity(s, t));
            }
        }
        return result;
    }

    public Model getTargetModel() {
        return this.targetModel;
    }

    @Override
    public void setTargetModel(Model targetModel) {
        this.targetModel = targetModel;
    }

    public Model getSourceModel() {
        return this.sourceModel;
    }

    @Override
    public void setSourceModel(Model sourceModel) {
        this.sourceModel = sourceModel;
    }

    private Set<Node> getProperties(String endpoint, String classExpression, Model model) {
        HashSet<Node> result = new HashSet<Node>();
        try {
            String query = "SELECT DISTINCT ?p WHERE { ?s ?p ?y. ?s a <" + classExpression + "> }";
            Query sparqlQuery = QueryFactory.create((String)query);
            Object qexec = model == null ? QueryExecutionFactory.sparqlService((String)endpoint, (Query)sparqlQuery) : QueryExecutionFactory.create((Query)sparqlQuery, (Model)model);
            ResultSet results = qexec.execSelect();
            while (results.hasNext()) {
                QuerySolution soln = results.nextSolution();
                result.add(soln.get("p").asNode());
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Error while processing classes");
        }
        return result;
    }
}

