/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.measures;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import java.util.ArrayList;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.AEdgeCountingSemanticMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.finders.ShortestPathFinder;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;

public class ShortestPathMeasure
extends AEdgeCountingSemanticMeasure {
    double maxValue = 1.0;

    public ShortestPathMeasure(AIndex Indexer) {
        super(Indexer);
    }

    public double calculate(ISynset synset1, double shortestPath) {
        double sim = 0.0;
        double D = this.getHierarchyDepth(synset1.getType());
        sim = 2.0 * D - shortestPath;
        return sim /= 2.0 * D;
    }

    @Override
    public double getSimilarityBetweenConcepts(ISynset synset1, ISynset synset2) {
        ArrayList<ArrayList<ISynsetID>> paths1 = this.getPaths(synset1);
        ArrayList<ArrayList<ISynsetID>> paths2 = this.getPaths(synset2);
        if (paths1.isEmpty() || paths2.isEmpty()) {
            return 0.0;
        }
        if (synset1.getType() != synset2.getType()) {
            return 0.0;
        }
        if (synset1.getOffset() == synset2.getOffset()) {
            return this.maxValue;
        }
        int shortestPath = ShortestPathFinder.shortestPath(paths1, paths2);
        if (shortestPath == -1) {
            return 0.0;
        }
        return this.calculate(synset1, shortestPath);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "shortestPath";
    }

    @Override
    public String getType() {
        return "semantic";
    }
}

