/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.memory;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import edu.mit.jwi.item.POS;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.dictionary.SemanticDictionary;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.finders.HypernymPathsFinder;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryIndex
extends AIndex {
    private static final Logger logger = LoggerFactory.getLogger(MemoryIndex.class);
    HashMap<String, HashMap<Integer, Integer>> minDepths = new HashMap();
    HashMap<String, HashMap<Integer, Integer>> maxDepths = new HashMap();
    HashMap<String, HashMap<Integer, ArrayList<ArrayList<ISynsetID>>>> paths = new HashMap();
    protected SemanticDictionary dictionary = null;

    @Override
    public void init(boolean f) {
    }

    @Override
    public void close() {
    }

    @Override
    public void preIndex() {
        this.preIndexPaths();
    }

    public void preIndexPaths() {
        this.dictionary = new SemanticDictionary();
        this.dictionary.exportDictionaryToFile();
        this.dictionary.openDictionaryFromFile();
        logger.info("Indexing begins.");
        for (POS pos : POS.values()) {
            this.paths.put(pos.toString(), new HashMap());
            Iterator iterator = this.dictionary.getDictionary().getSynsetIterator(pos);
            while (iterator.hasNext()) {
                ISynset synset = (ISynset)iterator.next();
                ArrayList<ArrayList<ISynsetID>> trees = HypernymPathsFinder.getHypernymPaths(this.dictionary, synset);
                HashMap<Integer, ArrayList<ArrayList<ISynsetID>>> temp = this.paths.get(pos.toString());
                temp.put(synset.getOffset(), trees);
                this.paths.put(pos.toString(), temp);
            }
        }
        logger.info("Indexing done.");
        this.dictionary.removeDictionary();
    }

    @Override
    public ArrayList<ArrayList<ISynsetID>> getHypernymPaths(ISynset synset) {
        return this.paths.get(synset.getPOS().toString()).get(synset.getOffset());
    }
}

