/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.space;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.space.blocking.BlockingFactory;
import org.aksw.limes.core.measures.mapper.space.blocking.IBlockingModule;
import org.aksw.limes.core.measures.measure.space.ISpaceMeasure;
import org.aksw.limes.core.measures.measure.space.SpaceMeasureFactory;

public class HR3Mapper
extends AMapper {
    public int granularity = 4;

    @Override
    public String getName() {
        return "TotalOrderBlockingMapper";
    }

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        ArrayList<ArrayList<Integer>> blockIds;
        Object property2;
        String term2;
        Object property1;
        AMapping mapping = MappingFactory.createDefaultMapping();
        HashMap targetBlocks = new HashMap();
        Parser p = new Parser(expression, threshold);
        String term1 = p.getLeftTerm();
        if (term1.contains(".")) {
            String[] split = term1.split("\\.");
            property1 = split[1];
            if (split.length >= 2) {
                for (int part = 2; part < split.length; ++part) {
                    property1 = (String)property1 + "." + split[part];
                }
            }
        } else {
            property1 = term1;
        }
        if ((term2 = p.getRightTerm()).contains(".")) {
            String[] split = term2.split("\\.");
            property2 = split[1];
            if (split.length >= 2) {
                for (int part = 2; part < split.length; ++part) {
                    property2 = (String)property2 + "." + split[part];
                }
            }
        } else {
            property2 = term2;
        }
        int dimensions = ((String)property2).split("\\|").length;
        IBlockingModule generator = BlockingFactory.getBlockingModule((String)property2, p.getOperator(), threshold, this.granularity);
        ISpaceMeasure measure = SpaceMeasureFactory.getMeasure(p.getOperator(), dimensions);
        for (String key : target.getAllUris()) {
            blockIds = generator.getAllBlockIds(target.getInstance(key));
            for (int ids = 0; ids < blockIds.size(); ++ids) {
                if (!targetBlocks.containsKey(blockIds.get(ids))) {
                    targetBlocks.put(blockIds.get(ids), new TreeSet());
                }
                ((TreeSet)targetBlocks.get(blockIds.get(ids))).add(key);
            }
        }
        int counter = 0;
        source.getAllUris().size();
        for (String sourceInstanceUri : source.getAllUris()) {
            if (++counter % 1000 == 0) {
                // empty if block
            }
            blockIds = generator.getAllSourceIds(source.getInstance(sourceInstanceUri), (String)property1);
            for (int ids = 0; ids < blockIds.size(); ++ids) {
                ArrayList<ArrayList<Integer>> blocksToCompare = generator.getBlocksToCompare(blockIds.get(ids));
                for (int index = 0; index < blocksToCompare.size(); ++index) {
                    if (!targetBlocks.containsKey(blocksToCompare.get(index))) continue;
                    TreeSet uris = (TreeSet)targetBlocks.get(blocksToCompare.get(index));
                    for (String targetInstanceUri : uris) {
                        double sim = measure.getSimilarity(source.getInstance(sourceInstanceUri), target.getInstance(targetInstanceUri), (String)property1, (String)property2);
                        if (!(sim >= threshold)) continue;
                        mapping.add(sourceInstanceUri, targetInstanceUri, sim);
                    }
                }
            }
        }
        return mapping;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 16.27 + 5.1 * (double)sourceSize + 4.9 * (double)targetSize - 23.44 * threshold;
        }
        return 200.0 + 0.005 * (double)(sourceSize + targetSize) - 56.4 * threshold;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double threshold, IMapper.Language language) {
        if (language.equals((Object)IMapper.Language.DE)) {
            return 2333.0 + 0.14 * (double)sourceSize + 0.14 * (double)targetSize - 3905.0 * threshold;
        }
        return 0.006 * (double)(sourceSize + targetSize) - 134.2 * threshold;
    }
}

