/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.evaluation.evaluator.EvaluatorType;
import org.aksw.limes.core.io.config.IConfiguration;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLImplementationType;
import org.apache.commons.validator.routines.UrlValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Configuration
implements IConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(Configuration.class);
    private static final String DEFAULT = "default";
    protected KBInfo sourceInfo = new KBInfo();
    protected KBInfo targetInfo = new KBInfo();
    protected String metricExpression = new String();
    protected String acceptanceRelation = new String();
    protected String verificationRelation = new String();
    protected double acceptanceThreshold;
    protected String acceptanceFile;
    protected double verificationThreshold;
    protected String verificationFile;
    protected Map<String, String> prefixes = new HashMap<String, String>();
    protected String outputFormat;
    protected String executionRewriter = "default";
    protected String executionPlanner = "default";
    protected String executionEngine = "default";
    protected long optimizationTime = 0L;
    protected double expectedSelectivity = 1.0;
    protected int granularity = 2;
    protected String mlAlgorithmName = new String();
    protected List<LearningParameter> mlAlgorithmParameters = new ArrayList<LearningParameter>();
    protected MLImplementationType mlImplementationType = MLImplementationType.UNSUPERVISED;
    protected String mlTrainingDataFile = null;
    protected EvaluatorType mlPseudoFMeasure = null;

    public Configuration() {
    }

    public Configuration(KBInfo sourceInfo, KBInfo targetInfo, String metricExpression, String acceptanceRelation, String verificationRelation, double acceptanceThreshold, String acceptanceFile, double verificationThreshold, String verificationFile, Map<String, String> prefixes, String outputFormat, String executionRewriter, String executionPlanner, String executionEngine, int granularity, String mlAlgorithmName, List<LearningParameter> mlParameters, MLImplementationType mlImplementationType, String mlTrainingDataFile, EvaluatorType mlPseudoFMeasure, long maxOpt, double k) {
        this.prefixes = prefixes;
        this.sourceInfo = sourceInfo;
        this.targetInfo = targetInfo;
        this.metricExpression = metricExpression;
        this.setAcceptanceRelation(acceptanceRelation);
        this.setVerificationRelation(verificationRelation);
        this.acceptanceThreshold = acceptanceThreshold;
        this.acceptanceFile = acceptanceFile;
        this.verificationThreshold = verificationThreshold;
        this.verificationFile = verificationFile;
        this.outputFormat = outputFormat;
        this.executionRewriter = executionRewriter;
        this.executionPlanner = executionPlanner;
        this.executionEngine = executionEngine;
        this.granularity = granularity;
        this.mlAlgorithmName = mlAlgorithmName;
        this.mlAlgorithmParameters = mlParameters;
        this.mlImplementationType = mlImplementationType;
        this.mlTrainingDataFile = mlTrainingDataFile;
        this.mlPseudoFMeasure = mlPseudoFMeasure;
        this.optimizationTime = maxOpt;
        this.expectedSelectivity = k;
    }

    public void addMlAlgorithmParameter(String mlParameterName, Object mlParameterValue) {
        LearningParameter lp = new LearningParameter();
        lp.setName(mlParameterName);
        lp.setValue(mlParameterValue);
        this.mlAlgorithmParameters.add(lp);
    }

    public void addPrefix(String label, String namespace) {
        this.prefixes.put(label, namespace);
    }

    public String getAcceptanceFile() {
        return this.acceptanceFile;
    }

    public String getAcceptanceRelation() {
        return this.acceptanceRelation;
    }

    public double getAcceptanceThreshold() {
        return this.acceptanceThreshold;
    }

    @Override
    public Set<String> getConfigurationParametersNames() {
        return new HashSet<String>(Arrays.asList("sourceInfo", "targetInfo", "metricExpression", "acceptanceRelation", "verificationRelation", "acceptanceThreshold", "acceptanceFile", "verificationThreshold", "verificationFile", "exemplars", "prefixes", "outputFormat", "executionPlan", "granularity", "recallRegulator", "recallThreshold", "optimizationTime", "expectedSelectivity"));
    }

    public int getGranularity() {
        return this.granularity;
    }

    public String getMetricExpression() {
        return this.metricExpression;
    }

    public String getMlAlgorithmName() {
        return this.mlAlgorithmName;
    }

    public MLImplementationType getMlImplementationType() {
        return this.mlImplementationType;
    }

    public List<LearningParameter> getMlAlgorithmParameters() {
        return this.mlAlgorithmParameters;
    }

    public EvaluatorType getMlPseudoFMeasure() {
        return this.mlPseudoFMeasure;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public Map<String, String> getPrefixes() {
        return this.prefixes;
    }

    public KBInfo getSourceInfo() {
        return this.sourceInfo;
    }

    public KBInfo getTargetInfo() {
        return this.targetInfo;
    }

    public String getTrainingDataFile() {
        return this.mlTrainingDataFile;
    }

    public String getVerificationFile() {
        return this.verificationFile;
    }

    public String getVerificationRelation() {
        return this.verificationRelation;
    }

    public double getVerificationThreshold() {
        return this.verificationThreshold;
    }

    public void setAcceptanceFile(String acceptanceFile) {
        this.acceptanceFile = acceptanceFile;
    }

    public void setAcceptanceRelation(String acceptanceRelation) {
        if (new UrlValidator().isValid(acceptanceRelation)) {
            this.acceptanceRelation = acceptanceRelation;
            return;
        }
        if (acceptanceRelation.contains(":")) {
            String prefix = acceptanceRelation.substring(0, acceptanceRelation.indexOf(":"));
            if (this.prefixes.containsKey(prefix)) {
                String prefixURI = this.prefixes.get(prefix);
                acceptanceRelation = acceptanceRelation.replace(prefix + ":", prefixURI);
            } else {
                logger.error("Undefined prefix: " + prefix);
                throw new RuntimeException();
            }
        }
        this.acceptanceRelation = acceptanceRelation;
    }

    public void setAcceptanceThreshold(double acceptanceThreshold) {
        this.acceptanceThreshold = acceptanceThreshold;
    }

    public void setGranularity(int granularity) {
        this.granularity = granularity;
    }

    public void setMetricExpression(String metricExpression) {
        this.metricExpression = metricExpression;
    }

    public void setMlAlgorithmName(String mlAlgorithmName) {
        this.mlAlgorithmName = mlAlgorithmName;
    }

    public void setMlImplementationType(MLImplementationType mlImplementationType) {
        this.mlImplementationType = mlImplementationType;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setPrefixes(HashMap<String, String> prefixes) {
        this.prefixes = prefixes;
    }

    public void setSourceInfo(KBInfo sourceInfo) {
        this.sourceInfo = sourceInfo;
    }

    public void setTargetInfo(KBInfo targetInfo) {
        this.targetInfo = targetInfo;
    }

    public void setTrainingDataFile(String trainingDataFile) {
        this.mlTrainingDataFile = trainingDataFile;
    }

    public void setVerificationFile(String verificationFile) {
        this.verificationFile = verificationFile;
    }

    public void setVerificationRelation(String verificationRelation) {
        if (new UrlValidator().isValid(verificationRelation)) {
            this.verificationRelation = verificationRelation;
            return;
        }
        if (verificationRelation.contains(":")) {
            String prefix = verificationRelation.substring(0, verificationRelation.indexOf(":"));
            if (this.prefixes.containsKey(prefix)) {
                String prefixURI = this.prefixes.get(prefix);
                verificationRelation = verificationRelation.replace(prefix + ":", prefixURI);
            } else {
                logger.error("Undefined prefix: " + prefix);
                throw new RuntimeException();
            }
        }
        this.verificationRelation = verificationRelation;
    }

    public void setVerificationThreshold(double verificationThreshold) {
        this.verificationThreshold = verificationThreshold;
    }

    public String getExecutionRewriter() {
        return this.executionRewriter;
    }

    public void setExecutionRewriter(String executionRewriter) {
        this.executionRewriter = executionRewriter;
    }

    public String getExecutionPlanner() {
        return this.executionPlanner;
    }

    public void setExecutionPlanner(String executionPlanner) {
        this.executionPlanner = executionPlanner;
    }

    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public void setExecutionEngine(String executionEngine) {
        this.executionEngine = executionEngine;
    }

    public void setOptimizationTime(long maxOpt) {
        this.optimizationTime = maxOpt;
    }

    public long getOptimizationTime() {
        return this.optimizationTime;
    }

    public void setExpectedSelectivity(double k) {
        this.expectedSelectivity = k;
    }

    public double getExpectedSelectivity() {
        return this.expectedSelectivity;
    }

    public String getMlTrainingDataFile() {
        return this.mlTrainingDataFile;
    }

    public String toString() {
        return "Configuration [sourceInfo=" + this.sourceInfo + ", targetInfo=" + this.targetInfo + ", metricExpression=" + this.metricExpression + ", acceptanceRelation=" + this.acceptanceRelation + ", verificationRelation=" + this.verificationRelation + ", acceptanceThreshold=" + this.acceptanceThreshold + ", acceptanceFile=" + this.acceptanceFile + ", verificationThreshold=" + this.verificationThreshold + ", verificationFile=" + this.verificationFile + ", prefixes=" + this.prefixes + ", outputFormat=" + this.outputFormat + ", executionRewriter=" + this.executionRewriter + ", executionPlanner=" + this.executionPlanner + ", executionEngine=" + this.executionEngine + ", optimization time=" + this.optimizationTime + ", expected selectivity=" + this.expectedSelectivity + ", granularity=" + this.granularity + ", mlAlgorithmName=" + this.mlAlgorithmName + ", mlParameters=" + this.mlAlgorithmParameters + ", mlImplementationType=" + this.mlImplementationType + ", mlTrainingDataFile=" + this.mlTrainingDataFile + ", mlPseudoFMeasure=" + this.mlPseudoFMeasure + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.acceptanceFile == null ? 0 : this.acceptanceFile.hashCode());
        result = 31 * result + (this.acceptanceRelation == null ? 0 : this.acceptanceRelation.hashCode());
        long temp = Double.doubleToLongBits(this.acceptanceThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (this.executionEngine == null ? 0 : this.executionEngine.hashCode());
        result = 31 * result + (this.executionPlanner == null ? 0 : this.executionPlanner.hashCode());
        result = 31 * result + (this.executionRewriter == null ? 0 : this.executionRewriter.hashCode());
        result = 31 * result + this.granularity;
        result = 31 * result + (this.metricExpression == null ? 0 : this.metricExpression.hashCode());
        result = 31 * result + (this.mlAlgorithmName == null ? 0 : this.mlAlgorithmName.hashCode());
        result = 31 * result + (this.mlImplementationType == null ? 0 : this.mlImplementationType.hashCode());
        result = 31 * result + (this.mlAlgorithmParameters == null ? 0 : this.mlAlgorithmParameters.hashCode());
        result = 31 * result + (this.mlPseudoFMeasure == null ? 0 : this.mlPseudoFMeasure.hashCode());
        result = 31 * result + (this.mlTrainingDataFile == null ? 0 : this.mlTrainingDataFile.hashCode());
        result = 31 * result + (this.outputFormat == null ? 0 : this.outputFormat.hashCode());
        result = 31 * result + (this.prefixes == null ? 0 : this.prefixes.hashCode());
        result = 31 * result + (this.sourceInfo == null ? 0 : this.sourceInfo.hashCode());
        result = 31 * result + (this.targetInfo == null ? 0 : this.targetInfo.hashCode());
        result = 31 * result + (this.verificationFile == null ? 0 : this.verificationFile.hashCode());
        result = 31 * result + (this.verificationRelation == null ? 0 : this.verificationRelation.hashCode());
        temp = Double.doubleToLongBits(this.verificationThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.optimizationTime);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.expectedSelectivity);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Configuration other = (Configuration)obj;
        if (this.acceptanceFile == null ? other.acceptanceFile != null : !this.acceptanceFile.equals(other.acceptanceFile)) {
            return false;
        }
        if (this.acceptanceRelation == null ? other.acceptanceRelation != null : !this.acceptanceRelation.equals(other.acceptanceRelation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.acceptanceThreshold) != Double.doubleToLongBits(other.acceptanceThreshold)) {
            return false;
        }
        if (this.executionEngine == null ? other.executionEngine != null : !this.executionEngine.equals(other.executionEngine)) {
            return false;
        }
        if (this.executionPlanner == null ? other.executionPlanner != null : !this.executionPlanner.equals(other.executionPlanner)) {
            return false;
        }
        if (this.executionRewriter == null ? other.executionRewriter != null : !this.executionRewriter.equals(other.executionRewriter)) {
            return false;
        }
        if (this.granularity != other.granularity) {
            return false;
        }
        if (this.metricExpression == null ? other.metricExpression != null : !this.metricExpression.equals(other.metricExpression)) {
            return false;
        }
        if (this.mlAlgorithmName == null ? other.mlAlgorithmName != null : !this.mlAlgorithmName.equals(other.mlAlgorithmName)) {
            return false;
        }
        if (this.mlImplementationType != other.mlImplementationType) {
            return false;
        }
        if (this.mlAlgorithmParameters == null ? other.mlAlgorithmParameters != null : !this.mlAlgorithmParameters.equals(other.mlAlgorithmParameters)) {
            return false;
        }
        if (this.mlPseudoFMeasure != other.mlPseudoFMeasure) {
            return false;
        }
        if (this.mlTrainingDataFile == null ? other.mlTrainingDataFile != null : !this.mlTrainingDataFile.equals(other.mlTrainingDataFile)) {
            return false;
        }
        if (this.outputFormat == null ? other.outputFormat != null : !this.outputFormat.equals(other.outputFormat)) {
            return false;
        }
        if (this.prefixes == null ? other.prefixes != null : !this.prefixes.equals(other.prefixes)) {
            return false;
        }
        if (this.sourceInfo == null ? other.sourceInfo != null : !this.sourceInfo.equals(other.sourceInfo)) {
            return false;
        }
        if (this.targetInfo == null ? other.targetInfo != null : !this.targetInfo.equals(other.targetInfo)) {
            return false;
        }
        if (this.verificationFile == null ? other.verificationFile != null : !this.verificationFile.equals(other.verificationFile)) {
            return false;
        }
        if (this.verificationRelation == null ? other.verificationRelation != null : !this.verificationRelation.equals(other.verificationRelation)) {
            return false;
        }
        if (Double.doubleToLongBits(this.verificationThreshold) != Double.doubleToLongBits(other.verificationThreshold)) {
            return false;
        }
        if (this.optimizationTime != other.optimizationTime) {
            return false;
        }
        return Double.doubleToLongBits(this.expectedSelectivity) == Double.doubleToLongBits(other.expectedSelectivity);
    }

    public void setMlTrainingDataFile(String mlTrainingDataFile) {
        this.mlTrainingDataFile = mlTrainingDataFile;
    }

    public void setPrefixes(Map<String, String> prefixes) {
        this.prefixes = prefixes;
    }

    public void setMlAlgorithmParameters(List<LearningParameter> mlParameters) {
        this.mlAlgorithmParameters = mlParameters;
    }

    public void setMlPseudoFMeasure(EvaluatorType mlPseudoFMeasure) {
        this.mlPseudoFMeasure = mlPseudoFMeasure;
    }
}

