/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.evaluation.qualititativeMeasures;

import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.APRF;
import org.aksw.limes.core.evaluation.qualititativeMeasures.IQualitativeMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Precision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Recall;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FMeasure
extends APRF
implements IQualitativeMeasure {
    static Logger logger = LoggerFactory.getLogger(FMeasure.class);

    @Override
    public double calculate(AMapping predictions, GoldStandard goldStandard) {
        return this.calculate(predictions, goldStandard, 1.0);
    }

    public double calculate(AMapping predictions, GoldStandard goldStandard, double beta) {
        double p = this.precision(predictions, goldStandard);
        double r = this.recall(predictions, goldStandard);
        double beta2 = Math.pow(beta, 2.0);
        if (p + r > 0.0) {
            return (1.0 + beta2) * p * r / (beta2 * p + r);
        }
        return 0.0;
    }

    public double recall(AMapping predictions, GoldStandard goldStandard) {
        return new Recall().calculate(predictions, goldStandard);
    }

    public double precision(AMapping predictions, GoldStandard goldStandard) {
        return new Precision().calculate(predictions, goldStandard);
    }
}

