/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.controller;

import java.util.NoSuchElementException;
import java.util.Scanner;
import org.aksw.limes.core.controller.ActiveLearningExamples;
import org.aksw.limes.core.controller.ActiveLearningOracle;
import org.aksw.limes.core.io.mapping.AMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConsoleOracle
implements ActiveLearningOracle {
    private static final Logger logger = LoggerFactory.getLogger(ConsoleOracle.class);
    private boolean stopped = false;
    private final int maxIterations;
    private int i = 0;

    public ConsoleOracle(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    @Override
    public AMapping classify(ActiveLearningExamples examples) {
        Scanner scan = new Scanner(System.in);
        if (++this.i >= this.maxIterations) {
            this.stopped = true;
        }
        logger.info("To rate the " + this.i + ". set of examples, write 'r' and press enter.\nTo quit learning at this point and write out the mapping, write 'q' and press enter.\nFor rating examples, use numbers in [-1,+1].\n\t(-1 := strong negative example, +1 := strong positive example)");
        String reply = scan.next();
        if (reply.trim().equals("q")) {
            this.stopped = true;
        } else {
            int j = 0;
            for (ActiveLearningExamples.Example ex : examples) {
                boolean rated = false;
                ++j;
                do {
                    String evaluationMsg = "Example #" + this.i + "." + j + ": (" + ex.getSource().getUri() + ", " + ex.getTarget().getUri() + ")";
                    try {
                        logger.info(evaluationMsg);
                        double rating = scan.nextDouble();
                        if (rating >= -1.0 && rating <= 1.0) {
                            ex.classify(rating);
                            rated = true;
                            continue;
                        }
                        logger.error("Input number out of range [-1,+1], please try again...");
                    }
                    catch (NoSuchElementException e) {
                        logger.error("Input did not match floating point number, please try again...");
                        scan.next();
                    }
                } while (!rated);
            }
        }
        return examples.getExampleMap();
    }

    @Override
    public boolean isStopped() {
        return this.stopped;
    }

    @Override
    public void stop() {
        this.stopped = true;
    }

    @Override
    public int getIteration() {
        return this.i;
    }
}

