/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.wombat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.datastrutures.Tree;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Precision;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.Recall;
import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.ExecutionEngineFactory;
import org.aksw.limes.core.execution.engine.SimpleExecutionEngine;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.execution.planning.planner.ExecutionPlannerFactory;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.execution.rewriter.Rewriter;
import org.aksw.limes.core.execution.rewriter.RewriterFactory;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.HybridCache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.aksw.limes.core.ml.algorithm.ACoreMLAlgorithm;
import org.aksw.limes.core.ml.algorithm.LearningParameter;
import org.aksw.limes.core.ml.algorithm.MLResults;
import org.aksw.limes.core.ml.algorithm.classifier.ExtendedClassifier;
import org.aksw.limes.core.ml.algorithm.euclid.LinearSelfConfigurator;
import org.aksw.limes.core.ml.algorithm.wombat.RefinementNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AWombat
extends ACoreMLAlgorithm {
    public static final String PARAMETER_MAX_REFINEMENT_TREE_SIZE = "max refinement tree size";
    public static final String PARAMETER_MAX_ITERATIONS_NUMBER = "max iterations number";
    public static final String PARAMETER_MAX_ITERATION_TIME_IN_MINUTES = "max iteration time in minutes";
    public static final String PARAMETER_EXECUTION_TIME_IN_MINUTES = "max execution time in minutes";
    public static final String PARAMETER_MAX_FITNESS_THRESHOLD = "max fitness threshold";
    public static final String PARAMETER_MIN_PROPERTY_COVERAGE = "minimum property coverage";
    public static final String PARAMETER_PROPERTY_LEARNING_RATE = "property learning rate";
    public static final String PARAMETER_OVERALL_PENALTY_WEIGHT = "overall penalty weight";
    public static final String PARAMETER_CHILDREN_PENALTY_WEIGHT = "children penalty weight";
    public static final String PARAMETER_COMPLEXITY_PENALTY_WEIGHT = "complexity penalty weight";
    public static final String PARAMETER_VERBOSE = "verbose";
    public static final String PARAMETER_ATOMIC_MEASURES = "atomic measures";
    public static final String PARAMETER_SAVE_MAPPING = "save mapping";
    public static final String PARAMETER_FMEASURE_BETA = "beta";
    public static List<String> sourceUris;
    public static List<String> targetUris;
    static Logger logger;
    protected String sourceVariable = "x";
    protected String targetVariable = "y";
    protected Map<String, Double> sourcePropertiesCoverageMap;
    protected Map<String, Double> targetPropertiesCoverageMap;
    protected PseudoFMeasure pseudoFMeasure = null;
    protected AMapping trainingData = MappingFactory.createDefaultMapping();
    protected boolean isUnsupervised = false;
    protected Set<String> wombatParameterNames = new HashSet<String>();
    protected ACache sourceSample = new HybridCache();
    protected ACache targetSample = new HybridCache();

    protected AWombat() {
        this.setDefaultParameters();
        if (this.configuration != null) {
            this.sourceVariable = this.configuration.getSourceInfo().getVar().trim().substring(1);
            this.targetVariable = this.configuration.getTargetInfo().getVar().trim().substring(1);
        }
    }

    protected RefinementNode createNode(AMapping mapping, String metricExpr) {
        if (!this.saveMapping()) {
            mapping = null;
        }
        return new RefinementNode(this.fMeasure(mapping), mapping, metricExpr);
    }

    private AMapping executeAtomicMeasure(String sourceProperty, String targetProperty, String measure, double threshold) {
        String measureExpression = measure + "(" + this.sourceVariable + "." + sourceProperty + ", " + this.targetVariable + "." + targetProperty + ")";
        Instruction inst = new Instruction(Instruction.Command.RUN, measureExpression, "" + threshold, -1, -1, -1);
        ExecutionEngine ee = ExecutionEngineFactory.getEngine(ExecutionEngineFactory.ExecutionEngineType.DEFAULT, this.sourceCache, this.targetCache, "?" + this.sourceVariable, "?" + this.targetVariable, 0L, 1.0);
        Plan plan = new Plan();
        plan.addInstruction(inst);
        return ((SimpleExecutionEngine)ee).executeInstructions(plan);
    }

    protected final double fMeasure(AMapping predictions) {
        if (this.isUnsupervised) {
            return this.pseudoFMeasure.calculate(predictions, new GoldStandard(null, sourceUris, targetUris), this.getBeta());
        }
        return new FMeasure().calculate(predictions, new GoldStandard(this.trainingData), this.getBeta());
    }

    protected final AMapping getMappingOfMetricExpression(String metricExpression, Tree<? extends RefinementNode> root) {
        AMapping map = null;
        if (this.saveMapping()) {
            map = this.getMappingOfMetricFromTree(metricExpression, root);
        }
        if (map == null) {
            double threshold = Double.parseDouble(metricExpression.substring(metricExpression.lastIndexOf("|") + 1));
            map = this.executeLS(new LinkSpecification(metricExpression, threshold), this.sourceCache, this.targetCache);
        }
        return map;
    }

    private AMapping getMappingOfMetricFromTree(String metricExpression, Tree<? extends RefinementNode> root) {
        if (root != null) {
            if (root.getValue().getMetricExpression().equals(metricExpression)) {
                return root.getValue().getMapping();
            }
            if (root.getchildren() != null && root.getchildren().size() > 0) {
                for (Tree<? extends RefinementNode> c : root.getchildren()) {
                    AMapping map = this.getMappingOfMetricFromTree(metricExpression, c);
                    if (map == null || map.size() == 0) continue;
                    return map;
                }
            }
        }
        return null;
    }

    @Override
    protected AMapping predict(ACache source, ACache target, MLResults mlModel) {
        LinkSpecification ls = mlModel.getLinkSpecification();
        return this.executeLS(ls, source, target);
    }

    private AMapping executeLS(LinkSpecification ls, ACache sCache, ACache tCache) {
        Rewriter rw = RewriterFactory.getDefaultRewriter();
        LinkSpecification rwLs = rw.rewrite(ls);
        Planner planner = ExecutionPlannerFactory.getPlanner(ExecutionPlannerFactory.ExecutionPlannerType.DEFAULT, sCache, tCache);
        assert (planner != null);
        ExecutionEngine engine = ExecutionEngineFactory.getEngine(ExecutionEngineFactory.ExecutionEngineType.DEFAULT, sCache, tCache, "?" + this.sourceVariable, "?" + this.targetVariable, 0L, 1.0);
        assert (engine != null);
        AMapping resultMap = engine.execute(rwLs, planner);
        return resultMap.getSubMap(ls.getThreshold());
    }

    @Override
    protected void init(List<LearningParameter> lp, ACache sourceCache, ACache targetCache) {
        super.init(lp, sourceCache, targetCache);
        this.sourcePropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(sourceCache, this.getMinPropertyCoverage());
        this.targetPropertiesCoverageMap = LinearSelfConfigurator.getPropertyStats(targetCache, this.getMinPropertyCoverage());
    }

    public boolean isUnsupervised() {
        return this.isUnsupervised;
    }

    protected final double precision(AMapping predictions) {
        if (this.isUnsupervised) {
            return this.pseudoFMeasure.precision(predictions, new GoldStandard(null, sourceUris, targetUris));
        }
        return new Precision().calculate(predictions, new GoldStandard(this.trainingData));
    }

    protected final double recall(AMapping predictions) {
        if (this.isUnsupervised) {
            return this.pseudoFMeasure.recall(predictions, new GoldStandard(null, sourceUris, targetUris));
        }
        return new Recall().calculate(predictions, new GoldStandard(this.trainingData));
    }

    protected final void fillSampleSourceTargetCaches(AMapping sample) {
        for (String s : sample.getMap().keySet()) {
            if (this.sourceCache.containsUri(s)) {
                this.sourceSample.addInstance(this.sourceCache.getInstance(s));
                for (String t : sample.getMap().get(s).keySet()) {
                    if (this.targetCache.containsUri(t)) {
                        this.targetSample.addInstance(this.targetCache.getInstance(t));
                        continue;
                    }
                    logger.warn("Instance " + t + " does not exist in the target dataset");
                }
                continue;
            }
            logger.warn("Instance " + s + " does not exist in the source dataset");
        }
    }

    protected final List<ExtendedClassifier> findInitialClassifiers() {
        logger.debug("Geting all initial classifiers ...");
        ArrayList<ExtendedClassifier> initialClassifiers = new ArrayList<ExtendedClassifier>();
        for (String p : this.sourcePropertiesCoverageMap.keySet()) {
            for (String q : this.targetPropertiesCoverageMap.keySet()) {
                for (String m : this.getAtomicMeasures()) {
                    ExtendedClassifier cp = this.findInitialClassifier(p, q, m);
                    initialClassifiers.add(cp);
                }
            }
        }
        logger.debug("Done computing all initial classifiers.");
        return initialClassifiers;
    }

    double getThreshold(String measure) {
        double threshold = 0.4;
        if (measure.equals("li") || measure.equals("lch") || measure.equals("wupalmer") || measure.equals("shortest_path")) {
            threshold = 0.7;
        }
        return threshold;
    }

    private ExtendedClassifier findInitialClassifier(String sourceProperty, String targetProperty, String measure) {
        double maxOverlap = 0.0;
        double theta = 1.0;
        AMapping bestMapping = MappingFactory.createDefaultMapping();
        double minThreshold = this.getThreshold(measure);
        for (double threshold = 1.0; threshold > minThreshold; threshold *= this.getPropertyLearningRate()) {
            AMapping mapping = this.executeAtomicMeasure(sourceProperty, targetProperty, measure, threshold);
            double overlap = this.fMeasure(mapping);
            if (!(maxOverlap < overlap)) continue;
            theta = threshold;
            maxOverlap = overlap;
            bestMapping = mapping;
        }
        ExtendedClassifier cp = new ExtendedClassifier(measure, theta, sourceProperty, targetProperty);
        cp.setfMeasure(maxOverlap);
        cp.setMapping(bestMapping);
        return cp;
    }

    protected final <T extends RefinementNode> Tree<T> getBestNode(Tree<T> root) {
        return this.getMostPromisingNode(root, 0.0);
    }

    protected final <T extends RefinementNode> Tree<T> getMostPromisingNode(Tree<T> root) {
        return this.getMostPromisingNode(root, this.getOverAllPenaltyWeight());
    }

    private <T extends RefinementNode> Tree<T> getMostPromisingNode(Tree<T> root, double penaltyWeight) {
        if (root.getchildren() == null || root.getchildren().size() == 0) {
            return root;
        }
        Tree mostPromisingChild = new Tree();
        double bestFitness = -1.0;
        for (Tree<T> child : root.getchildren()) {
            if (!(((RefinementNode)child.getValue()).getFMeasure() >= 0.0)) continue;
            Tree<T> promisingChild = this.getMostPromisingNode(child, penaltyWeight);
            double penalty = this.computePenalty(root, promisingChild);
            double newFitness = ((RefinementNode)promisingChild.getValue()).getFMeasure() - penaltyWeight * penalty;
            if (newFitness > bestFitness) {
                mostPromisingChild = promisingChild;
                bestFitness = newFitness;
                continue;
            }
            if (newFitness != bestFitness) continue;
            double tieBreakerFitness = bestFitness - this.getOverAllPenaltyWeight() * this.computePenalty(root, mostPromisingChild);
            double newTieBreakerFitness = ((RefinementNode)promisingChild.getValue()).getFMeasure() - this.getOverAllPenaltyWeight() * penalty;
            if (!(newTieBreakerFitness > tieBreakerFitness)) continue;
            mostPromisingChild = promisingChild;
            bestFitness = ((RefinementNode)mostPromisingChild.getValue()).getFMeasure();
        }
        if (penaltyWeight > 0.0) {
            return mostPromisingChild;
        }
        if (((RefinementNode)root.getValue()).getFMeasure() >= ((RefinementNode)mostPromisingChild.getValue()).getFMeasure()) {
            return root;
        }
        return mostPromisingChild;
    }

    private double computePenalty(Tree<?> root, Tree<?> promisingChild) {
        long childrenCount = promisingChild.size() - 1L;
        double childrenPenalty = this.getChildrenPenaltyWeight() * (double)childrenCount / (double)root.size();
        long level = promisingChild.level();
        double complexityPenalty = this.getComplexityPenaltyWeight() * (double)level / (double)root.depth();
        return childrenPenalty + complexityPenalty;
    }

    protected final boolean saveMapping() {
        return Boolean.parseBoolean(this.getParameter(PARAMETER_SAVE_MAPPING).toString());
    }

    @Override
    public void setDefaultParameters() {
        long maxRefineTreeSize = 2000L;
        int maxIterationNumber = 3;
        int maxIterationTimeInMin = 20;
        int maxExecutionTimeInMin = 600;
        double maxFitnessThreshold = 1.0;
        double childrenPenaltyWeight = 1.0;
        double complexityPenaltyWeight = 1.0;
        double beta = 1.0;
        boolean saveMapping = true;
        double minPropertyCoverage = 0.4;
        double propertyLearningRate = 0.9;
        double overallPenaltyWeight = 0.5;
        boolean verbose = false;
        HashSet<String> measures = new HashSet<String>(Arrays.asList("jaccard", "cosine", "qgrams"));
        this.learningParameters = new ArrayList();
        this.learningParameters.add(new LearningParameter(PARAMETER_MAX_REFINEMENT_TREE_SIZE, maxRefineTreeSize, Long.class, 10.0, 9.223372036854776E18, 10.0, PARAMETER_MAX_REFINEMENT_TREE_SIZE));
        this.learningParameters.add(new LearningParameter(PARAMETER_MAX_ITERATIONS_NUMBER, maxIterationNumber, Integer.class, 1.0, 2.147483647E9, 10.0, PARAMETER_MAX_ITERATIONS_NUMBER));
        this.learningParameters.add(new LearningParameter(PARAMETER_MAX_ITERATION_TIME_IN_MINUTES, maxIterationTimeInMin, Integer.class, 1.0, 2.147483647E9, 1.0, PARAMETER_MAX_ITERATION_TIME_IN_MINUTES));
        this.learningParameters.add(new LearningParameter(PARAMETER_EXECUTION_TIME_IN_MINUTES, maxExecutionTimeInMin, Integer.class, 1.0, 2.147483647E9, 1.0, PARAMETER_EXECUTION_TIME_IN_MINUTES));
        this.learningParameters.add(new LearningParameter(PARAMETER_MAX_FITNESS_THRESHOLD, maxFitnessThreshold, Double.class, 0.0, 1.0, 0.01, PARAMETER_MAX_FITNESS_THRESHOLD));
        this.learningParameters.add(new LearningParameter(PARAMETER_MIN_PROPERTY_COVERAGE, minPropertyCoverage, Double.class, 0.0, 1.0, 0.01, PARAMETER_MIN_PROPERTY_COVERAGE));
        this.learningParameters.add(new LearningParameter(PARAMETER_PROPERTY_LEARNING_RATE, propertyLearningRate, Double.class, 0.0, 1.0, 0.01, PARAMETER_PROPERTY_LEARNING_RATE));
        this.learningParameters.add(new LearningParameter(PARAMETER_OVERALL_PENALTY_WEIGHT, overallPenaltyWeight, Double.class, 0.0, 1.0, 0.01, PARAMETER_OVERALL_PENALTY_WEIGHT));
        this.learningParameters.add(new LearningParameter(PARAMETER_CHILDREN_PENALTY_WEIGHT, childrenPenaltyWeight, Double.class, 0.0, 1.0, 0.01, PARAMETER_CHILDREN_PENALTY_WEIGHT));
        this.learningParameters.add(new LearningParameter(PARAMETER_COMPLEXITY_PENALTY_WEIGHT, complexityPenaltyWeight, Double.class, 0.0, 1.0, 0.01, PARAMETER_COMPLEXITY_PENALTY_WEIGHT));
        this.learningParameters.add(new LearningParameter(PARAMETER_FMEASURE_BETA, beta, Double.class, 0.0, Double.MAX_VALUE, 0.01, "beta parameter for f-measure"));
        this.learningParameters.add(new LearningParameter(PARAMETER_VERBOSE, verbose, Boolean.class, 0.0, 1.0, 0.0, PARAMETER_VERBOSE));
        this.learningParameters.add(new LearningParameter(PARAMETER_ATOMIC_MEASURES, measures, MeasureType.class, 0.0, 0.0, 0.0, PARAMETER_ATOMIC_MEASURES));
        this.learningParameters.add(new LearningParameter(PARAMETER_SAVE_MAPPING, saveMapping, Boolean.class, 0.0, 1.0, 0.0, PARAMETER_SAVE_MAPPING));
    }

    protected boolean isVerbose() {
        return Boolean.parseBoolean(this.getParameter(PARAMETER_VERBOSE).toString());
    }

    protected double getOverAllPenaltyWeight() {
        return Double.parseDouble(this.getParameter(PARAMETER_OVERALL_PENALTY_WEIGHT).toString());
    }

    protected double getChildrenPenaltyWeight() {
        return Double.parseDouble(this.getParameter(PARAMETER_CHILDREN_PENALTY_WEIGHT).toString());
    }

    protected double getComplexityPenaltyWeight() {
        return Double.parseDouble(this.getParameter(PARAMETER_COMPLEXITY_PENALTY_WEIGHT).toString());
    }

    protected double getMinPropertyCoverage() {
        return Double.parseDouble(this.getParameter(PARAMETER_MIN_PROPERTY_COVERAGE).toString());
    }

    protected double getPropertyLearningRate() {
        return Double.parseDouble(this.getParameter(PARAMETER_PROPERTY_LEARNING_RATE).toString());
    }

    protected double getBeta() {
        return Double.parseDouble(this.getParameter(PARAMETER_FMEASURE_BETA).toString());
    }

    protected int getIterationTimeInMinutes() {
        return Integer.parseInt(this.getParameter(PARAMETER_MAX_ITERATION_TIME_IN_MINUTES).toString());
    }

    protected int getExcutionTimeInMinutes() {
        return Integer.parseInt(this.getParameter(PARAMETER_EXECUTION_TIME_IN_MINUTES).toString());
    }

    protected double getMaxFitnessThreshold() {
        return Double.parseDouble(this.getParameter(PARAMETER_MAX_FITNESS_THRESHOLD).toString());
    }

    protected int getMaxIterationNumber() {
        return Integer.parseInt(this.getParameter(PARAMETER_MAX_ITERATIONS_NUMBER).toString());
    }

    protected int getMaxRefinmentTreeSize() {
        return Integer.parseInt(this.getParameter(PARAMETER_MAX_REFINEMENT_TREE_SIZE).toString());
    }

    protected Set<String> getAtomicMeasures() {
        HashSet<String> atomicMeasures = new HashSet<String>();
        String measuresAsString = this.getParameter(PARAMETER_ATOMIC_MEASURES).toString().replace("[", "").replace("]", "");
        for (String m : measuresAsString.split(",")) {
            atomicMeasures.add(m.trim());
        }
        return atomicMeasures;
    }

    static {
        logger = LoggerFactory.getLogger(AWombat.class);
    }
}

