/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ALDecider {
    static Logger logger = LoggerFactory.getLogger((String)"ALDecider.class");
    private HashSet<Triple> retrieved = new HashSet();
    private int maxCount = 5000;

    public static void main(String[] args) {
        AMapping a = MappingFactory.createDefaultMapping();
        AMapping b = MappingFactory.createDefaultMapping();
        AMapping c = MappingFactory.createDefaultMapping();
        AMapping d = MappingFactory.createDefaultMapping();
        a.add("a", "y", 1.0);
        a.add("d", "f", 8.0);
        b.add("a", "y", 1.0);
        b.add("a", "x", 4.0);
        c.add("c", "y", 5.0);
        c.add("d", "f", 5.0);
        d.add("D", "D", 77.0);
        d.add("a", "y", 1.0);
        d.add("a", "x", 4.0);
        LinkedList<AMapping> mapList = new LinkedList<AMapping>();
        mapList.add(a);
        mapList.add(b);
        mapList.add(c);
        mapList.add(d);
        ALDecider aLD = new ALDecider();
        HashMap<Triple, Integer> result0 = aLD.getControversyMatches(mapList);
        System.out.println("aLD.getControversyMatches(mapList)\n" + result0);
        List<Triple> result = aLD.getControversyCandidates(mapList, 1);
        System.out.println(result);
        aLD.setKnown(MappingFactory.createDefaultMapping());
        aLD.retrieved.clear();
        result = aLD.getControversyCandidates(mapList, 2);
        System.out.println(result);
        result = aLD.getControversyCandidates(mapList, 8);
        System.out.println(result);
    }

    public HashMap<Triple, Integer> getControversyMatches(List<AMapping> mapList) {
        HashMap<Triple, Integer> answer = new HashMap<Triple, Integer>();
        for (AMapping m : mapList) {
            int counter = 0;
            for (String key : m.getMap().keySet()) {
                if (counter >= this.maxCount) continue;
                for (String value : m.getMap().get(key).keySet()) {
                    Triple t = new Triple(key, value, 1.0);
                    if (!this.retrieved.contains(t)) {
                        if (answer.containsKey(t)) {
                            int count = answer.get(t);
                            answer.put(t, count + 1);
                        } else {
                            answer.put(t, 1);
                        }
                    }
                    ++counter;
                }
            }
        }
        return answer;
    }

    public List<Triple> getControversyCandidates(List<AMapping> mapList, int n) {
        logger.info("get " + n + " most controversy matches from " + mapList.size() + " Mappings");
        HashMap answer = new HashMap();
        for (int i = 1; i <= mapList.size(); ++i) {
            answer.put(i, new HashSet());
        }
        HashMap<Triple, Integer> sub = this.getControversyMatches(mapList);
        for (Map.Entry e : sub.entrySet()) {
            ((Set)answer.get(e.getValue())).add((Triple)e.getKey());
        }
        logger.info("numbered controversy Matches with " + sub.size() + " triples. Putting them to " + answer.size() + " indices.");
        LinkedList<Triple> tripleList = new LinkedList<Triple>();
        int center = mapList.size() / 2;
        int minDist = mapList.size();
        int minimalDistance = mapList.size();
        while (tripleList.size() < Math.min(n, sub.size()) && !answer.isEmpty()) {
            boolean found = false;
            int MapsForFound = 0;
            Iterator iterator = answer.keySet().iterator();
            while (iterator.hasNext()) {
                int d = (Integer)iterator.next();
                if (Math.abs(d - center) > minimalDistance) continue;
                minDist = d;
                minimalDistance = Math.abs(d - center);
                found = true;
                MapsForFound = d;
            }
            HashSet<String> retrievedIDs = new HashSet<String>();
            if (found && answer.containsKey(minDist)) {
                for (Triple t : (Set)answer.get(minDist)) {
                    if (tripleList.size() < Math.min(n, sub.size())) {
                        if (retrievedIDs.contains(t.getSourceUri())) continue;
                        t.setSimilarity((float)MapsForFound / (float)mapList.size());
                        tripleList.add(t);
                        retrievedIDs.add(t.getSourceUri());
                        continue;
                    }
                    return tripleList;
                }
                answer.remove(minDist);
            }
            center = mapList.size() / 2;
            minDist = mapList.size();
            minimalDistance = mapList.size();
        }
        logger.info("Controversy matches: " + tripleList);
        return tripleList;
    }

    public List<Triple> getControversyCandidates(List<AMapping> mapList) {
        HashMap answer = new HashMap();
        for (int i = 1; i <= mapList.size(); ++i) {
            answer.put(i, new HashSet());
        }
        HashMap<Triple, Integer> sub = this.getControversyMatches(mapList);
        for (Map.Entry e : sub.entrySet()) {
            ((Set)answer.get(e.getValue())).add((Triple)e.getKey());
        }
        logger.info("numbered controversy Matches with " + sub.size() + " triples. Putting them to " + answer.size() + " indices.");
        LinkedList<Triple> tripleList = new LinkedList<Triple>();
        int center = mapList.size() / 2;
        int minDist = mapList.size();
        while (tripleList.size() < sub.size() && !answer.isEmpty()) {
            boolean found = false;
            int MapsForFound = 0;
            Iterator<Object> iterator = answer.keySet().iterator();
            while (iterator.hasNext()) {
                int d = (Integer)iterator.next();
                if (Math.abs(d - center) <= minDist) {
                    minDist = d;
                }
                found = true;
                MapsForFound = d;
            }
            if (found && answer.containsKey(minDist)) {
                for (Triple t : (Set)answer.get(minDist)) {
                    if (tripleList.size() < sub.size()) {
                        t.setSimilarity((float)MapsForFound / (float)mapList.size());
                        tripleList.add(t);
                        continue;
                    }
                    return tripleList;
                }
                answer.remove(minDist);
            }
            center = mapList.size() / 2;
            minDist = mapList.size();
        }
        if (tripleList.size() == 0) {
            logger.error("NO triples for oracle found! Quitting!");
            logger.error("mapList.size:" + mapList.size());
            int i = 1;
            for (AMapping m : mapList) {
                logger.error(i + ". Mapping size=" + m.size());
            }
            throw new RuntimeException();
        }
        return tripleList;
    }

    public void setKnown(AMapping m) {
        for (String a : m.getMap().keySet()) {
            for (String b : m.getMap().get(a).keySet()) {
                if (a == null || b == null) continue;
                this.retrieved.add(new Triple(a, b, 1.0));
            }
        }
    }

    public class Triple {
        String sourceUri;
        String targetUri;
        double similarity;

        public Triple(String sUri, String tUri, double sim) {
            this.sourceUri = sUri;
            this.targetUri = tUri;
            this.similarity = sim;
        }

        public String getSourceUri() {
            return this.sourceUri;
        }

        public void setSourceUri(String sourceUri) {
            this.sourceUri = sourceUri;
        }

        public String getTargetUri() {
            return this.targetUri;
        }

        public void setTargetUri(String targetUri) {
            this.targetUri = targetUri;
        }

        public double getSimilarity() {
            return this.similarity;
        }

        public void setSimilarity(double similarity) {
            this.similarity = similarity;
        }

        public int hashCode() {
            return this.sourceUri.hashCode() + this.targetUri.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof Triple) {
                Triple t = (Triple)o;
                if (this.sourceUri.equals(t.sourceUri) && this.targetUri.equals(t.targetUri)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            Object s = "";
            s = "<" + this.sourceUri + ">";
            s = (String)s + " <" + this.targetUri + "> ";
            s = (String)s + this.similarity;
            return s;
        }
    }
}

