/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.preprocessing.functions;

import java.util.ArrayList;
import java.util.TreeSet;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.preprocessing.APreprocessingFunction;
import org.aksw.limes.core.io.preprocessing.IPreprocessingFunction;
import org.apache.commons.lang.ArrayUtils;

public class Concat
extends APreprocessingFunction
implements IPreprocessingFunction {
    public static final String GLUE_KEYWORD = "glue=";
    private String resultProperty;
    private String glue;

    @Override
    public Instance applyFunctionAfterCheck(Instance inst, String property, String ... arguments) {
        this.resultProperty = property;
        this.glue = this.retrieveKeywordArgumentValue(arguments[arguments.length - 1], GLUE_KEYWORD);
        if (!this.glue.equals("")) {
            arguments = (String[])ArrayUtils.removeElement((Object[])arguments, (Object)arguments[arguments.length - 1]);
        }
        ArrayList<ArrayList<String>> oldValues = new ArrayList<ArrayList<String>>();
        for (String prop : arguments) {
            ArrayList treeValues = new ArrayList();
            inst.getProperty(prop.trim()).forEach(e -> treeValues.add(e));
            oldValues.add(treeValues);
        }
        ArrayList<String> newValues = Concat.concatElementsInOrder(oldValues, this.glue);
        inst.addProperty(this.resultProperty, new TreeSet<String>(newValues));
        return inst;
    }

    public static ArrayList<String> concatElementsInOrder(ArrayList<ArrayList<String>> toConcatList, String ... glue) {
        ArrayList<String> res = toConcatList.get(0);
        toConcatList.remove(0);
        for (ArrayList<String> toConcat : toConcatList) {
            res = Concat.concatArrayElements(res, toConcat, glue);
        }
        return res;
    }

    public static ArrayList<String> concatArrayElements(ArrayList<String> first, ArrayList<String> toConcat, String ... glue) {
        if (toConcat.isEmpty()) {
            return first;
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String firstPart : first) {
            res.addAll(Concat.concatStringToElements(firstPart, toConcat, glue));
        }
        return res;
    }

    public static ArrayList<String> concatStringToElements(String firstPart, ArrayList<String> toConcat, String ... glue) {
        ArrayList<String> res = new ArrayList<String>();
        for (String secondPart : toConcat) {
            if (glue.length > 0) {
                res.add(firstPart + glue[0] + secondPart);
                continue;
            }
            res.add(firstPart + secondPart);
        }
        return res;
    }

    @Override
    public int minNumberOfArguments() {
        return 2;
    }

    @Override
    public int maxNumberOfArguments() {
        return -1;
    }

    @Override
    public boolean isComplex() {
        return true;
    }
}

