/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine.partialrecallengine.refinement;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.aksw.limes.core.execution.engine.partialrecallengine.refinement.PartialRecallRefinementNode;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.LigerPlanner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.apache.log4j.Logger;

public abstract class PartialRecallRefinementOperator {
    protected static final Logger logger = Logger.getLogger((String)PartialRecallRefinementOperator.class.getName());
    protected PartialRecallRefinementNode root;
    protected PartialRecallRefinementNode best;
    protected double desiredSelectivity = 0.0;
    protected ACache source;
    protected ACache target;
    protected long timeLimit;
    protected double k;
    protected long maxOpt;
    protected List<Double> thresholds = Arrays.asList(0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0);
    protected LinkedList<PartialRecallRefinementNode> buffer = new LinkedList();
    protected HashSet<String> total = new HashSet();

    public double getRecall() {
        return this.k;
    }

    public long getOptimizationTime() {
        return this.maxOpt;
    }

    public PartialRecallRefinementNode getBest() {
        return this.best;
    }

    public double getDesiredSelectivity() {
        return this.desiredSelectivity;
    }

    public PartialRecallRefinementOperator(ACache s, ACache t, double recall, long optTime, LinkSpecification spec) {
        this.source = s;
        this.target = t;
        if (optTime < 0L) {
            logger.info((Object)("\nOptimization time cannot be negative. Your input value is " + optTime + ".\nSetting it to the default value: 0ms."));
            this.maxOpt = 0L;
        } else {
            this.maxOpt = optTime;
        }
        if (recall < 0.0 || recall > 1.0) {
            logger.info((Object)("\nExpected selectivity must be between 0.0 and 1.0. Your input value is " + this.k + ".\nSetting it to the default value: 1.0."));
            this.k = 1.0;
        } else {
            this.k = recall;
        }
        this.init(spec);
    }

    public abstract void optimize();

    protected int checkSelectivity(double selectivity) {
        return Double.compare(selectivity, this.desiredSelectivity);
    }

    protected double next(double currentThreshold) {
        if (currentThreshold < 0.0 || currentThreshold > 1.0) {
            return -1.0;
        }
        if (Double.compare(currentThreshold, 1.0) == 0) {
            return -1.0;
        }
        for (double f : this.thresholds) {
            if (Double.compare(currentThreshold, f) >= 0) continue;
            return f;
        }
        return -1.0;
    }

    protected void init(LinkSpecification spec) {
        if (spec == null) {
            logger.error((Object)"Link Specification is empty, I am going to stop here.");
            throw new RuntimeException();
        }
        LinkSpecification initLSClone = spec.clone();
        LigerPlanner planner = new LigerPlanner(this.source, this.target);
        NestedPlan initPlan = planner.plan(initLSClone);
        this.best = new PartialRecallRefinementNode(initLSClone, initPlan);
        this.desiredSelectivity = initPlan.getSelectivity() * this.k;
        this.buffer.addFirst(this.best);
        this.total.add(this.best.getLinkSpecification().toString());
        this.root = new PartialRecallRefinementNode(spec.clone(), initPlan);
    }
}

