/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyMapping {
    public List<PairSimilar<String>> stringPropPairs = new ArrayList<PairSimilar<String>>();
    public List<PairSimilar<String>> pointsetPropPairs = new ArrayList<PairSimilar<String>>();
    public List<PairSimilar<String>> numberPropPairs = new ArrayList<PairSimilar<String>>();
    public List<PairSimilar<String>> datePropPairs = new ArrayList<PairSimilar<String>>();
    public HashSet<String> sourceStringProps = new HashSet();
    public HashSet<String> targetStringProps = new HashSet();
    public HashSet<String> sourcePointsetProps = new HashSet();
    public HashSet<String> targetPointsetProps = new HashSet();
    public HashSet<String> sourceNumberProps = new HashSet();
    public HashSet<String> targetNumberProps = new HashSet();
    public HashSet<String> sourceDateProps = new HashSet();
    public HashSet<String> targetDateProps = new HashSet();
    Logger logger = LoggerFactory.getLogger((String)"Limes");
    private boolean aMatchWasSet = false;
    private AMapping propMapping = MappingFactory.createDefaultMapping();
    private AMapping numberProps = MappingFactory.createDefaultMapping();
    private AMapping dateProps = MappingFactory.createDefaultMapping();
    private AMapping pointsetProps = MappingFactory.createDefaultMapping();

    public void addStringPropertyMatch(String sourceProp, String targetProp) {
        if (!this.propMapping.contains(sourceProp, targetProp)) {
            this.propMapping.add(sourceProp, targetProp, 1.0);
            this.sourceStringProps.add(sourceProp);
            this.targetStringProps.add(targetProp);
            this.aMatchWasSet = true;
            PairSimilar<String> pair = new PairSimilar<String>(sourceProp, targetProp);
            if (!this.stringPropPairs.contains(pair)) {
                this.stringPropPairs.add(pair);
            }
        }
    }

    public void addNumberPropertyMatch(String sourceProp, String targetProp) {
        if (!this.numberProps.contains(sourceProp, targetProp)) {
            this.numberProps.add(sourceProp, targetProp, 1.0);
            this.sourceNumberProps.add(sourceProp);
            this.targetNumberProps.add(targetProp);
            this.aMatchWasSet = true;
            PairSimilar<String> pair = new PairSimilar<String>(sourceProp, targetProp);
            if (!this.numberPropPairs.contains(pair)) {
                this.numberPropPairs.add(pair);
            }
        }
    }

    public void addDatePropertyMatch(String sourceProp, String targetProp) {
        if (!this.dateProps.contains(sourceProp, targetProp)) {
            this.dateProps.add(sourceProp, targetProp, 1.0);
            this.sourceDateProps.add(sourceProp);
            this.targetDateProps.add(targetProp);
            this.aMatchWasSet = true;
            PairSimilar<String> pair = new PairSimilar<String>(sourceProp, targetProp);
            if (!this.datePropPairs.contains(pair)) {
                this.datePropPairs.add(pair);
            }
        }
    }

    public void addPointsetPropertyMatch(String sourceProp, String targetProp) {
        if (!this.pointsetProps.contains(sourceProp, targetProp)) {
            this.pointsetProps.add(sourceProp, targetProp, 1.0);
            this.sourcePointsetProps.add(sourceProp);
            this.targetPointsetProps.add(targetProp);
            this.aMatchWasSet = true;
            PairSimilar<String> pair = new PairSimilar<String>(sourceProp, targetProp);
            if (!this.pointsetPropPairs.contains(pair)) {
                this.pointsetPropPairs.add(pair);
            }
        }
    }

    public boolean isMatch(String sourceProp, String targetProp) {
        return this.propMapping.contains(sourceProp, targetProp) || this.numberProps.contains(sourceProp, targetProp) || this.dateProps.contains(sourceProp, targetProp) || this.pointsetProps.contains(sourceProp, targetProp);
    }

    public boolean isNumberProp(String name) {
        return this.numberProps.getMap().containsKey(name) || this.numberProps.getMap().containsValue(name);
    }

    public boolean isDateProp(String name) {
        return this.dateProps.getMap().containsKey(name) || this.dateProps.getMap().containsValue(name);
    }

    public boolean isPointsetProp(String name) {
        return this.pointsetProps.getMap().containsKey(name) || this.pointsetProps.getMap().containsValue(name);
    }

    public AMapping getCompletePropMapping() {
        AMapping m = this.propMapping;
        for (String uri1 : this.numberProps.getMap().keySet()) {
            m.add(uri1, this.numberProps.getMap().get(uri1));
        }
        for (String uri1 : this.dateProps.getMap().keySet()) {
            m.add(uri1, this.dateProps.getMap().get(uri1));
        }
        for (String uri1 : this.pointsetProps.getMap().keySet()) {
            m.add(uri1, this.pointsetProps.getMap().get(uri1));
        }
        return m;
    }

    public AMapping getStringPropMapping() {
        return this.propMapping;
    }

    public AMapping getNumberPropMapping() {
        return this.numberProps;
    }

    public AMapping getDatePropMapping() {
        return this.dateProps;
    }

    public AMapping getPointsetPropMapping() {
        return this.pointsetProps;
    }

    public boolean wasSet() {
        return this.aMatchWasSet;
    }

    public String toString() {
        Object out = "STRING\n";
        out = (String)out + this.propMapping.toString();
        out = (String)out + "\nNUMBER\n";
        out = (String)out + this.numberProps.toString();
        out = (String)out + "\nDATE\n";
        out = (String)out + this.dateProps.toString();
        out = (String)out + "\nPOINTSET\n";
        out = (String)out + this.pointsetProps.toString();
        return out;
    }

    public void setDefault(KBInfo source, KBInfo target) {
        if (source.getType() != null && source.getType().equalsIgnoreCase("csv") && target.getType() != null && target.getType().equalsIgnoreCase("csv")) {
            int max = Math.min(source.getProperties().size(), target.getProperties().size());
            for (int i = 0; i < max; ++i) {
                this.addStringPropertyMatch(source.getProperties().get(i), target.getProperties().get(i));
            }
        } else {
            for (int i = 0; i < source.getProperties().size(); ++i) {
                for (int j = 0; j < target.getProperties().size(); ++j) {
                    this.addStringPropertyMatch(source.getProperties().get(i), target.getProperties().get(j));
                }
            }
        }
    }

    public boolean containsSourceProp(String uri) {
        return this.sourceDateProps.contains(uri) || this.sourceNumberProps.contains(uri) || this.sourceStringProps.contains(uri) || this.sourcePointsetProps.contains(uri);
    }

    public boolean containsTargetProp(String uri) {
        return this.targetDateProps.contains(uri) || this.targetNumberProps.contains(uri) || this.targetStringProps.contains(uri) || this.targetPointsetProps.contains(uri);
    }
}

