/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.eagle.genes;

import java.math.BigDecimal;
import org.aksw.limes.core.datastrutures.PairSimilar;
import org.aksw.limes.core.ml.algorithm.eagle.core.ExpressionProblem;
import org.aksw.limes.core.ml.algorithm.eagle.core.LinkSpecGeneticLearnerConfig;
import org.jgap.InvalidConfigurationException;
import org.jgap.gp.CommandGene;
import org.jgap.gp.IGPProgram;
import org.jgap.gp.IMutateable;
import org.jgap.gp.impl.GPConfiguration;
import org.jgap.gp.impl.ProgramChromosome;
import org.jgap.util.CloneException;
import org.jgap.util.ICloneable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NumberMeasure
extends CommandGene
implements IMutateable,
ICloneable {
    private static final long serialVersionUID = -2615468774498850743L;
    static Logger logger = LoggerFactory.getLogger((String)"LIMES");
    private boolean m_mutateable;

    public NumberMeasure(GPConfiguration a_conf, Class<?> a_returnType, int a_subReturnType, boolean a_mutateable) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType, a_subReturnType, new int[]{ExpressionProblem.ResourceTerminalType.NUMBERPROPPAIR.intValue(), ExpressionProblem.ResourceTerminalType.NUMBERTHRESHOLD.intValue()});
        this.m_mutateable = a_mutateable;
        this.setNoValidation(false);
    }

    public NumberMeasure(GPConfiguration a_conf, Class<?> a_returnType, boolean a_mutateable) throws InvalidConfigurationException {
        super(a_conf, 2, a_returnType, 1, new int[]{ExpressionProblem.ResourceTerminalType.NUMBERPROPPAIR.intValue(), ExpressionProblem.ResourceTerminalType.NUMBERTHRESHOLD.intValue()});
        this.m_mutateable = a_mutateable;
        this.setNoValidation(false);
    }

    public NumberMeasure(GPConfiguration a_conf) throws InvalidConfigurationException {
        this(a_conf, String.class, false);
    }

    public CommandGene applyMutation(int a_index, double a_percentage) throws InvalidConfigurationException {
        return this;
    }

    public String toString() {
        return "euclidean(&1)|&2";
    }

    public Class<?> getChildType(IGPProgram a_ind, int a_chromNum) {
        if (a_chromNum == 0) {
            return PairSimilar.class;
        }
        return CommandGene.DoubleClass;
    }

    public Object execute_object(ProgramChromosome a_chrom, int a_n, Object[] args) {
        PairSimilar propPair = (PairSimilar)a_chrom.execute_object(a_n, 0, args);
        double threshold = a_chrom.execute_double(a_n, 1, args);
        LinkSpecGeneticLearnerConfig ExpConfig = (LinkSpecGeneticLearnerConfig)this.getGPConfiguration();
        StringBuffer value = new StringBuffer("euclidean");
        value.append("(");
        value.append(ExpConfig.getExpressionProperty("source", (String)propPair.a));
        value.append(",");
        value.append(ExpConfig.getExpressionProperty("target", (String)propPair.b));
        value.append(")");
        value.append("|");
        value.append(new BigDecimal(threshold).setScale(4, 6));
        return value.toString();
    }

    public void execute_void(ProgramChromosome a_chrom, int a_n, Object[] args) {
        this.execute_object(a_chrom, a_n, args);
    }

    public boolean isValid(ProgramChromosome a_program, int a_index) {
        Object[] o = new Object[]{};
        LinkSpecGeneticLearnerConfig expConfig = (LinkSpecGeneticLearnerConfig)this.getGPConfiguration();
        PairSimilar propPair = (PairSimilar)a_program.execute_object(a_index, 0, o);
        return expConfig.hasNumericProperties() && expConfig.getPropertyMapping().isMatch((String)propPair.a, (String)propPair.b);
    }

    public boolean isValid(ProgramChromosome a_program) {
        return this.isValid(a_program, 0);
    }

    public Object clone() {
        try {
            NumberMeasure result = new NumberMeasure(this.getGPConfiguration(), this.getReturnType(), this.getSubReturnType(), this.m_mutateable);
            return result;
        }
        catch (Throwable t) {
            throw new CloneException(t);
        }
    }
}

