/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.dragon.Pruning;

import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.ml.algorithm.dragon.DecisionTree;
import org.aksw.limes.core.ml.algorithm.dragon.Pruning.PruningFunctionDTL;
import org.aksw.limes.core.ml.algorithm.dragon.Utils.InstanceCalculator;
import org.apache.commons.math3.distribution.NormalDistribution;

public class ErrorEstimatePruning
extends PruningFunctionDTL {
    public static double defaultConfidence = 0.25;

    public static double errorRate(double f, double N, double z) {
        double zPot = Math.pow(z, 2.0);
        double root = Math.sqrt(f / N - Math.pow(f, 2.0) / N + zPot / (4.0 * Math.pow(N, 2.0)));
        double counter = f + zPot / (2.0 * N) + z * root;
        double denominator = 1.0 + zPot / N;
        double error = counter / denominator;
        return error;
    }

    public static void main(String[] args) {
        System.out.println();
    }

    @Override
    public DecisionTree pruneChildNodesIfNecessary(DecisionTree node) {
        AMapping leftMapping = null;
        leftMapping = node.isRoot() ? MappingOperations.difference(node.getRefMapping(), node.getClassifier().getMapping()) : MappingOperations.difference(node.getParent().getClassifier().getMapping(), node.getClassifier().getMapping());
        if (node.getLeftChild() != null && this.pruneChild(node.getLeftChild(), leftMapping)) {
            node.setLeftChild(null);
        }
        if (node.getRightChild() != null && this.pruneChild(node.getRightChild(), node.getClassifier().getMapping())) {
            node.setLeftChild(null);
        }
        return node;
    }

    public boolean pruneChild(DecisionTree node, AMapping parent) {
        double combinedError;
        AMapping leftMapping = MappingOperations.difference(parent, node.getClassifier().getMapping());
        double[] posNegLeft = InstanceCalculator.getNumberOfPositiveNegativeInstances(leftMapping);
        double[] posNegRight = InstanceCalculator.getNumberOfPositiveNegativeInstances(node.getClassifier().getMapping());
        double[] posNegParent = InstanceCalculator.getNumberOfPositiveNegativeInstances(parent);
        double leftWeight = posNegLeft[0] + posNegLeft[1];
        double rightWeight = posNegRight[0] + posNegRight[1];
        double rightErrorRate = this.getErrorRate(posNegRight, node.getPruningConfidence());
        double leftErrorRate = this.getErrorRate(posNegLeft, node.getPruningConfidence());
        double parentError = this.getErrorRate(posNegParent, node.getPruningConfidence());
        return parentError < (combinedError = (leftWeight * leftErrorRate + rightWeight * rightErrorRate) / (leftWeight + rightWeight));
    }

    private double getErrorRate(double[] posNeg, double confidence) {
        double z = 0.0;
        z = confidence == defaultConfidence ? 0.69 : new NormalDistribution(0.0, 1.0).inverseCumulativeProbability(1.0 - confidence);
        double f = -1.0;
        double N = posNeg[0] + posNeg[1];
        f = posNeg[0] > posNeg[1] ? posNeg[1] / N : posNeg[0] / N;
        double nodeErrorRate = ErrorEstimatePruning.errorRate(f, N, z);
        return nodeErrorRate;
    }
}

