/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.ml.algorithm.dragon;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.qualititativeMeasures.FMeasure;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.ExecutionEngineFactory;
import org.aksw.limes.core.execution.engine.SimpleExecutionEngine;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.Plan;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.MappingOperations;
import org.aksw.limes.core.ml.algorithm.classifier.ExtendedClassifier;
import org.aksw.limes.core.ml.algorithm.dragon.Dragon;
import org.aksw.limes.core.ml.algorithm.dragon.FitnessFunctions.FitnessFunctionDTL;
import org.aksw.limes.core.ml.algorithm.dragon.Pruning.PruningFunctionDTL;
import org.aksw.limes.core.ml.algorithm.eagle.util.PropertyMapping;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecisionTree {
    protected static Logger logger = LoggerFactory.getLogger(DecisionTree.class);
    private final Dragon dtl;
    private static Map<String, AMapping> calculatedMappings = new HashMap<String, AMapping>();
    private static Map<String, AMapping> pathMappings = new HashMap<String, AMapping>();
    public static double totalFMeasure = 0.0;
    public static int maxDepth = 0;
    private static String spaceChar = "\ufe34";
    private static final String delimiter = "\u00a7";
    private final ACache sourceCache;
    private final ACache targetCache;
    private ExtendedClassifier classifier;
    private DecisionTree parent;
    private DecisionTree leftChild;
    private DecisionTree rightChild;
    private boolean root = false;
    private boolean isLeftNode = false;
    private final PseudoFMeasure pseudoFMeasure;
    private int depth;
    private final double minPropertyCoverage;
    private final double propertyLearningRate;
    private double pruningConfidence;
    private AMapping refMapping;
    public static FitnessFunctionDTL fitnessFunction;
    public static PruningFunctionDTL pruningFunction;
    private PropertyMapping propertyMapping;

    public DecisionTree(Dragon dtl, ACache sourceCache, ACache targetCache, PseudoFMeasure pseudoFMeasure, double minPropertyCoverage, double propertyLearningRate, double pruningConfidence, AMapping refMapping, PropertyMapping propertyMapping) {
        calculatedMappings = new HashMap<String, AMapping>();
        pathMappings = new HashMap<String, AMapping>();
        totalFMeasure = 0.0;
        this.dtl = dtl;
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
        this.pseudoFMeasure = pseudoFMeasure;
        this.minPropertyCoverage = minPropertyCoverage;
        this.propertyLearningRate = propertyLearningRate;
        this.pruningConfidence = pruningConfidence;
        this.root = true;
        this.depth = 0;
        this.refMapping = refMapping;
        this.propertyMapping = propertyMapping;
    }

    private DecisionTree(Dragon dtl, ACache sourceCache, ACache targetCache, PseudoFMeasure pseudoFMeasure, double minPropertyCoverage, double pruningConfidence, double propertyLearningRate, DecisionTree parent, boolean isLeftNode, AMapping refMapping, PropertyMapping propertyMapping) {
        this.dtl = dtl;
        this.sourceCache = sourceCache;
        this.targetCache = targetCache;
        this.pseudoFMeasure = pseudoFMeasure;
        this.minPropertyCoverage = minPropertyCoverage;
        this.propertyLearningRate = propertyLearningRate;
        this.pruningConfidence = pruningConfidence;
        this.parent = parent;
        this.isLeftNode = isLeftNode;
        this.root = false;
        if (parent != null) {
            this.depth = this.parent.depth + 1;
        }
        this.refMapping = refMapping;
        this.propertyMapping = propertyMapping;
    }

    public DecisionTree buildTree(int maxDepth) {
        this.classifier = fitnessFunction.getBestClassifier(this);
        if (this.classifier == null) {
            return null;
        }
        if (this.root) {
            totalFMeasure = this.classifier.getfMeasure();
        } else if (fitnessFunction.stopCondition(this)) {
            return null;
        }
        if (maxDepth != this.depth && this.depth < this.propertyMapping.getCompletePropMapping().size()) {
            this.rightChild = new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, this, false, this.refMapping, this.propertyMapping);
            this.rightChild = this.rightChild.buildTree(maxDepth);
            this.leftChild = new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, this, true, this.refMapping, this.propertyMapping);
            this.leftChild = this.leftChild.buildTree(maxDepth);
        }
        return this;
    }

    public DecisionTree prune() {
        for (int currentDepth = maxDepth; currentDepth >= 0; --currentDepth) {
            this.getRootNode().prune(currentDepth);
        }
        return this;
    }

    private DecisionTree prune(int depth) {
        if (this.rightChild == null && this.leftChild == null) {
            return this;
        }
        if (this.rightChild != null) {
            this.rightChild.prune(depth);
        }
        if (this.leftChild != null) {
            this.leftChild.prune(depth);
        }
        if (this.depth != depth) {
            return this;
        }
        return pruningFunction.pruneChildNodesIfNecessary(this);
    }

    private DecisionTree getRootNode() {
        if (!this.root) {
            if (this.parent == null) {
                logger.error("Detached node!Cannot get root! Returning null!");
                return null;
            }
            return this.parent.getRootNode();
        }
        return this;
    }

    public AMapping getTotalMapping() {
        DecisionTree rootNode = this.getRootNode();
        List<String> pathStrings = this.calculatePathMappings(rootNode);
        if (rootNode != null) assert (pathStrings.size() > 0);
        AMapping res = MappingFactory.createDefaultMapping();
        Iterator<String> it = pathMappings.keySet().iterator();
        while (it.hasNext()) {
            String s = it.next();
            if (!pathStrings.contains(s)) {
                it.remove();
                continue;
            }
            res = MappingOperations.union(pathMappings.get(s), res);
        }
        return res;
    }

    private List<String> calculatePathKeys(DecisionTree node, List<String> pathStrings) {
        if (pathStrings == null) {
            pathStrings = new ArrayList<String>();
        }
        if (node.rightChild == null && node.leftChild == null) {
            if (node.root) {
                String path = node.getPathString();
                if (!pathStrings.contains(path)) {
                    pathStrings.add(path);
                }
            } else {
                String path = node.getPathString();
                if (!pathStrings.contains(path)) {
                    pathStrings.add(path);
                }
            }
        } else if (node.rightChild != null && node.leftChild == null) {
            this.calculatePathKeys(node.rightChild, pathStrings);
        } else if (node.leftChild != null && node.rightChild == null) {
            String path = node.getPathString();
            if (!pathStrings.contains(path)) {
                pathStrings.add(path);
            }
            this.calculatePathKeys(node.leftChild, pathStrings);
        } else {
            this.calculatePathKeys(node.rightChild, pathStrings);
            this.calculatePathKeys(node.leftChild, pathStrings);
        }
        return pathStrings;
    }

    private List<String> calculatePathMappings(DecisionTree node) {
        ArrayList<String> pathStrings = new ArrayList<String>();
        if (node.rightChild == null && node.leftChild == null) {
            if (node.root) {
                AMapping res = node.classifier.getMapping();
                String path = node.getPathString();
                if (!pathMappings.keySet().contains(path)) {
                    pathMappings.put(path, res);
                }
                pathStrings.add(path);
            } else {
                String path = node.getPathString();
                if (!pathMappings.keySet().contains(path)) {
                    pathMappings.put(path, node.getPathMapping());
                }
                pathStrings.add(path);
            }
        } else if (node.rightChild != null && node.leftChild == null) {
            pathStrings.addAll(this.calculatePathMappings(node.rightChild));
        } else if (node.leftChild != null && node.rightChild == null) {
            String path = node.getPathString();
            if (!pathMappings.keySet().contains(path)) {
                pathMappings.put(path, node.getPathMapping());
            }
            pathStrings.add(path);
            pathStrings.addAll(this.calculatePathMappings(node.leftChild));
        } else {
            pathStrings.addAll(this.calculatePathMappings(node.rightChild));
            pathStrings.addAll(this.calculatePathMappings(node.leftChild));
        }
        return pathStrings;
    }

    public AMapping getPathMapping() {
        if (this.root) {
            return this.classifier.getMapping();
        }
        AMapping parentMapping = this.parent.getPathMapping();
        AMapping nodeMapping = this.classifier.getMapping();
        AMapping res = null;
        res = this.isLeftNode ? MappingOperations.difference(nodeMapping, parentMapping) : MappingOperations.intersection(nodeMapping, parentMapping);
        return res;
    }

    public String getPathString() {
        String str = "" + this.depth;
        if (this.root) {
            if (this.classifier.getMetricExpression() != null && !this.classifier.getMetricExpression().equals("")) {
                str = str + spaceChar + this.classifier.getMetricExpression();
            }
        } else {
            str = this.isLeftNode ? str + "left" : str + "right";
            str = str + this.parent.getPathString() + spaceChar + "\u00b3" + this.isLeftNode + "\u00b3" + this.classifier.getMetricExpression();
        }
        return str;
    }

    public LinkSpecification getTotalLS() {
        List<String> paths = this.calculatePathKeys(this.getRootNode(), null);
        String left = "\u00b3true\u00b3";
        String right = "\u00b3false\u00b3";
        String[] pathLS = new String[paths.size()];
        int countPathLS = 0;
        for (String s : paths) {
            double outerThreshold = 0.0;
            String[] path = s.split(spaceChar);
            Object lsString = "";
            for (int i = 1; i < path.length; ++i) {
                if (path[i].startsWith("\u00b3true\u00b3")) {
                    lsString = "MINUS(" + path[i] + "," + (String)lsString + ")";
                    lsString = (String)lsString + "|0.0";
                    continue;
                }
                if (path[i].startsWith("\u00b3false\u00b3")) {
                    lsString = "AND(" + path[i] + "," + (String)lsString + ")";
                    lsString = (String)lsString + "|0.0";
                    continue;
                }
                if (((String)lsString).equals("")) {
                    if (path.length == 2 && path[i].contains("|")) {
                        outerThreshold = Double.parseDouble(path[i].split("\\|")[1]);
                    }
                    lsString = path[i];
                    continue;
                }
                lsString = path[i + 1].startsWith("\u00b3false\u00b3") ? "AND(" + path[i + 1] + "," + path[i] + ")" : "MINUS(" + path[i + 1] + "," + path[i] + ")";
            }
            lsString = ((String)lsString).replaceAll("\u00b3true\u00b3", "");
            lsString = ((String)lsString).replaceAll("\u00b3false\u00b3", "");
            pathLS[countPathLS] = lsString = (String)lsString + "|" + outerThreshold;
            ++countPathLS;
        }
        Object finalLSString = "";
        LinkSpecification finalLS = null;
        if (pathLS.length == 1) {
            int index = pathLS[0].lastIndexOf("|");
            String[] lsStringArr = new String[]{pathLS[0].substring(0, index), pathLS[0].substring(index + 1)};
            return new LinkSpecification(lsStringArr[0], Double.parseDouble(lsStringArr[1]));
        }
        for (int i = 0; i < pathLS.length; ++i) {
            if (i == 0) {
                finalLSString = (String)finalLSString + "OR(" + pathLS[i] + "," + pathLS[i + 1] + ")";
                ++i;
            } else {
                finalLSString = "OR(" + (String)finalLSString + "," + pathLS[i] + ")";
            }
            if (i == pathLS.length - 1) {
                finalLS = new LinkSpecification((String)finalLSString, 0.0);
                continue;
            }
            finalLSString = (String)finalLSString + "|0.0";
        }
        return finalLS;
    }

    public DecisionTree clone() {
        DecisionTree cloned = null;
        if (this.root) {
            cloned = new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, this.refMapping, this.propertyMapping);
            cloned.classifier = new ExtendedClassifier(this.classifier.getMeasure(), this.classifier.getThreshold(), this.classifier.getSourceProperty(), this.classifier.getTargetProperty());
            cloned.depth = this.depth;
            if (this.rightChild != null) {
                cloned.rightChild = this.rightChild.cloneWithoutParent();
            }
            if (this.leftChild != null) {
                cloned.leftChild = this.leftChild.cloneWithoutParent();
            }
        } else {
            DecisionTree parentClone = this.parent.cloneWithoutChild(this.isLeftNode);
            cloned = this.cloneWithoutParent();
            if (this.isLeftNode) {
                parentClone.leftChild = cloned;
                if (this.parent.rightChild != null) {
                    parentClone.rightChild = this.parent.rightChild.cloneWithoutParent();
                }
            } else {
                parentClone.rightChild = cloned;
                if (this.parent.leftChild != null) {
                    parentClone.leftChild = this.parent.leftChild.cloneWithoutParent();
                }
            }
        }
        return cloned;
    }

    protected DecisionTree cloneWithoutParent() {
        DecisionTree cloned = null;
        cloned = this.root ? new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, this.refMapping, this.propertyMapping) : new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, null, this.isLeftNode, this.refMapping, this.propertyMapping);
        cloned.classifier = new ExtendedClassifier(this.classifier.getMeasure(), this.classifier.getThreshold(), this.classifier.getSourceProperty(), this.classifier.getTargetProperty());
        cloned.depth = this.depth;
        if (this.leftChild != null) {
            DecisionTree leftClone = this.leftChild.cloneWithoutParent();
            leftClone.parent = cloned;
            cloned.leftChild = leftClone;
        }
        if (this.rightChild != null) {
            DecisionTree rightClone = this.rightChild.cloneWithoutParent();
            rightClone.parent = cloned;
            cloned.rightChild = rightClone;
        }
        return cloned;
    }

    protected DecisionTree cloneWithoutChild(boolean withoutLeft) {
        DecisionTree cloned = null;
        DecisionTree parentClone = null;
        if (this.parent != null) {
            parentClone = this.parent.cloneWithoutChild(this.isLeftNode);
        }
        cloned = this.root ? new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, this.refMapping, this.propertyMapping) : new DecisionTree(this.dtl, this.sourceCache, this.targetCache, this.pseudoFMeasure, this.minPropertyCoverage, this.pruningConfidence, this.propertyLearningRate, parentClone, this.isLeftNode, this.refMapping, this.propertyMapping);
        cloned.classifier = new ExtendedClassifier(this.classifier.getMeasure(), this.classifier.getThreshold());
        cloned.depth = this.depth;
        if (parentClone != null) {
            if (this.isLeftNode) {
                parentClone.leftChild = cloned;
                parentClone.rightChild = this.parent.rightChild.cloneWithoutParent();
            } else {
                parentClone.rightChild = cloned;
                parentClone.leftChild = this.parent.leftChild.cloneWithoutParent();
            }
        }
        return cloned;
    }

    public double calculateFMeasure(AMapping mapping, AMapping refMap) {
        double res = 0.0;
        GoldStandard gs = new GoldStandard(refMap, this.dtl.getTestSourceCache().getAllUris(), this.dtl.getTestTargetCache().getAllUris());
        FMeasure fm = new FMeasure();
        res = fm.calculate(mapping, gs);
        return res;
    }

    public AMapping getMeasureMapping(String measureExpression, ExtendedClassifier cp) {
        if (this.root) {
            AMapping mapping = this.executeAtomicMeasure(measureExpression, cp.getThreshold());
            calculatedMappings.put(cp.getMetricExpression(), mapping);
            return mapping;
        }
        this.classifier = cp;
        AMapping classifierMapping = calculatedMappings.get(cp.getMetricExpression());
        if (classifierMapping == null) {
            classifierMapping = this.executeAtomicMeasure(measureExpression, cp.getThreshold());
            calculatedMappings.put(cp.getMetricExpression(), classifierMapping);
        }
        this.classifier.setMapping(classifierMapping);
        return this.getTotalMapping();
    }

    public AMapping executeAtomicMeasure(String measureExpression, double threshold) {
        Instruction inst = new Instruction(Instruction.Command.RUN, measureExpression, "" + threshold, -1, -1, -1);
        ExecutionEngine ee = ExecutionEngineFactory.getEngine(ExecutionEngineFactory.ExecutionEngineType.DEFAULT, this.sourceCache, this.targetCache, "?x", "?y", 0L, 1.0);
        Plan plan = new Plan();
        plan.addInstruction(inst);
        return ((SimpleExecutionEngine)ee).executeInstructions(plan);
    }

    public String toStringOneLine() {
        Object res = "";
        if (this.classifier != null) {
            res = (String)res + this.classifier.getMeasure() + delimiter + this.classifier.getSourceProperty() + "|" + this.classifier.getTargetProperty() + ": <= " + this.classifier.getThreshold() + ", > " + this.classifier.getThreshold() + "[";
            res = this.leftChild != null ? (String)res + this.leftChild.toString() : (String)res + "negative (0)";
            res = (String)res + "][";
            res = this.rightChild != null ? (String)res + this.rightChild.toString() : (String)res + "positive (0)";
            res = (String)res + "]";
        } else {
            res = (String)res + "Classifier not set yet";
        }
        return res;
    }

    public String toString() {
        Object res = "\n";
        res = (String)res + new String(new char[this.depth]).replace("\u0000", "\t");
        if (this.classifier != null) {
            res = (String)res + this.classifier.getMeasure() + delimiter + this.classifier.getSourceProperty() + "|" + this.classifier.getTargetProperty() + ": <= " + this.classifier.getThreshold() + ", > " + this.classifier.getThreshold() + "[";
            res = this.leftChild != null ? (String)res + this.leftChild.toString() : (String)res + "negative (0)";
            res = (String)res + "][";
            res = this.rightChild != null ? (String)res + this.rightChild.toString() : (String)res + "positive (0)";
            res = (String)res + "]";
        } else {
            res = (String)res + "Classifier not set yet";
        }
        return res;
    }

    public void setRefMapping(AMapping refMapping) {
        this.refMapping = refMapping;
    }

    public AMapping getRefMapping() {
        return this.refMapping;
    }

    public double getMinPropertyCoverage() {
        return this.minPropertyCoverage;
    }

    public double getPropertyLearningRate() {
        return this.propertyLearningRate;
    }

    public ACache getSourceCache() {
        return this.sourceCache;
    }

    public ACache getTargetCache() {
        return this.targetCache;
    }

    public ExtendedClassifier getClassifier() {
        return this.classifier;
    }

    public void setClassifier(ExtendedClassifier classifier) {
        this.classifier = classifier;
    }

    public DecisionTree getParent() {
        return this.parent;
    }

    public Dragon getDtl() {
        return this.dtl;
    }

    public boolean isLeftNode() {
        return this.isLeftNode;
    }

    public boolean isRoot() {
        return this.root;
    }

    public DecisionTree getLeftChild() {
        return this.leftChild;
    }

    public void setLeftChild(DecisionTree leftChild) {
        this.leftChild = leftChild;
    }

    public DecisionTree getRightChild() {
        return this.rightChild;
    }

    public void setRightChild(DecisionTree rightChild) {
        this.rightChild = rightChild;
    }

    public void setParent(DecisionTree parent) {
        this.parent = parent;
    }

    public double getPruningConfidence() {
        return this.pruningConfidence;
    }

    public void setPruningConfidence(double pruningConfidence) {
        this.pruningConfidence = pruningConfidence;
    }

    public PropertyMapping getPropertyMapping() {
        return this.propertyMapping;
    }

    public void setPropertyMapping(PropertyMapping propertyMapping) {
        this.propertyMapping = propertyMapping;
    }
}

