/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.string;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.measures.measure.string.StringMeasure;

public class JaroMeasure
extends StringMeasure {
    public static int getTranspositions(List<Character> source, List<Character> target) {
        if (source.isEmpty() || target.isEmpty() || source.size() != target.size()) {
            return -1;
        }
        int transpositions = 0;
        for (int i = 0; i < source.size(); ++i) {
            if (source.get(i).equals(target.get(i))) continue;
            ++transpositions;
        }
        transpositions = (int)((float)transpositions / 2.0f);
        return transpositions;
    }

    public static List<Character> getCommonCharacters(String string1, String string2, int distanceSep) {
        ArrayList<Character> returnCommons = new ArrayList<Character>();
        char[] copy = string2.toCharArray();
        int n = string1.length();
        int m = string2.length();
        for (int i = 0; i < n; ++i) {
            char ch = string1.charAt(i);
            boolean foundIt = false;
            for (int j = Math.max(0, i - distanceSep); !foundIt && j < Math.min(i + distanceSep, m); ++j) {
                if (copy[j] != ch) continue;
                foundIt = true;
                returnCommons.add(Character.valueOf(ch));
                copy[j] = '\u0000';
            }
        }
        return returnCommons;
    }

    public float getSimilarity(String string1, String string2) {
        List<Character> common2;
        int halflen = Math.min(string1.length(), string2.length()) / 2;
        List<Character> common1 = JaroMeasure.getCommonCharacters(string1, string2, halflen);
        int transpositions = JaroMeasure.getTranspositions(common1, common2 = JaroMeasure.getCommonCharacters(string2, string1, halflen));
        if (transpositions == -1) {
            return 0.0f;
        }
        return ((float)common1.size() / (float)string1.length() + (float)common2.size() / (float)string2.length() + (float)(common1.size() - transpositions) / (float)common1.size()) / 3.0f;
    }

    @Override
    public double getSimilarity(Object object1, Object object2) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public String getType() {
        return "string";
    }

    @Override
    public double getSimilarity(Instance instance1, Instance instance2, String property1, String property2) {
        double max = 0.0;
        double sim = 0.0;
        for (String source : instance1.getProperty(property1)) {
            for (String target : instance2.getProperty(property2)) {
                sim = this.getSimilarity(source, target);
                if (!(sim > max)) continue;
                max = sim;
            }
        }
        return max;
    }

    @Override
    public String getName() {
        return "jaro";
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public int getPrefixLength(int tokensNumber, double threshold) {
        return 0;
    }

    @Override
    public int getMidLength(int tokensNumber, double threshold) {
        return 0;
    }

    @Override
    public double getSizeFilteringThreshold(int tokensNumber, double threshold) {
        return 0.0;
    }

    @Override
    public int getAlpha(int xTokensNumber, int yTokensNumber, double threshold) {
        return 0;
    }

    @Override
    public double getSimilarity(int overlap, int lengthA, int lengthB) {
        return 0.0;
    }

    @Override
    public boolean computableViaOverlap() {
        return false;
    }
}

