/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.measures.mapper.pointsets.GeoIndex;
import org.aksw.limes.core.measures.mapper.pointsets.GeoSquare;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PolygonIndex;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.aksw.limes.core.measures.measure.pointsets.IPointsetsMeasure;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.CentroidIndexedHausdorffMeasure;
import org.aksw.limes.core.measures.measure.pointsets.hausdorff.IndexedHausdorffMeasure;

public class GeoHR3 {
    public static boolean threshold = false;
    public static double DEFAULT_THRESHOLD = 1.0;
    public static int DEFAULT_GRANULARITY = 4;
    public static float delta;
    public boolean HR3;
    public IPointsetsMeasure setMeasure;
    public boolean verbose = false;
    public long indexingTime;
    protected int granularity;
    protected float angularThreshold;
    protected float distanceThreshold;
    int latMax;
    int latMin;
    int longMax;
    int longMin;

    public GeoHR3(float distanceThreshold, int granularity, MeasureType hd) {
        this.distanceThreshold = distanceThreshold;
        this.angularThreshold = (float)((double)(distanceThreshold * 180.0f) / (Math.PI * OrthodromicDistance.R));
        this.granularity = granularity;
        this.HR3 = true;
        if (distanceThreshold == 0.0f) {
            this.angularThreshold = (float)(0.18 / (Math.PI * OrthodromicDistance.R));
        }
        delta = this.angularThreshold / (float)granularity;
        this.latMax = (int)Math.floor(90.0f / delta) - 1;
        this.latMin = (int)Math.floor(-90.0f / delta);
        this.longMax = (int)Math.floor(180.0f / delta) - 1;
        this.longMin = (int)Math.floor(-180.0f / delta);
        this.setMeasure = (IPointsetsMeasure)((Object)MeasureFactory.createMeasure(hd));
    }

    public GeoIndex assignSquares(Set<Polygon> input) {
        GeoIndex index = new GeoIndex();
        for (Polygon p : input) {
            for (Point x : p.points) {
                int latIndex = (int)Math.floor(x.coordinates.get(0) / (double)delta);
                int longIndex = (int)Math.floor(x.coordinates.get(1) / (double)delta);
                if (this.verbose) {
                    System.out.println(p.uri + ": (" + latIndex + "," + longIndex + ")");
                }
                index.addPolygon(p, latIndex, longIndex);
            }
        }
        return index;
    }

    public Set<List<Integer>> getSquaresToCompare(int latIndex, int longIndex, GeoIndex index) {
        HashSet<List<Integer>> toCompare = new HashSet<List<Integer>>();
        for (int deltaLat = -1 * this.granularity; deltaLat <= this.granularity; ++deltaLat) {
            int deltaLong;
            int polarCross;
            int realLat;
            int lat = latIndex + deltaLat;
            if (lat > this.latMax) {
                realLat = 2 * this.latMax - lat;
                polarCross = -1;
            } else if (lat < this.latMin) {
                realLat = 2 * this.latMin - lat;
                polarCross = -1;
            } else {
                realLat = lat;
                polarCross = 1;
            }
            if (realLat == this.latMax || realLat == this.latMin) {
                for (deltaLong = this.longMin; deltaLong <= this.longMax; ++deltaLong) {
                    if (index.getSquare(realLat, deltaLong).size() <= 0L) continue;
                    toCompare.add(Arrays.asList(realLat, deltaLong));
                }
                continue;
            }
            int localGranularity = realLat < 0 ? (int)Math.ceil((double)this.granularity / Math.cos((double)((float)Math.abs(realLat) * delta) * Math.PI / 180.0)) : (int)Math.ceil((double)this.granularity / Math.cos((double)((float)(Math.abs(realLat) + 1) * delta) * Math.PI / 180.0));
            int lon = polarCross < 0 ? -1 - longIndex : longIndex;
            for (deltaLong = -1 * localGranularity; deltaLong <= localGranularity; ++deltaLong) {
                int realLong = deltaLong + lon;
                if (realLong > this.longMax) {
                    realLong -= 2 * (this.longMax + 1);
                } else if (realLong < -1 * (this.longMax + 1)) {
                    realLong = 2 * (this.longMax + 1) + realLong;
                }
                toCompare.add(Arrays.asList(realLat, realLong));
            }
        }
        if (this.HR3) {
            HashSet<List<Integer>> result = new HashSet<List<Integer>>();
            for (List list : toCompare) {
                double d;
                double long2;
                double long1;
                double lat2;
                double lat1;
                if (latIndex == (Integer)list.get(0) && longIndex == (Integer)list.get(1)) {
                    result.add(list);
                    continue;
                }
                if (latIndex == this.latMin && (Integer)list.get(0) == this.latMin || latIndex == this.latMax && (Integer)list.get(0) == this.latMax) {
                    result.add(list);
                    continue;
                }
                if ((Integer)list.get(0) > latIndex) {
                    lat1 = latIndex + 1;
                    lat2 = ((Integer)list.get(0)).intValue();
                } else if ((Integer)list.get(0) < latIndex) {
                    lat1 = latIndex;
                    lat2 = (Integer)list.get(0) + 1;
                } else {
                    lat1 = latIndex;
                    lat2 = ((Integer)list.get(0)).intValue();
                }
                if ((Integer)list.get(1) > longIndex) {
                    long1 = longIndex + 1;
                    long2 = ((Integer)list.get(1)).intValue();
                } else if ((Integer)list.get(1) < longIndex) {
                    long1 = longIndex;
                    long2 = (Integer)list.get(1) + 1;
                } else {
                    long1 = longIndex;
                    long2 = ((Integer)list.get(1)).intValue();
                }
                if (!((d = OrthodromicDistance.getDistanceInDegrees(lat1 *= (double)delta, long1 *= (double)delta, lat2 *= (double)delta, long2 *= (double)delta)) <= (double)this.distanceThreshold)) continue;
                result.add(list);
            }
            if (this.verbose) {
                System.out.println("HR3: (" + latIndex + "," + longIndex + ") => " + result);
            }
            return result;
        }
        if (this.verbose) {
            System.out.println("NoHR3: (" + latIndex + "," + longIndex + ") => " + toCompare);
        }
        return toCompare;
    }

    public AMapping run(Set<Polygon> sourceData, Set<Polygon> targetData) {
        long begin = System.currentTimeMillis();
        GeoIndex source = this.assignSquares(sourceData);
        GeoIndex target = this.assignSquares(targetData);
        long end = System.currentTimeMillis();
        HashMap computed = new HashMap();
        this.indexingTime = end - begin;
        if (this.verbose) {
            System.out.println("Geo-Indexing took: " + this.indexingTime + " ms");
            System.out.println("|Source squares|= " + source.squares.keySet().size());
            System.out.println("|Target squares|= " + target.squares.keySet().size());
            System.out.println("Distance Threshold = " + this.distanceThreshold);
            System.out.println("Angular Threshold = " + this.angularThreshold);
            System.out.println("Index = " + source);
        }
        AMapping m = MappingFactory.createDefaultMapping();
        if (this.setMeasure instanceof CentroidIndexedHausdorffMeasure) {
            ((CentroidIndexedHausdorffMeasure)this.setMeasure).computeIndexes(sourceData, targetData);
        } else if (this.setMeasure instanceof IndexedHausdorffMeasure) {
            PolygonIndex targetIndex = new PolygonIndex();
            targetIndex.index(targetData);
            ((IndexedHausdorffMeasure)this.setMeasure).targetIndex = targetIndex;
        }
        for (Integer latIndex : source.squares.keySet()) {
            for (Integer longIndex : source.squares.get(latIndex).keySet()) {
                GeoSquare g1 = source.getSquare(latIndex, longIndex);
                Set<List<Integer>> squares = this.getSquaresToCompare(latIndex, longIndex, target);
                for (List<Integer> squareIndex : squares) {
                    GeoSquare g2 = target.getSquare(squareIndex.get(0), squareIndex.get(1));
                    for (Polygon a : g1.elements) {
                        for (Polygon b : g2.elements) {
                            double d;
                            if (!computed.containsKey(a.uri)) {
                                computed.put(a.uri, new HashSet());
                            }
                            if (!((Set)computed.get(a.uri)).contains(b.uri) && (d = this.setMeasure.computeDistance(a, b, this.distanceThreshold)) <= (double)this.distanceThreshold) {
                                m.add(a.uri, b.uri, 1.0 / (1.0 + d));
                            }
                            ((Set)computed.get(a.uri)).add(b.uri);
                        }
                    }
                }
            }
        }
        return m;
    }
}

