/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.query;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfig;
import org.aksw.commons.io.cache.AdvancedRangeCacheConfigImpl;
import org.aksw.commons.io.util.PathUtils;
import org.aksw.commons.io.util.UriToPathUtils;
import org.aksw.jena_sparql_api.cache.advanced.QueryExecutionFactoryRangeCache;
import org.aksw.jena_sparql_api.core.FluentQueryExecutionFactory;
import org.aksw.jena_sparql_api.core.SparqlServiceReference;
import org.aksw.jena_sparql_api.pagination.core.QueryExecutionFactoryPaginated;
import org.aksw.jenax.arq.connection.core.QueryExecutionFactory;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.SparqlQueryModule;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.QuerySolution;
import org.apache.jena.query.ResultSet;
import org.apache.jena.sparql.core.DatasetDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResilientSparqlQueryModule
extends SparqlQueryModule
implements IQueryModule {
    protected Logger logger = LoggerFactory.getLogger(ResilientSparqlQueryModule.class);
    protected int retryCount = 5;
    protected int retryDelayInMS = 500;
    protected int requestDelayInMs = 50;
    protected int pageSize = 900;
    protected long timeToLive = 86400000L;
    protected String cacheDirectory = System.getProperty("user.dir") + "/cache";

    public ResilientSparqlQueryModule(KBInfo kbInfo) {
        super(kbInfo);
    }

    public ResilientSparqlQueryModule(KBInfo kbinfo, Logger logger, int retryCount, int retryDelayInMS, int requestDelayInMs, int pageSize, long timeToLive, String cacheDirectory) {
        super(kbinfo);
        this.logger = logger;
        this.retryCount = retryCount;
        this.retryDelayInMS = retryDelayInMS;
        this.requestDelayInMs = requestDelayInMs;
        this.pageSize = pageSize;
        this.timeToLive = timeToLive;
        this.cacheDirectory = cacheDirectory;
    }

    @Override
    public void fillCache(ACache cache, boolean sparql) {
        long startTime = System.currentTimeMillis();
        String queryStr = this.generateQuery();
        Query query = QueryFactory.create((String)queryStr);
        this.logger.info("Querying the endpoint.");
        QueryExecutionFactory qef = null;
        try {
            qef = this.initQueryExecution(this.kb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        QueryExecution qe = qef.createQueryExecution(query);
        int counter = 0;
        ResultSet results = qe.execSelect();
        while (results.hasNext()) {
            QuerySolution soln = results.nextSolution();
            try {
                String value;
                String uri = soln.get(this.kb.getVar().substring(1)).toString();
                int i = 1;
                for (String propertyLabel : this.kb.getProperties()) {
                    if (soln.contains("v" + i)) {
                        value = soln.get("v" + i).toString();
                        cache.addTriple(uri, propertyLabel, value);
                    }
                    ++i;
                }
                if (this.kb.getOptionalProperties() != null) {
                    for (String propertyLabel : this.kb.getOptionalProperties()) {
                        if (!soln.contains("v" + i)) continue;
                        value = soln.get("v" + i).toString();
                        cache.addTriple(uri, propertyLabel, value);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.warn("Error while processing: " + soln.toString());
                this.logger.warn("Following exception occured: " + e.getMessage());
                e.printStackTrace();
                throw new RuntimeException();
            }
            ++counter;
        }
        this.logger.info("Retrieved " + counter + " triples and " + cache.size() + " entities.");
        this.logger.info("Retrieving statements took " + (double)(System.currentTimeMillis() - startTime) / 1000.0 + " seconds.");
    }

    protected QueryExecutionFactory initQueryExecution(KBInfo kbInfo) throws ClassNotFoundException, SQLException {
        DatasetDescription dd = new DatasetDescription();
        if (kbInfo.getGraph() != null) {
            dd.addDefaultGraphURI(kbInfo.getGraph());
        }
        SparqlServiceReference ssr = new SparqlServiceReference(kbInfo.getEndpoint(), dd);
        int pageSize = kbInfo.getPageSize();
        QueryExecutionFactory qef = (QueryExecutionFactory)((FluentQueryExecutionFactory)FluentQueryExecutionFactory.http((SparqlServiceReference)ssr).config().withRetry(this.retryCount, (long)this.retryDelayInMS, TimeUnit.MILLISECONDS).withDelay(this.requestDelayInMs, TimeUnit.MILLISECONDS).compose(internalQef -> pageSize > 0 && this.cacheDirectory == null ? new QueryExecutionFactoryPaginated(internalQef, (long)pageSize) : internalQef).end()).create();
        if (this.cacheDirectory != null) {
            String[] pathSegments = UriToPathUtils.toPathSegments((String)kbInfo.getEndpoint());
            Path cacheFolder = PathUtils.resolve((Path)Paths.get(this.cacheDirectory, new String[0]), (String[])pathSegments);
            AdvancedRangeCacheConfigImpl cacheConfig = AdvancedRangeCacheConfigImpl.createDefault();
            cacheConfig.setMaxRequestSize(pageSize > 0 ? (long)pageSize : Integer.MAX_VALUE);
            qef = QueryExecutionFactoryRangeCache.create((QueryExecutionFactory)qef, (Path)cacheFolder, (int)100, (AdvancedRangeCacheConfig)cacheConfig);
        } else {
            this.logger.info("The cache directory has not been set. Creating an uncached SPARQL client.");
        }
        return qef;
    }
}

