/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.datastrutures;

import java.util.List;
import org.aksw.limes.core.datastrutures.GoldStandard;
import org.aksw.limes.core.evaluation.evaluationDataLoader.EvaluationData;
import org.aksw.limes.core.evaluation.qualititativeMeasures.PseudoFMeasure;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.mapping.AMapping;

public class TaskData
implements Comparable<TaskData> {
    public String dataName;
    public ACache source;
    public ACache target;
    public AMapping mapping;
    public AMapping training;
    public PseudoFMeasure pseudoFMeasure;
    public GoldStandard goldStandard;
    public EvaluationData evalData;
    public AMapping initialMapping;

    public TaskData() {
    }

    public TaskData(GoldStandard goldStandard, AMapping mapping, ACache source, ACache target) {
        this.goldStandard = goldStandard;
        this.mapping = mapping;
        this.source = source;
        this.target = target;
    }

    public TaskData(GoldStandard goldStandard, ACache source, ACache target) {
        this.goldStandard = goldStandard;
        this.mapping = goldStandard.referenceMappings;
        this.source = source;
        this.target = target;
    }

    public TaskData(GoldStandard goldStandard, ACache source, ACache target, EvaluationData evalData) {
        this.goldStandard = goldStandard;
        this.mapping = goldStandard.referenceMappings;
        this.source = source;
        this.target = target;
        this.evalData = evalData;
    }

    public TaskData(AMapping mapping, GoldStandard goldStandard) {
        this.goldStandard = goldStandard;
        this.mapping = mapping;
    }

    public TaskData(AMapping mapping) {
        this.mapping = mapping;
    }

    public TaskData(String name) {
        this.dataName = name;
    }

    public List<String> getSourceURIs() {
        return this.source.getAllUris();
    }

    public List<String> getTargetURIs() {
        return this.target.getAllUris();
    }

    @Override
    public int compareTo(TaskData other) {
        return this.dataName.compareTo(other.dataName);
    }
}

