/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.measures;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import java.util.ArrayList;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.AEdgeCountingSemanticMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.finders.LeastCommonSubsumerFinder;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;

public class WuPalmerMeasure
extends AEdgeCountingSemanticMeasure {
    double maxValue = 1.0;

    public WuPalmerMeasure(AIndex Indexer) {
        super(Indexer);
    }

    public double calculate(ArrayList<ArrayList<ISynsetID>> synset1Tree, ArrayList<ArrayList<ISynsetID>> synset2Tree) {
        double sim = 0.0;
        LeastCommonSubsumerFinder finder = new LeastCommonSubsumerFinder();
        finder.getLeastCommonSubsumer(synset1Tree, synset2Tree);
        double depth = finder.getDepth();
        if (depth == -1.0) {
            return 0.0;
        }
        double length = finder.getSynsetsDistance();
        if (length == -1.0) {
            return 0.0;
        }
        sim = 2.0 * depth / (length + 2.0 * depth);
        return sim;
    }

    @Override
    public double getSimilarityBetweenConcepts(ISynset synset1, ISynset synset2) {
        ArrayList<ArrayList<ISynsetID>> paths1 = this.getPaths(synset1);
        ArrayList<ArrayList<ISynsetID>> paths2 = this.getPaths(synset2);
        if (paths1.isEmpty() || paths2.isEmpty()) {
            return 0.0;
        }
        if (synset1.getType() != synset2.getType()) {
            return 0.0;
        }
        if (synset1.getOffset() == synset2.getOffset()) {
            return this.maxValue;
        }
        return this.calculate(paths1, paths2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "wupalmer";
    }

    @Override
    public String getType() {
        return "semantic";
    }
}

