/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.semantic.edgecounting.measures;

import edu.mit.jwi.item.ISynset;
import edu.mit.jwi.item.ISynsetID;
import java.util.ArrayList;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.AEdgeCountingSemanticMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.finders.LeastCommonSubsumerFinder;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;

public class LiMeasure
extends AEdgeCountingSemanticMeasure {
    double a = 0.2;
    double b = 0.6;

    public LiMeasure(AIndex Indexer) {
        super(Indexer);
    }

    public double calculate(ArrayList<ArrayList<ISynsetID>> synset1Tree, ArrayList<ArrayList<ISynsetID>> synset2Tree) {
        LeastCommonSubsumerFinder finder = new LeastCommonSubsumerFinder();
        finder.getLeastCommonSubsumer(synset1Tree, synset2Tree);
        double depth = finder.getDepth();
        if (depth == -1.0) {
            return 0.0;
        }
        double length = finder.getSynsetsDistance();
        if (length == -1.0) {
            return 0.0;
        }
        double s1 = Math.pow(Math.E, -(this.a * length));
        double s2 = Math.pow(Math.E, this.b * depth);
        double s3 = Math.pow(Math.E, -(this.b * depth));
        double sim = s1 * ((s2 - s3) / (s2 + s3));
        return sim;
    }

    @Override
    public double getSimilarityBetweenConcepts(ISynset synset1, ISynset synset2) {
        ArrayList<ArrayList<ISynsetID>> paths1 = this.getPaths(synset1);
        ArrayList<ArrayList<ISynsetID>> paths2 = this.getPaths(synset2);
        if (paths1.isEmpty() || paths2.isEmpty()) {
            return 0.0;
        }
        if (synset1.getType() != synset2.getType()) {
            return 0.0;
        }
        return this.calculate(paths1, paths2);
    }

    @Override
    public double getRuntimeApproximation(double mappingSize) {
        return mappingSize / 1000.0;
    }

    @Override
    public String getName() {
        return "li";
    }

    @Override
    public String getType() {
        return "semantic";
    }
}

