/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.measure.pointsets.hausdorff;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.OrthodromicDistance;
import org.aksw.limes.core.measures.mapper.pointsets.Polygon;
import org.aksw.limes.core.measures.mapper.pointsets.PolygonIndex;
import org.aksw.limes.core.measures.measure.space.GeoGreatEllipticMeasure;

public class CentroidIndex
extends PolygonIndex {
    public static boolean USE_GREAT_ELLIPTIC_DISTANCE = true;
    public Map<String, Circle> centroids = new HashMap<String, Circle>();

    public double distance(Point x, Point y) {
        if (USE_GREAT_ELLIPTIC_DISTANCE) {
            return GeoGreatEllipticMeasure.getDistanceInDegrees(x, y);
        }
        return OrthodromicDistance.getDistanceInDegrees(x, y);
    }

    @Override
    public void index(Polygon p) {
        HashMap index = new HashMap();
        double maxDistance = 0.0;
        int from = -1;
        int to = -1;
        for (int i = 0; i < p.points.size(); ++i) {
            HashMap<Point, Double> distances = new HashMap<Point, Double>();
            for (int j = i + 1; j < p.points.size(); ++j) {
                double distance = this.distance(p.points.get(i), p.points.get(j));
                distances.put(p.points.get(j), distance);
                if (distance > maxDistance) {
                    maxDistance = distance;
                    from = i;
                    to = j;
                }
                ++this.computations;
            }
            if (distances.isEmpty()) continue;
            index.put(p.points.get(i), distances);
        }
        if (from >= 0) {
            this.centroids.put(p.uri, new Circle(this.average(p.points.get(from), p.points.get(to)), maxDistance / 2.0));
        } else {
            this.centroids.put(p.uri, new Circle(p.points.get(0), 0.0));
        }
        this.distanceIndex.put(p.uri, index);
        this.polygonIndex.put(p.uri, p);
    }

    public Point average(Point source, Point target) {
        ArrayList<Double> coordinates = new ArrayList<Double>();
        for (int i = 0; i < source.coordinates.size(); ++i) {
            coordinates.add((source.coordinates.get(i) + target.coordinates.get(i)) / 2.0);
        }
        Point center = new Point("", coordinates);
        return center;
    }

    public class Circle {
        public Point center;
        public double radius;

        public Circle(Point c, double r) {
            this.center = c;
            this.radius = r;
        }
    }
}

