/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.semantic.edgecounting;

import java.util.List;
import org.aksw.limes.core.exceptions.InvalidThresholdException;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.pointsets.PropertyFetcher;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.AEdgeCountingSemanticMeasure;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.factory.SemanticFactory;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.factory.SemanticType;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.AIndex;
import org.aksw.limes.core.measures.measure.semantic.edgecounting.indexing.memory.MemoryIndex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MarkerFactory;

public class EdgeCountingSemanticMapper
extends AMapper {
    static Logger logger = LoggerFactory.getLogger(EdgeCountingSemanticMapper.class);
    AEdgeCountingSemanticMeasure measure = null;
    AIndex Indexer = null;

    @Override
    public AMapping getMapping(ACache source, ACache target, String sourceVar, String targetVar, String expression, double threshold) {
        if (threshold <= 0.0) {
            throw new InvalidThresholdException(threshold);
        }
        List<String> properties = PropertyFetcher.getProperties(expression, threshold);
        if (properties.get(0) == null || properties.get(1) == null) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Property values could not be read. Exiting");
            throw new RuntimeException();
        }
        Parser p = new Parser(expression, threshold);
        if (!p.isAtomic()) {
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Mappers can only deal with atomic expression");
            logger.error(MarkerFactory.getMarker((String)"FATAL"), "Expression " + expression + " was given to a mapper to process");
        }
        AMapping m = MappingFactory.createDefaultMapping();
        this.Indexer = new MemoryIndex();
        this.Indexer.preIndex();
        SemanticType type = SemanticFactory.getMeasureType(expression);
        this.measure = SemanticFactory.createMeasure(type, this.Indexer);
        for (Instance sourceInstance : source.getAllInstances()) {
            for (Instance targetInstance : target.getAllInstances()) {
                double similarity = this.measure.getSimilarity(sourceInstance, targetInstance, properties.get(0), properties.get(1));
                if (!(similarity >= threshold)) continue;
                m.add(sourceInstance.getUri(), targetInstance.getUri(), similarity);
            }
        }
        this.Indexer.close();
        this.measure.close();
        return m;
    }

    @Override
    public double getRuntimeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public double getMappingSizeApproximation(int sourceSize, int targetSize, double theta, IMapper.Language language) {
        return 1000.0;
    }

    @Override
    public String getName() {
        return "Semantic Mapper";
    }
}

