/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.measures.mapper.pointsets;

import java.util.ArrayList;
import java.util.List;
import org.aksw.limes.core.datastrutures.Point;
import org.aksw.limes.core.measures.mapper.pointsets.GeoSquare;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKTReader;

public class Polygon {
    public List<Point> points;
    public String uri;

    public Polygon(String name) {
        this.uri = name;
        this.points = new ArrayList<Point>();
    }

    public Polygon(String name, List<Point> p) {
        this.uri = name;
        this.points = p;
    }

    public Polygon(Polygon polygon) {
        this.uri = polygon.uri;
        this.points = new ArrayList<Point>(polygon.points);
    }

    public void add(Point y) {
        this.points.add(y);
    }

    public void remove(Point y) {
        this.points.remove(y);
    }

    public String toString() {
        return "\nPolygon " + this.uri + " " + this.points.toString();
    }

    public long size() {
        return this.points.size();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof GeoSquare)) {
            return false;
        }
        Polygon o = (Polygon)obj;
        return this.points.equals(o.points);
    }

    public Geometry getGeometry() throws ParseException {
        String geometryString = "Polygon ((";
        for (Point p : this.points) {
            geometryString = geometryString + p.coordinates.get(0);
            geometryString = geometryString + " ";
            geometryString = geometryString + p.coordinates.get(1);
            geometryString = geometryString + ", ";
        }
        geometryString = geometryString.substring(0, geometryString.length() - 2);
        geometryString = geometryString + "))";
        WKTReader wktReader = new WKTReader();
        return wktReader.read(geometryString);
    }
}

