/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.io.cache;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.aksw.limes.core.io.cache.Instance;
import org.aksw.limes.core.io.cache.MemoryCache;
import org.aksw.limes.core.io.config.KBInfo;
import org.aksw.limes.core.io.query.IQueryModule;
import org.aksw.limes.core.io.query.NoPrefixSparqlQueryModule;
import org.aksw.limes.core.io.query.QueryModuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HybridCache
extends MemoryCache
implements Serializable {
    private static final long serialVersionUID = -2268344215686055231L;
    static Logger logger = LoggerFactory.getLogger((String)HybridCache.class.getName());
    protected TreeMap<String, Instance> instanceMap;
    protected Iterator<Instance> instanceIterator;
    private File folder = new File("");

    public HybridCache() {
        this.instanceMap = new TreeMap();
    }

    public HybridCache(File folder) {
        this();
        this.setFolder(folder);
    }

    public static HybridCache loadFromFile(File file) throws IOException {
        String path = file.getAbsolutePath();
        String parentPath = path.substring(0, path.lastIndexOf("cache"));
        File parent = new File(parentPath);
        FileInputStream in = new FileInputStream(file);
        ObjectInputStream deSerializer = new ObjectInputStream(in);
        try {
            HybridCache cache = (HybridCache)deSerializer.readObject();
            cache.setFolder(parent);
            HybridCache hybridCache = cache;
            return hybridCache;
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e);
        }
        finally {
            in.close();
        }
    }

    public static HybridCache getData(KBInfo kb) {
        return HybridCache.getData(new File(""), kb);
    }

    public static HybridCache getData(File folder, KBInfo kb) {
        HybridCache cache = new HybridCache(folder);
        String hash = kb.hashCode() + "";
        File cacheFile = new File(folder + "cache/" + hash + ".ser");
        logger.info("Checking for file " + cacheFile.getAbsolutePath());
        try {
            if (cacheFile.exists()) {
                logger.info("Found cached data. Loading data from file " + cacheFile.getAbsolutePath());
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info("Cached data loaded successfully from file " + cacheFile.getAbsolutePath());
            logger.info("Size = " + cache.size());
        }
        catch (Exception e) {
            logger.info("No cached data found for " + kb.getId());
            IQueryModule module = QueryModuleFactory.getQueryModule(kb.getType(), kb);
            module.fillCache(cache);
            if (!new File(folder.getAbsolutePath() + File.separatorChar + "cache").exists() || !new File(folder.getAbsolutePath() + File.separatorChar + "cache").isDirectory()) {
                new File(folder.getAbsolutePath() + File.separatorChar + "cache").mkdir();
            }
            cache.saveToFile(new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + hash + ".ser"));
        }
        return cache;
    }

    public static HybridCache getNoPrefixData(KBInfo kb) {
        return HybridCache.getNoPrefixData(new File(""), kb);
    }

    public static HybridCache getNoPrefixData(File folder, KBInfo kb) {
        HybridCache cache = new HybridCache();
        File cacheFile = new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser");
        try {
            if (cacheFile.exists()) {
                logger.info("Found cached data. Loading data from file " + cacheFile.getAbsolutePath());
                cache = HybridCache.loadFromFile(cacheFile);
            }
            if (cache.size() == 0) {
                throw new Exception();
            }
            logger.info("Cached data loaded successfully from file " + cacheFile.getAbsolutePath());
            logger.info("Size = " + cache.size());
        }
        catch (Exception e) {
            logger.info("No cached data found for " + kb.getId());
            NoPrefixSparqlQueryModule module = new NoPrefixSparqlQueryModule(kb);
            module.fillCache(cache);
            if (!new File(folder.getAbsolutePath() + File.separatorChar + "cache").exists() || !new File(folder.getAbsolutePath() + File.separatorChar + "cache").isDirectory()) {
                new File(folder.getAbsolutePath() + File.separatorChar + "cache").mkdir();
            }
            cache.saveToFile(new File(folder.getAbsolutePath() + File.separatorChar + "cache/" + kb.hashCode() + ".ser"));
        }
        return cache;
    }

    @Override
    public Instance getNextInstance() {
        if (this.instanceIterator == null) {
            this.instanceIterator = this.instanceMap.values().iterator();
        }
        if (this.instanceIterator.hasNext()) {
            return this.instanceIterator.next();
        }
        return null;
    }

    @Override
    public ArrayList<Instance> getAllInstances() {
        return new ArrayList<Instance>(this.instanceMap.values());
    }

    @Override
    public void addInstance(Instance i) {
        if (!this.instanceMap.containsKey(i.getUri())) {
            this.instanceMap.put(i.getUri(), i);
        }
    }

    @Override
    public Instance getInstance(String uri) {
        if (this.instanceMap.containsKey(uri)) {
            return this.instanceMap.get(uri);
        }
        return null;
    }

    @Override
    public int size() {
        return this.instanceMap.size();
    }

    @Override
    public void addTriple(String s, String p, String o) {
        if (this.instanceMap.containsKey(s)) {
            Instance m = this.instanceMap.get(s);
            m.addProperty(p, o);
        } else {
            Instance m = new Instance(s);
            m.addProperty(p, o);
            this.instanceMap.put(s, m);
        }
    }

    @Override
    public boolean containsUri(String uri) {
        return this.instanceMap.containsKey(uri.toString());
    }

    @Override
    public void resetIterator() {
        this.instanceIterator = this.instanceMap.values().iterator();
    }

    @Override
    public String toString() {
        return this.instanceMap.toString();
    }

    @Override
    public ArrayList<String> getAllUris() {
        return new ArrayList<String>(this.instanceMap.keySet());
    }

    @Override
    public boolean containsInstance(Instance i) {
        return this.instanceMap.containsKey(i.getUri());
    }

    public void saveToFile(File file) {
        logger.info("Serializing " + this.size() + " objects to " + file.getAbsolutePath());
        try {
            FileOutputStream out = new FileOutputStream(file);
            ObjectOutputStream serializer = new ObjectOutputStream(out);
            serializer.writeObject(this);
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            file.delete();
        }
    }

    public File getFolder() {
        return this.folder;
    }

    public void setFolder(File folder) {
        this.folder = folder;
    }
}

