/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.planner;

import java.util.ArrayList;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.MapperFactory;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureProcessor;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LigerPlanner
extends Planner {
    static Logger logger = LoggerFactory.getLogger(LigerPlanner.class);
    public ACache source;
    public ACache target;
    public IMapper.Language lang;

    public LigerPlanner(ACache source, ACache target) {
        this.source = source;
        this.target = target;
        this.lang = IMapper.Language.EN;
    }

    @Override
    public NestedPlan plan(LinkSpecification spec) {
        NestedPlan plan = new NestedPlan();
        if (spec == null) {
            return plan;
        }
        if (spec.isEmpty()) {
            return plan;
        }
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.getFilterExpression(), spec.getThreshold());
            plan.setInstructionList(new ArrayList<Instruction>());
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            MeasureType type = MeasureFactory.getMeasureType(p.getOperator());
            AMapper mapper = MapperFactory.createMapper(type);
            double runtimeEstimation = mapper.getRuntimeApproximation(this.source.size(), this.target.size(), spec.getThreshold(), IMapper.Language.EN);
            double sizeEstimation = mapper.getMappingSizeApproximation(this.source.size(), this.target.size(), spec.getThreshold(), IMapper.Language.EN);
            plan.setRuntimeCost(runtimeEstimation);
            plan.setMappingSize(sizeEstimation);
            plan.setSelectivity(sizeEstimation / ((double)this.source.size() * (double)this.target.size()));
            plan.setSelectivity(plan.getMappingSize() / (double)(this.source.size() * this.target.size()));
        } else {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.setRuntimeCost(0.0);
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child);
                children.add(childPlan);
                plan.setRuntimeCost(plan.getRuntimeCost() + childPlan.getRuntimeCost());
            }
            plan.setRuntimeCost(plan.getRuntimeCost() + (double)(spec.getChildren().size() - 1));
            plan.setSubPlans(children);
            plan.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            if (plan.getFilteringInstruction().getMeasureExpression() != null) {
                plan.setRuntimeCost(plan.getRuntimeCost() + MeasureProcessor.getCosts(plan.getFilteringInstruction().getMeasureExpression(), (double)(this.source.size() * this.target.size()) * plan.getSelectivity()));
            }
            if (spec.getOperator().equals((Object)LogicOperator.AND)) {
                plan.setOperator(Instruction.Command.INTERSECTION);
                double selectivity = 1.0;
                for (int i = 0; i < children.size(); ++i) {
                    selectivity *= ((NestedPlan)children.get(i)).getSelectivity();
                }
                plan.setSelectivity(0.5 * selectivity);
            } else if (spec.getOperator().equals((Object)LogicOperator.OR)) {
                plan.setOperator(Instruction.Command.UNION);
                double selectivity = 1.0 - ((NestedPlan)children.get(0)).getSelectivity();
                for (int i = 1; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
                }
                plan.setSelectivity(0.5 * (1.0 - selectivity));
            } else if (spec.getOperator().equals((Object)LogicOperator.MINUS)) {
                plan.setOperator(Instruction.Command.DIFF);
                double selectivity = ((NestedPlan)children.get(0)).getSelectivity();
                for (int i = 0; i < children.size(); ++i) {
                    selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
                }
                plan.setSelectivity(0.5 * selectivity);
            }
        }
        return plan;
    }

    @Override
    public boolean isStatic() {
        return true;
    }

    @Override
    public LinkSpecification normalize(LinkSpecification spec) {
        return spec;
    }
}

