/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.planning.planner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aksw.limes.core.datastrutures.LogicOperator;
import org.aksw.limes.core.execution.planning.plan.Instruction;
import org.aksw.limes.core.execution.planning.plan.NestedPlan;
import org.aksw.limes.core.execution.planning.planner.Planner;
import org.aksw.limes.core.io.cache.ACache;
import org.aksw.limes.core.io.ls.ExtendedLinkSpecification;
import org.aksw.limes.core.io.ls.LinkSpecification;
import org.aksw.limes.core.io.mapping.AMapping;
import org.aksw.limes.core.io.mapping.MappingFactory;
import org.aksw.limes.core.io.parser.Parser;
import org.aksw.limes.core.measures.mapper.AMapper;
import org.aksw.limes.core.measures.mapper.IMapper;
import org.aksw.limes.core.measures.mapper.MapperFactory;
import org.aksw.limes.core.measures.measure.MeasureFactory;
import org.aksw.limes.core.measures.measure.MeasureProcessor;
import org.aksw.limes.core.measures.measure.MeasureType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicPlanner
extends Planner {
    static Logger logger = LoggerFactory.getLogger(DynamicPlanner.class);
    private ACache source;
    private ACache target;
    private IMapper.Language lang;
    private Map<String, NestedPlan> plans = new HashMap<String, NestedPlan>();
    private Map<String, LinkSpecification> specifications = new HashMap<String, LinkSpecification>();
    private Map<String, LinkSpecification> dependencies = new HashMap<String, LinkSpecification>();

    public DynamicPlanner(ACache s, ACache t) {
        this.source = s;
        this.target = t;
        this.lang = IMapper.Language.EN;
    }

    public Map<String, NestedPlan> getPlans() {
        return this.plans;
    }

    public void init(LinkSpecification spec) {
        NestedPlan plan = new NestedPlan();
        if (!this.plans.containsKey(spec.toString())) {
            if (spec.isAtomic()) {
                this.plans.put(spec.toString(), plan);
                this.specifications.put(spec.toString(), spec);
            } else {
                for (LinkSpecification child : spec.getChildren()) {
                    this.init(child);
                }
                this.plans.put(spec.toString(), plan);
                this.specifications.put(spec.toString(), spec);
            }
        }
    }

    public void createDependencies(LinkSpecification spec) {
        for (Map.Entry<String, LinkSpecification> entry : this.specifications.entrySet()) {
            String dependentString = entry.getKey();
            LinkSpecification dependent = entry.getValue();
            if (!spec.getFullExpression().equals(dependent.getFullExpression()) || !(spec.getThreshold() < dependent.getThreshold())) continue;
            if (this.dependencies.containsKey(dependentString)) {
                LinkSpecification oldDependent = this.dependencies.get(dependentString);
                if (!(oldDependent.getThreshold() < spec.getThreshold())) continue;
                this.dependencies.put(dependentString, spec);
                continue;
            }
            this.dependencies.put(dependentString, spec);
        }
    }

    public String getDependency(LinkSpecification spec) {
        String specString = spec.toString();
        if (this.dependencies.containsKey(specString)) {
            return this.dependencies.get(spec.toString()).toString();
        }
        return null;
    }

    public double getAtomicRuntimeCosts(String measure, double threshold) {
        AMapper mapper = null;
        MeasureType type = MeasureFactory.getMeasureType(measure);
        mapper = MapperFactory.createMapper(type);
        return mapper.getRuntimeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
    }

    public double getAtomicMappingSizes(String measure, double threshold) {
        AMapper mapper = null;
        MeasureType type = MeasureFactory.getMeasureType(measure);
        mapper = MapperFactory.createMapper(type);
        return mapper.getMappingSizeApproximation(this.source.size(), this.target.size(), threshold, this.lang);
    }

    public boolean isExecuted(LinkSpecification spec) {
        return this.plans.get(spec.toString()).getExecutionStatus();
    }

    public double getFilterCosts(List<String> measures, int mappingSize) {
        double cost = 0.0;
        if (measures != null) {
            for (String measure : measures) {
                double tempCost = 0.0;
                MeasureType type = MeasureFactory.getMeasureType(measure);
                tempCost = MeasureFactory.createMeasure(type).getRuntimeApproximation(mappingSize);
                cost += tempCost;
            }
        }
        return cost;
    }

    public NestedPlan getPlan(LinkSpecification spec) {
        if (this.plans.containsKey(spec.toString())) {
            return this.plans.get(spec.toString());
        }
        return null;
    }

    public LinkSpecification getLinkSpec(NestedPlan plan) {
        for (Map.Entry<String, NestedPlan> entry : this.plans.entrySet()) {
            String spec = entry.getKey();
            NestedPlan value = entry.getValue();
            if (!value.equals(plan)) continue;
            return this.specifications.get(spec);
        }
        return null;
    }

    public void updatePlan(LinkSpecification spec, double rt, double selectivity, double msize) {
        if (!this.plans.containsKey(spec.toString())) {
            logger.error("Specification: " + spec.getFullExpression() + " was not initialised. Exiting..");
            throw new RuntimeException();
        }
        NestedPlan plan = this.plans.get(spec.toString());
        plan.setRuntimeCost(rt);
        plan.setSelectivity(selectivity);
        plan.setMappingSize(msize);
        plan.setExecutionStatus(true);
        this.plans.put(spec.toString(), plan);
        this.createDependencies(spec);
    }

    @Override
    public NestedPlan plan(LinkSpecification spec) {
        return this.plan(spec, this.source, this.target, MappingFactory.createDefaultMapping(), MappingFactory.createDefaultMapping());
    }

    public NestedPlan plan(LinkSpecification spec, ACache source, ACache target, AMapping sourceMapping, AMapping targetMapping) {
        NestedPlan plan = new NestedPlan();
        plan = this.plans.get(spec.toString());
        if (plan.getExecutionStatus()) {
            return plan;
        }
        plan = new NestedPlan();
        if (spec.isAtomic()) {
            Parser p = new Parser(spec.getFilterExpression(), spec.getThreshold());
            plan.setInstructionList(new ArrayList<Instruction>());
            plan.addInstruction(new Instruction(Instruction.Command.RUN, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            plan.setRuntimeCost(this.getAtomicRuntimeCosts(p.getOperator(), spec.getThreshold()));
            plan.setMappingSize(this.getAtomicMappingSizes(p.getOperator(), spec.getThreshold()));
            plan.setSelectivity(plan.getMappingSize() / (double)(source.size() * target.size()));
        } else if (spec.getOperator().equals((Object)LogicOperator.OR)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            double runtimeCost = 0.0;
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
                runtimeCost += childPlan.getRuntimeCost();
            }
            plan.setRuntimeCost(runtimeCost + (double)(spec.getChildren().size() - 1));
            plan.setSubPlans(children);
            plan.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            plan.setOperator(Instruction.Command.UNION);
            double selectivity = 1.0 - ((NestedPlan)children.get(0)).getSelectivity();
            for (int i = 1; i < children.size(); ++i) {
                selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
            }
            plan.setSelectivity(1.0 - selectivity);
            plan.setMappingSize((double)(source.size() * target.size()) * plan.getSelectivity());
            if (plan.getFilteringInstruction().getMeasureExpression() != null) {
                plan.setRuntimeCost(plan.getRuntimeCost() + MeasureProcessor.getCosts(plan.getFilteringInstruction().getMeasureExpression(), (double)(source.size() * target.size()) * plan.getSelectivity()));
            }
        } else if (spec.getOperator().equals((Object)LogicOperator.XOR)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            double runtimeCost = 0.0;
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
                runtimeCost += childPlan.getRuntimeCost();
            }
            plan.setRuntimeCost(runtimeCost + (double)(spec.getChildren().size() - 1));
            plan.setSubPlans(children);
            plan.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            plan.setOperator(Instruction.Command.XOR);
            double selectivity = ((NestedPlan)children.get(0)).getSelectivity();
            for (int i = 1; i < children.size(); ++i) {
                selectivity = (1.0 - (1.0 - selectivity) * (1.0 - ((NestedPlan)children.get(i)).getSelectivity())) * (1.0 - selectivity * ((NestedPlan)children.get(i)).getSelectivity());
            }
            plan.setSelectivity(selectivity);
            plan.setMappingSize((double)(source.size() * target.size()) * plan.getSelectivity());
            if (plan.getFilteringInstruction().getMeasureExpression() != null) {
                plan.setRuntimeCost(plan.getRuntimeCost() + MeasureProcessor.getCosts(plan.getFilteringInstruction().getMeasureExpression(), (double)(source.size() * target.size()) * plan.getSelectivity()));
            }
        } else if (spec.getOperator().equals((Object)LogicOperator.MINUS)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.setRuntimeCost(0.0);
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
            }
            double selectivity = ((NestedPlan)children.get(0)).getSelectivity();
            for (int i = 1; i < children.size(); ++i) {
                selectivity *= 1.0 - ((NestedPlan)children.get(i)).getSelectivity();
            }
            plan = this.getBestDifferencePlan(spec, (NestedPlan)children.get(0), (NestedPlan)children.get(1), selectivity);
        } else if (spec.getOperator().equals((Object)LogicOperator.AND)) {
            ArrayList<NestedPlan> children = new ArrayList<NestedPlan>();
            plan.setRuntimeCost(0.0);
            for (LinkSpecification child : spec.getChildren()) {
                NestedPlan childPlan = this.plan(child, source, target, sourceMapping, targetMapping);
                children.add(childPlan);
            }
            double selectivity = 1.0;
            for (int i = 0; i < children.size(); ++i) {
                selectivity *= ((NestedPlan)children.get(i)).getSelectivity();
            }
            plan = this.getBestConjunctivePlan(spec, (NestedPlan)children.get(0), (NestedPlan)children.get(1), selectivity);
        }
        this.plans.put(spec.toString(), plan);
        return plan;
    }

    public NestedPlan getBestDifferencePlan(LinkSpecification spec, NestedPlan left, NestedPlan right, double selectivity) {
        double min;
        double runtime1 = 0.0;
        double runtime2 = 0.0;
        NestedPlan result = new NestedPlan();
        double mappingSize = (double)(this.source.size() * this.target.size()) * selectivity;
        if (left.getExecutionStatus() && right.getExecutionStatus()) {
            result.setOperator(Instruction.Command.DIFF);
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            plans.add(right);
            result.setSubPlans(plans);
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            result.setRuntimeCost(0.0);
            result.setSelectivity(selectivity);
            result.setMappingSize(mappingSize);
            return result;
        }
        if (!left.getExecutionStatus() && right.getExecutionStatus()) {
            result.setOperator(Instruction.Command.DIFF);
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            plans.add(right);
            result.setSubPlans(plans);
            result.setRuntimeCost(left.getRuntimeCost());
            result.setSelectivity(selectivity);
            result.setMappingSize(mappingSize);
            return result;
        }
        if (!left.getExecutionStatus()) {
            runtime1 = left.getRuntimeCost();
        }
        runtime1 += right.getRuntimeCost();
        result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
        if (result.getFilteringInstruction().getMeasureExpression() != null) {
            runtime1 += MeasureProcessor.getCosts(result.getFilteringInstruction().getMeasureExpression(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * selectivity));
        }
        if (!left.getExecutionStatus()) {
            runtime2 = left.getRuntimeCost();
        }
        if ((min = Math.min(runtime1, runtime2 += this.getFilterCosts(right.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * right.getSelectivity())))) == runtime1) {
            result.setOperator(Instruction.Command.DIFF);
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            plans.add(right);
            result.setSubPlans(plans);
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
        } else if (min == runtime2) {
            String rightChild = spec.getChildren().get(1).getFullExpression();
            result.setFilteringInstruction(new Instruction(Instruction.Command.REVERSEFILTER, rightChild, spec.getChildren().get(1).getThreshold() + "", -1, -1, 0));
            result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
            result.setOperator(null);
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            result.setSubPlans(plans);
        }
        result.setRuntimeCost(min);
        result.setSelectivity(selectivity);
        result.setMappingSize(mappingSize);
        return result;
    }

    public NestedPlan getBestConjunctivePlan(LinkSpecification spec, NestedPlan left, NestedPlan right, double selectivity) {
        double runtime1 = 0.0;
        double runtime2 = 0.0;
        double runtime3 = 0.0;
        NestedPlan result = new NestedPlan();
        if (left.getExecutionStatus() && right.getExecutionStatus()) {
            result.setOperator(Instruction.Command.INTERSECTION);
            ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
            plans.add(left);
            plans.add(right);
            result.setSubPlans(plans);
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            result.setRuntimeCost(0.0);
            result.setSelectivity(selectivity);
            result.setMappingSize((double)(this.source.size() * this.target.size()) * selectivity);
            return result;
        }
        if (left.getExecutionStatus() && !right.getExecutionStatus()) {
            double min;
            runtime1 = right.getRuntimeCost();
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            if (result.getFilteringInstruction().getMeasureExpression() != null) {
                runtime1 += MeasureProcessor.getCosts(result.getFilteringInstruction().getMeasureExpression(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * selectivity));
            }
            if ((min = Math.min(runtime1, runtime2 = this.getFilterCosts(right.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * right.getSelectivity())))) == runtime1) {
                result.setOperator(Instruction.Command.INTERSECTION);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(left);
                plans.add(right);
                result.setSubPlans(plans);
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            } else {
                String rightChild = spec.getChildren().get(1).getFullExpression();
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, rightChild, spec.getChildren().get(1).getThreshold() + "", -1, -1, 0));
                result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
                result.setOperator(null);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(left);
                result.setSubPlans(plans);
            }
            result.setRuntimeCost(min);
            result.setSelectivity(selectivity);
            result.setMappingSize((double)(this.source.size() * this.target.size()) * selectivity);
            return result;
        }
        if (!left.getExecutionStatus() && right.getExecutionStatus()) {
            double min;
            runtime1 = left.getRuntimeCost();
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            if (result.getFilteringInstruction().getMeasureExpression() != null) {
                runtime1 += MeasureProcessor.getCosts(result.getFilteringInstruction().getMeasureExpression(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * selectivity));
            }
            if ((min = Math.min(runtime1, runtime3 = this.getFilterCosts(left.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * left.getSelectivity())))) == runtime1) {
                result.setOperator(Instruction.Command.INTERSECTION);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(right);
                plans.add(left);
                result.setSubPlans(plans);
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            } else {
                String leftChild = spec.getChildren().get(0).getFullExpression();
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, leftChild, spec.getChildren().get(0).getThreshold() + "", -1, -1, 0));
                result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
                result.setOperator(null);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(right);
                result.setSubPlans(plans);
            }
            result.setRuntimeCost(min);
            result.setSelectivity(selectivity);
            result.setMappingSize((double)(this.source.size() * this.target.size()) * selectivity);
            return result;
        }
        if (!left.getExecutionStatus() && !right.getExecutionStatus()) {
            runtime1 = left.getRuntimeCost() + right.getRuntimeCost();
            result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            if (result.getFilteringInstruction().getMeasureExpression() != null) {
                runtime1 += MeasureProcessor.getCosts(result.getFilteringInstruction().getMeasureExpression(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * selectivity));
            }
            runtime2 = left.getRuntimeCost();
            runtime3 = right.getRuntimeCost();
            double min = Math.min(Math.min(runtime3 += this.getFilterCosts(left.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * left.getSelectivity())), runtime2 += this.getFilterCosts(right.getAllMeasures(), (int)Math.ceil((double)(this.source.size() * this.target.size()) * right.getSelectivity()))), runtime1);
            if (min == runtime1) {
                result.setOperator(Instruction.Command.INTERSECTION);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(left);
                plans.add(right);
                result.setSubPlans(plans);
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, spec.getFilterExpression(), spec.getThreshold() + "", -1, -1, 0));
            } else if (min == runtime2) {
                String rightChild = spec.getChildren().get(1).getFullExpression();
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, rightChild, spec.getChildren().get(1).getThreshold() + "", -1, -1, 0));
                result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
                result.setOperator(null);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(left);
                result.setSubPlans(plans);
            } else {
                String leftChild = spec.getChildren().get(0).getFullExpression();
                result.setFilteringInstruction(new Instruction(Instruction.Command.FILTER, leftChild, spec.getChildren().get(0).getThreshold() + "", -1, -1, 0));
                result.getFilteringInstruction().setMainThreshold(spec.getThreshold() + "");
                result.setOperator(null);
                ArrayList<NestedPlan> plans = new ArrayList<NestedPlan>();
                plans.add(right);
                result.setSubPlans(plans);
            }
            result.setRuntimeCost(min);
            result.setSelectivity(selectivity);
            result.setMappingSize((double)(this.source.size() * this.target.size()) * selectivity);
            return result;
        }
        return result;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public LinkSpecification normalize(LinkSpecification spec) {
        if (spec.isEmpty()) {
            return spec;
        }
        ExtendedLinkSpecification ls = new ExtendedLinkSpecification(spec.getFullExpression(), spec.getThreshold());
        this.init(ls);
        return ls;
    }
}

