/*
 * Decompiled with CFR 0.152.
 */
package org.aksw.limes.core.execution.engine;

import org.aksw.limes.core.execution.engine.ExecutionEngine;
import org.aksw.limes.core.execution.engine.SimpleExecutionEngine;
import org.aksw.limes.core.execution.engine.partialrecallengine.PartialRecallExecutionEngine;
import org.aksw.limes.core.io.cache.ACache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutionEngineFactory {
    private static final Logger logger = LoggerFactory.getLogger(ExecutionEngineFactory.class);
    public static final String DEFAULT = "default";
    public static final String SIMPLE = "simple";
    public static final String PARTIAL_RECALL = "partial_recall";

    public static ExecutionEngineType getExecutionEngineType(String name) {
        if (name.equalsIgnoreCase(DEFAULT)) {
            return ExecutionEngineType.DEFAULT;
        }
        if (name.equalsIgnoreCase(SIMPLE)) {
            return ExecutionEngineType.SIMPLE;
        }
        if (name.equalsIgnoreCase(PARTIAL_RECALL)) {
            return ExecutionEngineType.PARTIAL_RECALL;
        }
        logger.error("Sorry, " + name + " is not yet implemented. Returning the default execution engine type instead...");
        return ExecutionEngineType.DEFAULT;
    }

    public static ExecutionEngine getEngine(ExecutionEngineType type, ACache source, ACache target, String sourceVar, String targetVar, long maxOpt, double k) {
        switch (type) {
            case DEFAULT: 
            case SIMPLE: {
                return new SimpleExecutionEngine(source, target, sourceVar, targetVar);
            }
            case PARTIAL_RECALL: {
                return new PartialRecallExecutionEngine(source, target, sourceVar, targetVar, maxOpt, k);
            }
        }
        logger.error("Sorry, " + (Object)((Object)type) + " is not yet implemented. Returning the default execution engine instead...");
        return new SimpleExecutionEngine(source, target, sourceVar, targetVar);
    }

    public static enum ExecutionEngineType {
        DEFAULT,
        SIMPLE,
        PARTIAL_RECALL;

    }
}

